/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Category;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.persistence.sql.SqlObjectStore;
import org.nakedobjects.utility.ConfigurationParameters;

public abstract class DatabaseAccess {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$persistence$sql$SqlObjectMapper == null ? (class$org$nakedobjects$persistence$sql$SqlObjectMapper = DatabaseAccess.class$("org.nakedobjects.persistence.sql.SqlObjectMapper")) : class$org$nakedobjects$persistence$sql$SqlObjectMapper));
    private static final String USER = "nakedobjects.sql-object-store.user";
    private static final String PASSWORD = "nakedobjects.sql-object-store.password";
    private static final String DRIVER = "nakedobjects.sql-object-store.driver";
    private static final String DATABASE_URL = "nakedobjects.sql-object-store.database";
    private static final String TABLE_TABLE = "nakedobjects.sql-object-store.table-table";
    private static final String TABLE_COLUMN = "nakedobjects.sql-object-store.table-column";
    private static Connection connection = null;
    protected final SqlObjectStore store;
    static /* synthetic */ Class class$org$nakedobjects$persistence$sql$SqlObjectMapper;

    public DatabaseAccess(SqlObjectStore sqlObjectStore) {
        this.store = sqlObjectStore;
    }

    protected boolean databaseContainsTable(String string) throws ObjectStoreException {
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, stringArray);
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            throw new ObjectStoreException(sQLException);
        }
    }

    public void commit() throws ObjectStoreException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            LOG.error((Object)"SQL error during commit", (Throwable)sQLException);
            throw new ObjectStoreException("SQL error during commit", sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long createKey() throws ObjectStoreException {
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                statement.execute("update no_ids set id = id + 1");
                ResultSet resultSet = statement.executeQuery("select id from no_ids");
                if (!resultSet.next()) {
                    LOG.error((Object)"Table IDS not set up properly");
                    throw new ObjectStoreException("Table IDS not set up properly");
                }
                this.commit();
                long l = resultSet.getLong("id");
                Object var6_5 = null;
                if (statement == null) return l;
                try {
                    statement.close();
                    return l;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return l;
            }
            catch (SQLException sQLException) {
                throw new ObjectStoreException("Problem getting ID", sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (statement == null) throw throwable;
            try {}
            catch (SQLException sQLException) {
                throw throwable;
            }
            statement.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void execute(String string) throws ObjectStoreException {
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                throw new ObjectStoreException("SQL error (" + sQLException.getMessage() + ") in " + string, sQLException);
            }
            Object var5_3 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        statement.close();
        return;
    }

    Connection getConnection() throws ObjectStoreException {
        if (connection == null) {
            ConfigurationParameters configurationParameters = ConfigurationParameters.getInstance();
            String string = configurationParameters.getString(DRIVER);
            if (string == null) {
                throw new ObjectStoreException("No driver specified: nakedobjects.sql-object-store.driver");
            }
            String string2 = configurationParameters.getString(DATABASE_URL);
            if (string2 == null) {
                throw new ObjectStoreException("No url specified: nakedobjects.sql-object-store.database");
            }
            String string3 = configurationParameters.getString(USER);
            if (string3 == null) {
                throw new ObjectStoreException("No user specified: nakedobjects.sql-object-store.user");
            }
            String string4 = configurationParameters.getString(PASSWORD);
            if (string4 == null) {
                throw new ObjectStoreException("No password specified: nakedobjects.sql-object-store.password");
            }
            try {
                Class.forName(string);
                connection = DriverManager.getConnection(string2, string3, string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.error((Object)("Can't load driver " + string));
                throw new ObjectStoreException("Can't load driver " + string, classNotFoundException);
            }
            catch (SQLException sQLException) {
                LOG.error((Object)"SQL Exception", (Throwable)sQLException);
                throw new ObjectStoreException("SQL Exception", sQLException);
            }
        }
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasRow(String string) throws ObjectStoreException {
        Statement statement = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                boolean bl = resultSet.next();
                Object var6_6 = null;
                if (statement == null) return bl;
                try {
                    statement.close();
                    return bl;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return bl;
            }
            catch (SQLException sQLException) {
                throw new ObjectStoreException("SQL error (" + sQLException.getMessage() + ") in " + string, sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (statement == null) throw throwable;
            try {}
            catch (SQLException sQLException) {
                throw throwable;
            }
            statement.close();
            throw throwable;
        }
    }

    void rollback() throws ObjectStoreException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException sQLException) {
            LOG.error((Object)"SQL error during rollback", (Throwable)sQLException);
            throw new ObjectStoreException("SQL error during rollback", sQLException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

