sub max {
    my $max_value = 0;
    foreach $value ( @_) {
        if ($value > $max_value) {
            $max_value = $value;
            }
        }
    return $max_value;
    }

sub min {
    my $min_value = 1000000;
    foreach $value ( @_ ) {
        if ($value < $min_value) {
            $min_value = $value;
            }
        }
    return $min_value;
    }
    

open IN, "inputs.txt";
open OUT, ">outputs.txt";

#In perl, the first command line argument is $ARGV[0].
$period= $ARGV[0];  
$slowing= $ARGV[1];  
$averaging = $ARGV[2];  

$dline = 0;
$count = 0;

while (defined($line=<IN>)) {
    chomp $line;
    ($high[$count], $low[$count], $close[$count]) = split / /, $line;
    if ($count < $period-1+$slowing) {
        print OUT "0.0 0.0\n";
        $stoch[$count] = 0;
        }
    else {
        $closing = 0;
        $denom = 0;
        for ($i=0; $i<$slowing; $i++) {
            $max_high = max(@high[$count-$period-$i+1 .. $count-$i]);
            $min_low = min(@low[$count-$period-$i+1 .. $count-$i]);
            $closing += $close[$count-$i] - $min_low;
            $denom += $max_high - $min_low;
            }
        $stoch[$count] = $closing/$denom*100;
        $dline = $stoch[$count] + $dline - $stoch[$count-$averaging];
        $kline = $stoch[$count];
        $davg = $dline/$averaging;
        print OUT "$kline $davg\n";
        }
    $count++;       
    }
close OUT;
close IN;
open DONE, ">done.txt";
print DONE "Done\n";
close DONE;