/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Header;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class Document
implements DocListener {
    private static final String ITEXT_VERSION = "iText by lowagie.com (r0.94 - paulo 102)";
    public static boolean compress = true;
    private ArrayList listeners = new ArrayList();
    protected boolean open;
    protected boolean close;
    protected Rectangle pageSize;
    protected Watermark watermark = null;
    protected float marginLeft = 0.0f;
    protected float marginRight = 0.0f;
    protected float marginTop = 0.0f;
    protected float marginBottom = 0.0f;
    protected int pageN = 0;
    protected HeaderFooter header = null;
    protected HeaderFooter footer = null;

    public Document() {
        this(PageSize.A4);
    }

    public Document(Rectangle rectangle) {
        this(rectangle, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document(Rectangle rectangle, float f2, float f3, float f4, float f5) {
        this.pageSize = rectangle;
        this.marginLeft = f2;
        this.marginRight = f3;
        this.marginTop = f4;
        this.marginBottom = f5;
    }

    public void addDocListener(DocListener docListener) {
        this.listeners.add(docListener);
    }

    public void removeDocListener(DocListener docListener) {
        ((AbstractCollection)this.listeners).remove(docListener);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.close) {
            throw new DocumentException("The document has been closed. You can't add any Elements.");
        }
        int n2 = element.type();
        if (this.open) {
            if (n2 != 10 && n2 != 11 && n2 != 12 && n2 != 22 && n2 != 23 && n2 != 17 && n2 != 29 && n2 != 16 && n2 != 13 && n2 != 14 && n2 != 15 && n2 != 30 && n2 != 33 && n2 != 32 && n2 != 31 && n2 != 34 && n2 != 35 && n2 != 39) {
                throw new DocumentException("The document is open; you can only add Elements with content.");
            }
        } else if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 7 && n2 != 6) {
            throw new DocumentException("The document is not open yet; you can only add Meta information.");
        }
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            bl |= docListener.add(element);
        }
        return bl;
    }

    public void open() {
        if (!this.close) {
            this.open = true;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageSize(this.pageSize);
            docListener.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
            docListener.open();
        }
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.pageSize = rectangle;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageSize(rectangle);
        }
        return true;
    }

    public boolean add(Watermark watermark) {
        this.watermark = watermark;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.add(watermark);
        }
        return true;
    }

    public void removeWatermark() {
        this.watermark = null;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.removeWatermark();
        }
    }

    public boolean setMargins(float f2, float f3, float f4, float f5) {
        this.marginLeft = f2;
        this.marginRight = f3;
        this.marginTop = f4;
        this.marginBottom = f5;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setMargins(f2, f3, f4, f5);
        }
        return true;
    }

    public boolean newPage() throws DocumentException {
        if (!this.open || this.close) {
            return false;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.newPage();
        }
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setHeader(headerFooter);
        }
    }

    public void resetHeader() {
        this.header = null;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetHeader();
        }
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setFooter(headerFooter);
        }
    }

    public void resetFooter() {
        this.footer = this.footer;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetFooter();
        }
    }

    public void resetPageCount() {
        this.pageN = 0;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.resetPageCount();
        }
    }

    public void setPageCount(int n2) {
        this.pageN = n2;
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.setPageCount(n2);
        }
    }

    public int getPageNumber() {
        return this.pageN;
    }

    public void close() {
        if (!this.close) {
            this.open = false;
            this.close = true;
        }
        Iterator iterator = ((AbstractList)this.listeners).iterator();
        while (iterator.hasNext()) {
            DocListener docListener = (DocListener)iterator.next();
            docListener.close();
        }
    }

    public boolean addHeader(String string, String string2) {
        try {
            return this.add(new Header(string, string2));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addTitle(String string) {
        try {
            return this.add(new Meta(1, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addSubject(String string) {
        try {
            return this.add(new Meta(2, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addKeywords(String string) {
        try {
            return this.add(new Meta(3, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addAuthor(String string) {
        try {
            return this.add(new Meta(4, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addCreator(String string) {
        try {
            return this.add(new Meta(7, string));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addProducer() {
        try {
            return this.add(new Meta(5, "iText by lowagie.com"));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public boolean addCreationDate() {
        try {
            return this.add(new Meta(6, new Date().toString()));
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    public float leftMargin() {
        return this.marginLeft;
    }

    public float rightMargin() {
        return this.marginRight;
    }

    public float topMargin() {
        return this.marginTop;
    }

    public float bottomMargin() {
        return this.marginBottom;
    }

    public float left() {
        return this.pageSize.left(this.marginLeft);
    }

    public float right() {
        return this.pageSize.right(this.marginRight);
    }

    public float top() {
        return this.pageSize.top(this.marginTop);
    }

    public float bottom() {
        return this.pageSize.bottom(this.marginBottom);
    }

    public float left(float f2) {
        return this.pageSize.left(this.marginLeft + f2);
    }

    public float right(float f2) {
        return this.pageSize.right(this.marginRight + f2);
    }

    public float top(float f2) {
        return this.pageSize.top(this.marginTop + f2);
    }

    public float bottom(float f2) {
        return this.pageSize.bottom(this.marginBottom + f2);
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public boolean isOpen() {
        return this.open;
    }

    public static String getVersion() {
        return ITEXT_VERSION;
    }
}

