/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TrueTypeFontSubSet;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;

class TrueTypeFont
extends BaseFont {
    static final String[] codePages = new String[]{"1252 Latin 1", "1250 Latin 2: Eastern Europe", "1251 Cyrillic", "1253 Greek", "1254 Turkish", "1255 Hebrew", "1256 Arabic", "1257 Windows Baltic", "1258 Vietnamese", null, null, null, null, null, null, null, "874 Thai", "932 JIS/Japan", "936 Chinese: Simplified chars--PRC and Singapore", "949 Korean Wansung", "950 Chinese: Traditional chars--Taiwan and Hong Kong", "1361 Korean Johab", null, null, null, null, null, null, null, "Macintosh Character Set (US Roman)", "OEM Character Set", "Symbol Character Set", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "869 IBM Greek", "866 MS-DOS Russian", "865 MS-DOS Nordic", "864 Arabic", "863 MS-DOS Canadian French", "862 Hebrew", "861 MS-DOS Icelandic", "860 MS-DOS Portuguese", "857 IBM Turkish", "855 IBM Cyrillic; primarily Russian", "852 Latin 2", "775 MS-DOS Baltic", "737 Greek; former 437 G", "708 Arabic; ASMO 708", "850 WE/Latin 1", "437 US"};
    protected boolean justNames = false;
    protected HashMap tables;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean cff = false;
    protected int cffOffset;
    protected int cffLength;
    protected int directoryOffset;
    protected String ttcIndex;
    protected String style = "";
    protected FontHeader head = new FontHeader();
    protected HorizontalHeader hhea = new HorizontalHeader();
    protected WindowsMetrics os_2 = new WindowsMetrics();
    protected int[] GlyphWidths;
    protected HashMap cmap10;
    protected HashMap cmap31;
    protected HashMap kerning;
    protected String fontName;
    protected String[][] fullName;
    protected String[][] familyName;
    protected double italicAngle;
    protected boolean isFixedPitch = false;

    protected TrueTypeFont() {
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray) throws DocumentException, IOException {
        this(string, string2, bl, byArray, false);
    }

    TrueTypeFont(String string, String string2, boolean bl, byte[] byArray, boolean bl2) throws DocumentException, IOException {
        this.justNames = bl2;
        String string3 = BaseFont.getBaseName(string);
        String string4 = TrueTypeFont.getTTCName(string3);
        if (string3.length() < string.length()) {
            this.style = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl;
        this.fileName = string4;
        this.fontType = 1;
        this.ttcIndex = "";
        if (string4.length() < string3.length()) {
            this.ttcIndex = string3.substring(string4.length() + 1);
        }
        if (!(this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc"))) {
            throw new DocumentException(this.fileName + this.style + " is not a TTF, OTF or TTC font file.");
        }
        this.process(byArray);
        try {
            " ".getBytes(string2);
            this.createEncoding();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DocumentException(unsupportedEncodingException.getMessage());
        }
    }

    protected static String getTTCName(String string) {
        int n2 = string.toLowerCase().indexOf(".ttc,");
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2 + 4);
    }

    void fillTables() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("hhea");
        if (nArray == null) {
            throw new DocumentException("Table 'hhea' does not exist " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
        nArray = (int[])this.tables.get("OS/2");
        if (nArray == null) {
            throw new DocumentException("Table 'OS/2' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        int n2 = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (n2 > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (n2 > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
        nArray = (int[])this.tables.get("post");
        if (nArray == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(nArray[0] + 4);
        short s2 = this.rf.readShort();
        int n3 = this.rf.readUnsignedShort();
        this.italicAngle = (double)s2 + (double)n3 / 16384.0;
        this.rf.skipBytes(4);
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n2 = this.rf.readUnsignedShort();
        int n3 = this.rf.readUnsignedShort();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            int n10 = this.rf.readUnsignedShort();
            if (n8 == 6) {
                this.rf.seek(nArray[0] + n3 + n10);
                if (n5 == 0 || n5 == 3) {
                    return this.readUnicodeString(n9);
                }
                return this.readStandardString(n9);
            }
            ++n4;
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '-');
    }

    String[][] getNames(int n2) throws DocumentException, IOException {
        int n3;
        int[] nArray = (int[])this.tables.get("name");
        if (nArray == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0] + 2);
        int n4 = this.rf.readUnsignedShort();
        int n5 = this.rf.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = this.rf.readUnsignedShort();
            n3 = this.rf.readUnsignedShort();
            int n8 = this.rf.readUnsignedShort();
            int n9 = this.rf.readUnsignedShort();
            int n10 = this.rf.readUnsignedShort();
            int n11 = this.rf.readUnsignedShort();
            if (n9 == n2) {
                int n12 = this.rf.getFilePointer();
                this.rf.seek(nArray[0] + n5 + n11);
                String string = n7 == 0 || n7 == 3 || n7 == 2 && n3 == 1 ? this.readUnicodeString(n10) : this.readStandardString(n10);
                arrayList.add(new String[]{String.valueOf(n7), String.valueOf(n3), String.valueOf(n8), string});
                this.rf.seek(n12);
            }
            ++n6;
        }
        String[][] stringArray = new String[arrayList.size()][];
        n3 = 0;
        while (n3 < arrayList.size()) {
            stringArray[n3] = (String[])arrayList.get(n3);
            ++n3;
        }
        return stringArray;
    }

    void checkCff() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("CFF ");
        if (nArray != null) {
            this.cff = true;
            this.cffOffset = nArray[0];
            this.cffLength = nArray[1];
        }
    }

    void process(byte[] byArray) throws DocumentException, IOException {
        block12: {
            this.tables = new HashMap();
            try {
                int n2;
                int n3;
                this.rf = byArray == null ? new RandomAccessFileOrArray(this.fileName) : new RandomAccessFileOrArray(byArray);
                if (this.ttcIndex.length() > 0) {
                    n3 = Integer.parseInt(this.ttcIndex);
                    if (n3 < 0) {
                        throw new DocumentException("The font index for " + this.fileName + " must be positive.");
                    }
                    String string = this.readStandardString(4);
                    if (!string.equals("ttcf")) {
                        throw new DocumentException(this.fileName + " is not a valid TTC file.");
                    }
                    this.rf.skipBytes(4);
                    n2 = this.rf.readInt();
                    if (n3 >= n2) {
                        throw new DocumentException("The font index for " + this.fileName + " must be between 0 and " + (n2 - 1) + ". It was " + n3 + ".");
                    }
                    this.rf.skipBytes(n3 * 4);
                    this.directoryOffset = this.rf.readInt();
                }
                this.rf.seek(this.directoryOffset);
                n3 = this.rf.readInt();
                if (n3 != 65536 && n3 != 0x4F54544F) {
                    throw new DocumentException(this.fileName + " is not a valid TTF or OTF file.");
                }
                int n4 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                n2 = 0;
                while (n2 < n4) {
                    String string = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(string, nArray);
                    ++n2;
                }
                this.checkCff();
                this.fontName = this.getBaseFont();
                this.fullName = this.getNames(4);
                this.familyName = this.getNames(1);
                if (!this.justNames) {
                    this.fillTables();
                    this.readGlyphWidths();
                    this.readCMaps();
                    this.readKerning();
                }
                Object var8_8 = null;
                if (this.rf == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (this.rf != null) {
                    this.rf.close();
                    if (!this.embedded) {
                        this.rf = null;
                    }
                }
                throw throwable;
            }
            this.rf.close();
            if (!this.embedded) {
                this.rf = null;
            }
        }
    }

    protected String readStandardString(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected String readUnicodeString(int n2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        n2 /= 2;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(this.rf.readChar());
            ++n3;
        }
        return stringBuffer.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] nArray = (int[])this.tables.get("hmtx");
        if (nArray == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        int n2 = 0;
        while (n2 < this.hhea.numberOfHMetrics) {
            this.GlyphWidths[n2] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
            ++n2;
        }
    }

    public int getGlyphWidth(int n2) {
        if (n2 >= this.GlyphWidths.length) {
            n2 = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[n2];
    }

    void readCMaps() throws DocumentException, IOException {
        int n2;
        int[] nArray = (int[])this.tables.get("cmap");
        if (nArray == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(nArray[0]);
        this.rf.skipBytes(2);
        int n3 = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            n2 = this.rf.readUnsignedShort();
            int n7 = this.rf.readUnsignedShort();
            int n8 = this.rf.readInt();
            if (n2 == 3 && n7 == 0) {
                this.fontSpecific = true;
            } else if (n2 == 3 && n7 == 1) {
                n5 = n8;
            }
            if (n2 == 1 && n7 == 0) {
                n4 = n8;
            }
            ++n6;
        }
        if (n4 > 0) {
            this.rf.seek(nArray[0] + n4);
            n2 = this.rf.readUnsignedShort();
            switch (n2) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (n5 > 0) {
            this.rf.seek(nArray[0] + n5);
            n2 = this.rf.readUnsignedShort();
            if (n2 == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
    }

    HashMap readFormat0() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n2 = 0;
        while (n2 < 256) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n2), nArray);
            ++n2;
        }
        return hashMap;
    }

    HashMap readFormat4() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n2 = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int n3 = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = this.rf.readUnsignedShort();
            ++n4;
        }
        this.rf.skipBytes(2);
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n5] = this.rf.readUnsignedShort();
            ++n5;
        }
        int[] nArray3 = new int[n3];
        int n6 = 0;
        while (n6 < n3) {
            nArray3[n6] = this.rf.readUnsignedShort();
            ++n6;
        }
        int[] nArray4 = new int[n3];
        int n7 = 0;
        while (n7 < n3) {
            nArray4[n7] = this.rf.readUnsignedShort();
            ++n7;
        }
        int[] nArray5 = new int[n2 / 2 - 8 - n3 * 4];
        int n8 = 0;
        while (n8 < nArray5.length) {
            nArray5[n8] = this.rf.readUnsignedShort();
            ++n8;
        }
        int n9 = 0;
        while (n9 < n3) {
            int n10 = nArray2[n9];
            while (n10 <= nArray[n9] && n10 != 65535) {
                int[] nArray6;
                int n11;
                if (nArray4[n9] == 0) {
                    n11 = n10 + nArray3[n9] & 0xFFFF;
                } else {
                    int n12 = n9 + nArray4[n9] / 2 - n3 + n10 - nArray2[n9];
                    n11 = nArray5[n12] + nArray3[n9] & 0xFFFF;
                }
                nArray6 = new int[]{n11, this.getGlyphWidth(nArray6[0])};
                hashMap.put(new Integer(n10), nArray6);
                ++n10;
            }
            ++n9;
        }
        return hashMap;
    }

    HashMap readFormat6() throws IOException {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int n2 = this.rf.readUnsignedShort();
        int n3 = this.rf.readUnsignedShort();
        int n4 = 0;
        while (n4 < n3) {
            int[] nArray;
            nArray = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(nArray[0])};
            hashMap.put(new Integer(n4 + n2), nArray);
            ++n4;
        }
        return hashMap;
    }

    void readKerning() throws IOException {
        int[] nArray = (int[])this.tables.get("kern");
        if (nArray == null) {
            return;
        }
        this.rf.seek(nArray[0] + 2);
        int n2 = this.rf.readUnsignedShort();
        this.kerning = new HashMap();
        int n3 = nArray[0] + 4;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            this.rf.seek(n3 += n4);
            this.rf.skipBytes(2);
            n4 = this.rf.readUnsignedShort();
            int n6 = this.rf.readUnsignedShort();
            if ((n6 & 0xFFF7) == 1) {
                int n7 = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int n8 = 0;
                while (n8 < n7) {
                    Integer n9 = new Integer(this.rf.readInt());
                    Integer n10 = new Integer(this.rf.readShort() * 1000 / this.head.unitsPerEm);
                    this.kerning.put(n9, n10);
                    ++n8;
                }
            }
            ++n5;
        }
    }

    public int getKerning(char c2, char c3) {
        int[] nArray = this.getMetricsTT(c2);
        if (nArray == null) {
            return 0;
        }
        int n2 = nArray[0];
        nArray = this.getMetricsTT(c3);
        if (nArray == null) {
            return 0;
        }
        int n3 = nArray[0];
        Integer n4 = (Integer)this.kerning.get(new Integer((n2 << 16) + n3));
        if (n4 == null) {
            return 0;
        }
        return n4;
    }

    protected int getRawWidth(int n2, String string) {
        HashMap hashMap = null;
        hashMap = string == null ? this.cmap10 : this.cmap31;
        if (hashMap == null) {
            return 0;
        }
        int[] nArray = (int[])hashMap.get(new Integer(n2));
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    protected PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference, String string) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfNumber(this.os_2.sTypoAscender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfNumber(this.os_2.sCapHeight * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("Descent"), new PdfNumber(this.os_2.sTypoDescender * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfRectangle(this.head.xMin * 1000 / this.head.unitsPerEm, this.head.yMin * 1000 / this.head.unitsPerEm, this.head.xMax * 1000 / this.head.unitsPerEm, this.head.yMax * 1000 / this.head.unitsPerEm));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(string + this.fontName + this.style));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfNumber(this.italicAngle));
        pdfDictionary.put(new PdfName("StemV"), new PdfNumber(80));
        if (pdfIndirectReference != null) {
            if (this.cff) {
                pdfDictionary.put(new PdfName("FontFile3"), pdfIndirectReference);
            } else {
                pdfDictionary.put(new PdfName("FontFile2"), pdfIndirectReference);
            }
        }
        int n2 = 0;
        if (this.isFixedPitch) {
            n2 |= 1;
        }
        n2 |= this.fontSpecific ? 4 : 32;
        if ((this.head.macStyle & 2) != 0) {
            n2 |= 0x40;
        }
        if ((this.head.macStyle & 1) != 0) {
            n2 |= 0x40000;
        }
        pdfDictionary.put(new PdfName("Flags"), new PdfNumber(n2));
        return pdfDictionary;
    }

    protected PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, String string, int n2, int n3, byte[] byArray) throws DocumentException {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            pdfDictionary.put(PdfName.SUBTYPE, new PdfName("Type1"));
        } else {
            pdfDictionary.put(PdfName.SUBTYPE, new PdfName("TrueType"));
        }
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(string + this.fontName + this.style));
        if (!this.fontSpecific) {
            int n4 = n2;
            while (n4 <= n3) {
                if (!this.differences[n4].equals(".notdef")) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(new PdfName("Encoding"));
                PdfArray pdfArray = new PdfArray();
                boolean bl = true;
                int n5 = n2;
                while (n5 <= n3) {
                    if (byArray[n5] != 0) {
                        if (bl) {
                            pdfArray.add(new PdfNumber(n5));
                            bl = false;
                        }
                        pdfArray.add(new PdfName(this.differences[n5]));
                    } else {
                        bl = true;
                    }
                    ++n5;
                }
                pdfDictionary2.put(new PdfName("Differences"), pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        pdfDictionary.put(new PdfName("FirstChar"), new PdfNumber(n2));
        pdfDictionary.put(new PdfName("LastChar"), new PdfNumber(n3));
        PdfArray pdfArray = new PdfArray();
        int n6 = n2;
        while (n6 <= n3) {
            if (byArray[n6] == 0) {
                pdfArray.add(new PdfNumber(0));
            } else {
                pdfArray.add(new PdfNumber(this.widths[n6]));
            }
            ++n6;
        }
        pdfDictionary.put(new PdfName("Widths"), pdfArray);
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        }
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        String string;
        PdfIndirectObject pdfIndirectObject;
        PdfDictionary pdfDictionary;
        PdfIndirectReference pdfIndirectReference2;
        byte[] byArray;
        int n2;
        int n3;
        block10: {
            Object object;
            block11: {
                n3 = (Integer)objectArray[0];
                n2 = (Integer)objectArray[1];
                byArray = (byte[])objectArray[2];
                if (!this.subset) {
                    n3 = 0;
                    n2 = byArray.length - 1;
                    int n4 = 0;
                    while (n4 < byArray.length) {
                        byArray[n4] = 1;
                        ++n4;
                    }
                }
                pdfIndirectReference2 = null;
                pdfDictionary = null;
                pdfIndirectObject = null;
                string = "";
                if (!this.embedded) break block10;
                if (!this.cff) break block11;
                byte[] byArray2 = new byte[this.cffLength];
                try {
                    this.rf.reOpen();
                    this.rf.seek(this.cffOffset);
                    this.rf.readFully(byArray2);
                    Object var13_14 = null;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    try {
                        this.rf.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.rf.close();
                }
                catch (Exception exception) {}
                pdfDictionary = (BaseFont)this.new BaseFont.StreamFont(byArray2, "Type1C");
                pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
                pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
                break block10;
            }
            string = this.createSubsetPrefix();
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            int n5 = n3;
            while (n5 <= n2) {
                if (byArray[n5] != 0 && (object = this.fontSpecific ? this.getMetricsTT(n5) : (Object)this.getMetricsTT(this.unicodeDifferences[n5])) != null) {
                    hashMap.put(new Integer(object[0]), null);
                }
                ++n5;
            }
            object = new TrueTypeFontSubSet(this.fileName, this.rf, hashMap, this.directoryOffset, true);
            byte[] byArray3 = object.process();
            int[] nArray = new int[]{byArray3.length};
            pdfDictionary = (BaseFont)this.new BaseFont.StreamFont(byArray3, nArray);
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfDictionary = this.getFontDescriptor(pdfIndirectReference2, string)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, string, n3, n2, byArray);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    public float getFontDescriptor(int n2, float f2) {
        switch (n2) {
            case 1: {
                return (float)this.os_2.sTypoAscender * f2 / (float)this.head.unitsPerEm;
            }
            case 2: {
                return (float)this.os_2.sCapHeight * f2 / (float)this.head.unitsPerEm;
            }
            case 3: {
                return (float)this.os_2.sTypoDescender * f2 / (float)this.head.unitsPerEm;
            }
            case 4: {
                return (float)this.italicAngle;
            }
            case 5: {
                return f2 * (float)this.head.xMin / (float)this.head.unitsPerEm;
            }
            case 6: {
                return f2 * (float)this.head.yMin / (float)this.head.unitsPerEm;
            }
            case 7: {
                return f2 * (float)this.head.xMax / (float)this.head.unitsPerEm;
            }
            case 8: {
                return f2 * (float)this.head.yMax / (float)this.head.unitsPerEm;
            }
            case 9: {
                return f2 * (float)this.hhea.Ascender / (float)this.head.unitsPerEm;
            }
            case 10: {
                return f2 * (float)this.hhea.Descender / (float)this.head.unitsPerEm;
            }
            case 11: {
                return f2 * (float)this.hhea.LineGap / (float)this.head.unitsPerEm;
            }
            case 12: {
                return f2 * (float)this.hhea.advanceWidthMax / (float)this.head.unitsPerEm;
            }
        }
        return 0.0f;
    }

    public int[] getMetricsTT(int n2) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return (int[])this.cmap31.get(new Integer(n2));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return (int[])this.cmap10.get(new Integer(n2));
        }
        return null;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[] getCodePagesSupported() {
        long l2 = ((long)this.os_2.ulCodePageRange2 << 32) + ((long)this.os_2.ulCodePageRange1 & 0xFFFFFFFFL);
        int n2 = 0;
        long l3 = 1L;
        int n3 = 0;
        while (n3 < 64) {
            if ((l2 & l3) != 0L && codePages[n3] != null) {
                ++n2;
            }
            l3 <<= 1;
            ++n3;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        l3 = 1L;
        int n4 = 0;
        while (n4 < 64) {
            if ((l2 & l3) != 0L && codePages[n4] != null) {
                stringArray[n2++] = codePages[n4];
            }
            l3 <<= 1;
            ++n4;
        }
        return stringArray;
    }

    public String[][] getFullFontName() {
        return this.fullName;
    }

    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    protected class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }

    protected class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    protected class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;

        protected FontHeader() {
        }
    }
}

