/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class PluginInfo {
    private String name;
    private String author;
    private String version;
    private String mainClass;
    private String title;
    private String description;
    private Map files;
    private Map properties;
    private boolean loadAtStart;

    public PluginInfo(Element node) {
        Element info = node.getChild("information");
        this.name = info.getChildTextNormalize("name");
        this.author = info.getChildTextNormalize("author");
        this.version = info.getChildTextNormalize("version");
        this.loadAtStart = info.getChild("load-at-start") != null;
        this.mainClass = node.getChild("plugin-desc").getAttributeValue("class");
        List desc = info.getChildren("description");
        Iterator i2 = desc.iterator();
        while (i2.hasNext()) {
            Element d2 = (Element)i2.next();
            String type = d2.getAttributeValue("type");
            String text = d2.getTextNormalize();
            if (type != null && type.equals("short")) {
                this.title = text;
                continue;
            }
            this.description = text;
        }
        Element resources = node.getChild("resources");
        if (resources != null) {
            List fileList = resources.getChildren("file");
            if (!fileList.isEmpty()) {
                this.files = new HashMap();
            }
            Iterator i3 = fileList.iterator();
            while (i3.hasNext()) {
                Element f2 = (Element)i3.next();
                String href = f2.getAttributeValue("href");
                String location = f2.getAttributeValue("location");
                this.files.put(location, href);
            }
            List propList = resources.getChildren("property");
            if (!propList.isEmpty()) {
                this.properties = new HashMap();
            }
            Iterator i4 = propList.iterator();
            while (i4.hasNext()) {
                Element f3 = (Element)i4.next();
                String name = f3.getAttributeValue("name");
                String value = f3.getAttributeValue("value");
                this.properties.put(name, value);
            }
        }
    }

    public boolean equals(Object o2) {
        if (o2 instanceof PluginInfo) {
            return this.name.equals(((PluginInfo)o2).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    String getMainClass() {
        return this.mainClass;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    boolean loadAtStart() {
        return this.loadAtStart;
    }

    public Map getFiles() {
        return this.files == null ? Collections.EMPTY_MAP : this.files;
    }

    public Map getProperties() {
        return this.properties == null ? Collections.EMPTY_MAP : this.properties;
    }
}

