/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.AbstractPathConstructor;

public abstract class CubicToQuadPathConstructor
extends AbstractPathConstructor {
    private double resolutionSq;

    protected CubicToQuadPathConstructor(double resolution) {
        this.resolutionSq = resolution * resolution;
    }

    public void move(double x2, double y2) throws IOException {
        this.currentX = x2;
        this.currentY = y2;
    }

    public void line(double x2, double y2) throws IOException {
        this.currentX = x2;
        this.currentY = y2;
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.quadratify(this.currentX, this.currentY, x1, y1, x2, y2, x3, y3);
        this.currentX = x3;
        this.currentY = y3;
    }

    public void closePath() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    private void split(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double splitPoint) throws IOException {
        double[][] x4 = new double[4][4];
        double[][] y4 = new double[4][4];
        x4[0][0] = x0;
        y4[0][0] = y0;
        x4[0][1] = x1;
        y4[0][1] = y1;
        x4[0][2] = x2;
        y4[0][2] = y2;
        x4[0][3] = x3;
        y4[0][3] = y3;
        int i2 = 1;
        while (i2 <= 3) {
            int j2 = 0;
            while (j2 <= 3 - i2) {
                x4[i2][j2] = (1.0 - splitPoint) * x4[i2 - 1][j2] + splitPoint * x4[i2 - 1][j2 + 1];
                y4[i2][j2] = (1.0 - splitPoint) * y4[i2 - 1][j2] + splitPoint * y4[i2 - 1][j2 + 1];
                ++j2;
            }
            ++i2;
        }
        this.quadratify(x4[0][0], y4[0][0], x4[1][0], y4[1][0], x4[2][0], y4[2][0], x4[3][0], y4[3][0]);
        this.quadratify(x4[3][0], y4[3][0], x4[2][1], y4[2][1], x4[1][2], y4[1][2], x4[0][3], y4[0][3]);
    }

    private static Point2D evaluateBezier(Point2D[] c2, double t2) {
        double[] x2 = new double[c2.length];
        double[] y2 = new double[c2.length];
        int i2 = 0;
        while (i2 < c2.length) {
            x2[i2] = c2[i2].getX();
            y2[i2] = c2[i2].getY();
            ++i2;
        }
        int i3 = 1;
        while (i3 < c2.length) {
            int j2 = 0;
            while (j2 < c2.length - i3) {
                x2[j2] = (1.0 - t2) * x2[j2] + t2 * x2[j2 + 1];
                y2[j2] = (1.0 - t2) * y2[j2] + t2 * y2[j2 + 1];
                ++j2;
            }
            ++i3;
        }
        return new Point2D.Double(x2[0], y2[0]);
    }

    private void quadratify(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        Point2D.Double a2 = new Point2D.Double(x0, y0);
        Point2D.Double b2 = new Point2D.Double(x1, y1);
        Point2D.Double c2 = new Point2D.Double(x2, y2);
        Point2D.Double d2 = new Point2D.Double(x3, y3);
        Point2D e2 = null;
        double splitPoint = 0.5;
        boolean forceSplit = false;
        if (a2.equals(b2) && b2.equals(c2) && c2.equals(d2)) {
            return;
        }
        if (a2.equals(b2) && c2.equals(d2)) {
            this.line(x3, y3);
            return;
        }
        if (!b2.equals(c2)) {
            double sideD;
            Line2D.Double bc = new Line2D.Double(b2, c2);
            double sideA = bc.relativeCCW(x0, y0);
            if (sideA != (sideD = (double)bc.relativeCCW(x3, y3)) && sideA != 0.0 && sideD != 0.0) {
                forceSplit = true;
            } else {
                if (sideA == 0.0 && sideD == 0.0) {
                    this.line(x3, y3);
                    return;
                }
                if (sideA == sideD || sideA == 0.0 && sideD != 0.0 || sideA != 0.0 && sideD == 0.0) {
                    if (!a2.equals(d2) && b2.equals(c2)) {
                        e2 = b2;
                    } else if (a2.equals(b2) && !b2.equals(c2) && !c2.equals(d2)) {
                        e2 = c2;
                    } else if (c2.equals(d2) && !c2.equals(b2) && !b2.equals(a2)) {
                        e2 = b2;
                    } else {
                        e2 = CubicToQuadPathConstructor.intersect(a2, b2, c2, d2, false);
                        if (e2 == null) {
                            System.out.println("CubicToQuadPathConstructor: internal error, control point approximated.");
                            e2 = new Point2D.Double((((Point2D)b2).getX() + ((Point2D)c2).getX()) / 2.0, (((Point2D)b2).getY() + ((Point2D)c2).getY()) / 2.0);
                            this.quad(e2.getX(), e2.getY(), ((Point2D)d2).getX(), ((Point2D)d2).getY());
                            return;
                        }
                    }
                }
            }
        } else {
            System.out.println("CubicToQuadPathConstructor: internal error, control point fixed.");
            e2 = b2;
        }
        if (!forceSplit) {
            Point2D[] cubic = new Point2D[]{a2, b2, c2, d2};
            Point2D[] quadratic = new Point2D[]{a2, e2, d2};
            double maxDistance = 0.0;
            int testPoints = 32;
            int i2 = 1;
            while (i2 < testPoints) {
                Point2D quadraticPoint;
                double t2 = (double)i2 / (double)testPoints;
                Point2D cubicPoint = CubicToQuadPathConstructor.evaluateBezier(cubic, t2);
                double distance = cubicPoint.distanceSq(quadraticPoint = CubicToQuadPathConstructor.evaluateBezier(quadratic, t2));
                if (distance > maxDistance) {
                    splitPoint = t2;
                    maxDistance = distance;
                }
                ++i2;
            }
            if (maxDistance < this.resolutionSq) {
                this.quad(e2.getX(), e2.getY(), ((Point2D)d2).getX(), ((Point2D)d2).getY());
                return;
            }
        }
        this.split(x0, y0, x1, y1, x2, y2, x3, y3, splitPoint);
    }

    private static Point2D intersect(Point2D p1, Point2D p2, Point2D p3, Point2D p4, boolean segments) {
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double c1 = p2.getX() * p1.getY() - p1.getX() * p2.getY();
        double r3 = a1 * p3.getX() + b1 * p3.getY() + c1;
        double r4 = a1 * p4.getX() + b1 * p4.getY() + c1;
        if (segments && r3 != 0.0 && r4 != 0.0 && r3 * r4 > 0.0) {
            return null;
        }
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double c2 = p4.getX() * p3.getY() - p3.getX() * p4.getY();
        double r1 = a2 * p1.getX() + b2 * p1.getY() + c2;
        double r2 = a2 * p2.getX() + b2 * p2.getY() + c2;
        if (segments && r1 != 0.0 && r2 != 0.0 && r1 * r2 > 0.0) {
            return null;
        }
        double denom = a1 * b2 - a2 * b1;
        if (denom == 0.0) {
            return null;
        }
        double numX = b1 * c2 - b2 * c1;
        double numY = a2 * c1 - a1 * c2;
        double x2 = numX / denom;
        double y2 = numY / denom;
        return new Point2D.Double(x2, y2);
    }

    public static void main(String[] args) throws Exception {
        Test pc = new Test(0.5);
        pc.move(20.0, 20.0);
        pc.cubic(20.0, 40.0, 40.0, 60.0, 60.0, 60.0);
        pc.move(20.0, 20.0);
        pc.cubic(20.0, 40.0, 60.0, 60.0, 40.0, 60.0);
        pc.move(183.0, 149.0);
        pc.cubic(189.0, 291.0, 256.0, 347.0, 295.0, 244.0);
        pc.cubic(334.0, 141.0, 286.0, 216.0, 214.0, 228.0);
        pc.cubic(142.0, 240.0, 142.0, 256.0, 176.0, 284.0);
    }

    static class Test
    extends CubicToQuadPathConstructor {
        public Test(double resolution) {
            super(resolution);
        }

        public void quad(double x1, double y1, double x2, double y2) {
            System.out.println("Quad: (" + this.currentX + ", " + this.currentY + ") (" + x1 + ", " + y1 + ") (" + x2 + ", " + y2 + ")");
            this.currentX = x2;
            this.currentY = y2;
        }
    }
}

