/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.encoding;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class CharTableConverter {
    private BufferedReader textFile = null;
    private PrintWriter javaOut = null;
    private String outName = null;
    private int encType = 1;
    private String ENC = "";

    public void putHeaders() throws Exception {
        this.javaOut.println("//Generated by CharTableConverter");
        this.javaOut.println("//!!DO NOT EDIT");
        this.javaOut.println("package org.freehep.graphicsio.font.encoding;");
        this.javaOut.println();
        this.javaOut.println("import java.util.*;");
        this.javaOut.println();
        this.javaOut.println("/**");
        this.javaOut.println(" * Generated " + this.ENC + " " + this.outName + " Encoding Table.");
        this.javaOut.println(" *");
        this.javaOut.println(" * @author org.freehep.graphicsio.font.encoding.CharTableConverter");
        this.javaOut.println(" * @version $Id: CharTableConverter.java,v 1.1 2001/11/29 01:45:27 duns Exp $");
        this.javaOut.println(" */");
        this.javaOut.println("public class " + this.ENC + this.outName + " extends AbstractCharTable {");
        this.javaOut.println("\tprivate Hashtable unicodeToName = new Hashtable();");
        this.javaOut.println("\tprivate Hashtable nameToUnicode = new Hashtable();");
        this.javaOut.println("\tprivate Hashtable nameToEnc = new Hashtable();");
        this.javaOut.println("\tprivate String[] encToName = new String[256];");
        this.javaOut.println("\tpublic " + this.ENC + this.outName + "(){");
    }

    public void putMethods() throws Exception {
        this.javaOut.println("\tpublic String toName(Character c){");
        this.javaOut.println("\t\treturn((String)unicodeToName.get(c));");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String toName(int enc){");
        this.javaOut.println("\t\tif(enc!=0)");
        this.javaOut.println("\t\treturn(encToName[enc]);");
        this.javaOut.println("\t\treturn(null);");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic int toEncoding(String name){");
        this.javaOut.println("\t\treturn(((Integer)(nameToEnc.get(name))).intValue());");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic char toUnicode(String name){");
        this.javaOut.println("\t\treturn(((Character)(nameToUnicode.get(name))).charValue());");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String getName(){");
        this.javaOut.println("\treturn(\"" + this.outName + "\");");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String getEncoding(){");
        this.javaOut.println("\t\treturn(\"" + this.ENC + "\");");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("}");
        this.javaOut.flush();
        this.javaOut.close();
    }

    public void openFiles(String txtName, String enc) throws Exception {
        FileInputStream textIn = new FileInputStream(txtName);
        InputStreamReader textFileReader = new InputStreamReader((InputStream)textIn, "UTF-16");
        this.ENC = enc;
        this.outName = txtName.substring(0, txtName.indexOf("."));
        this.outName = this.outName.substring(0, 1).toUpperCase() + this.outName.substring(1);
        FileWriter javaFileWriter = new FileWriter(this.ENC + this.outName + ".java");
        this.textFile = new BufferedReader(textFileReader);
        this.javaOut = new PrintWriter(javaFileWriter);
    }

    public void convertTxtToHash() throws Exception {
        String buff = new String();
        String charCode = new String();
        String charName = new String();
        String encoding = new String();
        String hexformat = new String();
        if (this.ENC.equals("ISO")) {
            this.encType = 5;
        }
        if (this.ENC.equals("PDF")) {
            this.encType = 4;
        }
        if (this.ENC.equals("WIN")) {
            this.encType = 3;
        }
        if (this.ENC.equals("MAC")) {
            this.encType = 2;
        }
        if (this.ENC.equals("STD")) {
            this.encType = 1;
        }
        while ((buff = this.textFile.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(buff, "\t ");
            if (!st.hasMoreTokens() || (charCode = st.nextToken()).equals("##") || !st.hasMoreTokens()) continue;
            charName = st.nextToken();
            int i2 = 0;
            while (i2 < this.encType) {
                if (st.hasMoreTokens()) {
                    encoding = st.nextToken();
                }
                ++i2;
            }
            if (charCode.startsWith("\\u")) {
                int cCL = charCode.length();
                this.javaOut.println();
                hexformat = charCode.substring(cCL - 4, cCL);
                this.javaOut.print("\t\t\t");
                this.javaOut.println("unicodeToName.put(new Character((char)0x" + hexformat + "),\"" + charName + "\");");
                this.javaOut.print("\t\t\t");
                this.javaOut.println("nameToUnicode.put(\"" + charName + "\"" + ", new Character((char)0x" + hexformat + "));");
            } else {
                hexformat = "00" + Integer.toHexString(charCode.charAt(0));
                this.javaOut.println();
                this.javaOut.print("\t\t\t");
                this.javaOut.println("unicodeToName.put(new Character((char)0x" + hexformat.substring(hexformat.length() - 4, hexformat.length()) + "),\"" + charName + "\");");
                this.javaOut.print("\t\t\t");
                this.javaOut.println("nameToUnicode.put(\"" + charName + "\"" + ",new Character((char)0x" + hexformat.substring(hexformat.length() - 4, hexformat.length()) + "));");
            }
            Integer encodingInt = Integer.decode(encoding);
            if (encodingInt < 0) continue;
            this.javaOut.print("\t\t\t");
            this.javaOut.println("nameToEnc.put(\"" + charName + "\", new Integer(" + encodingInt + "));");
            this.javaOut.print("\t\t\t");
            this.javaOut.println("encToName[" + encodingInt + "]=\"" + charName + "\";");
        }
        this.javaOut.println();
        this.javaOut.println("\t\t}");
        this.javaOut.println();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: CharTableConverter txtfile [Encoding type]");
            System.exit(0);
        }
        CharTableConverter ht = new CharTableConverter();
        if (args.length == 2) {
            try {
                ht.openFiles(args[0], args[1]);
            }
            catch (IOException e2) {
                System.err.println(e2.getMessage());
            }
        }
        if (args.length == 1) {
            try {
                ht.openFiles(args[0], "");
            }
            catch (IOException e3) {
                System.err.println(e3.getMessage());
            }
        }
        try {
            ht.putHeaders();
        }
        catch (IOException e4) {
            System.err.println(e4.getMessage());
        }
        try {
            ht.convertTxtToHash();
        }
        catch (IOException e5) {
            System.err.println(e5.getMessage());
        }
        try {
            ht.putMethods();
        }
        catch (IOException e6) {
            System.err.println(e6.getMessage());
        }
    }
}

