/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class ParallelogramSelectionPanel
extends AbstractRegionSelectionPanel {
    private static final int STARTING_WIDTH = 25;

    public int getNumberOfControlPoints() {
        return 6;
    }

    public Cursor getControlPointCursor(int index) {
        int k2;
        switch (index) {
            case 0: 
            case 3: 
            case 5: {
                k2 = 4;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                k2 = 5;
                break;
            }
            default: {
                return FreeHepImage.getCursor("ParallelogramCursor");
            }
        }
        return AbstractRegionSelectionPanel.compassCursor("Rotation", this.xCtrlPts[index] - this.xCtrlPts[k2], this.yCtrlPts[index] - this.yCtrlPts[k2], 8, true);
    }

    public void initializeControlPoints(int x2, int y2) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.yCtrlPts, y2);
        this.xCtrlPts[0] = x2 - 25;
        this.xCtrlPts[1] = x2 - 25;
        this.xCtrlPts[2] = x2 + 25;
        this.xCtrlPts[3] = x2 + 25;
        this.xCtrlPts[4] = x2;
        this.xCtrlPts[5] = x2;
    }

    public void updateActiveControlPoint(int x2, int y2) {
        x2 = this.forceXCoordinateWithinBounds(x2);
        y2 = this.forceYCoordinateWithinBounds(y2);
        switch (this.activeCtrlPt) {
            case 4: {
                int dx = this.xCtrlPts[0] - this.xCtrlPts[4];
                int dy = this.yCtrlPts[0] - this.yCtrlPts[4];
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                this.xCtrlPts[0] = x2 + dx;
                this.yCtrlPts[0] = y2 + dy;
                this.xCtrlPts[3] = x2 - dx;
                this.yCtrlPts[3] = y2 - dy;
                break;
            }
            case 5: {
                int dx = this.xCtrlPts[1] - this.xCtrlPts[5];
                int dy = this.yCtrlPts[1] - this.yCtrlPts[5];
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                this.xCtrlPts[1] = x2 + dx;
                this.yCtrlPts[1] = y2 + dy;
                this.xCtrlPts[2] = x2 - dx;
                this.yCtrlPts[2] = y2 - dy;
                break;
            }
            case 0: 
            case 3: {
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                int dx = this.xCtrlPts[this.activeCtrlPt] - this.xCtrlPts[4];
                int dy = this.yCtrlPts[this.activeCtrlPt] - this.yCtrlPts[4];
                if (this.activeCtrlPt == 3) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[1] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] + dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] - dy;
                this.xCtrlPts[0] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] - dy;
                break;
            }
            case 1: 
            case 2: {
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                int dx = this.xCtrlPts[this.activeCtrlPt] - this.xCtrlPts[5];
                int dy = this.yCtrlPts[this.activeCtrlPt] - this.yCtrlPts[5];
                if (this.activeCtrlPt == 2) {
                    dx = -dx;
                    dy = -dy;
                }
                this.xCtrlPts[1] = this.xCtrlPts[5] + dx;
                this.yCtrlPts[1] = this.yCtrlPts[5] + dy;
                this.xCtrlPts[2] = this.xCtrlPts[5] - dx;
                this.yCtrlPts[2] = this.yCtrlPts[5] - dy;
                this.xCtrlPts[0] = this.xCtrlPts[4] + dx;
                this.yCtrlPts[0] = this.yCtrlPts[4] + dy;
                this.xCtrlPts[3] = this.xCtrlPts[4] - dx;
                this.yCtrlPts[3] = this.yCtrlPts[4] - dy;
                break;
            }
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g2.setColor(Color.black);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g2.setColor(Color.white);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g2.setColor(Color.black);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3);
                g2.setColor(Color.white);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 0;
        int savedValue = this.xCtrlPts[0] * this.xCtrlPts[0] + this.yCtrlPts[0] * this.yCtrlPts[0];
        int i2 = 1;
        while (i2 < 4) {
            int value = this.xCtrlPts[i2] * this.xCtrlPts[i2] + this.yCtrlPts[i2] * this.yCtrlPts[i2];
            if (value < savedValue) {
                savedValue = value;
                first = i2;
            }
            ++i2;
        }
        int third = (first + 2) % 4;
        int dx0 = this.xCtrlPts[third] - this.xCtrlPts[first];
        int second = (first + 1) % 4;
        int dy1 = this.yCtrlPts[second] - this.yCtrlPts[first];
        int dy0 = this.yCtrlPts[third] - this.yCtrlPts[first];
        int dx1 = this.xCtrlPts[second] - this.xCtrlPts[first];
        if (dx0 * dy1 - dy0 * dx1 > 0) {
            second = (first + 3) % 4;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.makeAffineTransform() != null;
    }
}

