//
//                                   ____
//                                  / __ \
//                                 ( (__) )
//                                 _\____/___
//                                /  |  |   /\
//                               /_________/  \_
//                              /          \    \
//                             /            \    \_
//                            /              \     \
//                           /                \     \_
//                          /                  \      \
//                         /                    \      \_
//                        /                      \       \
//                       /                        \       \_
//                      /                          \        \
//                     /                            \        \_
//                    /                              \         \
//                   / N  N EEE W   W TTTTT  OO  N  N \        /
//                  /  NN N E_  W   W   T   O  O NN N  \      /
//                 /   N NN E   W W W   T   O  O N NN   \    /
//                /    N  N EEE  W W    T    OO  N  N    \  /
//               /________________________________________\/
//
//                     Newtonian Physics Simulation Library
//
//                      Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// newtmath.cpp
//
// Contains the math helper routines.
//
//

//
//
//                                Includes
//
//

#include <newton.hpp>
#include <math.h>

//
//
//                                 Code
//
//

//
// newt_cross
//
extern "C" NewtVector *newt_cross(const NewtVector *v1, const NewtVector *v2,
                                  NewtVector *dest)
{
//
// (i', j', k') = v1 CROSS v2
//
//       i' = (v1.j * v2.k) - (v1.k * v2.j)
//       j' = (v1.k * v2.i) - (v1.i * v2.k)
//       k' = (v1.i * v2.j) - (v1.j * v2.i)
//

    float newi = (v1->j*v2->k) - (v1->k*v2->j);
    float newj = (v1->k*v2->i) - (v1->i*v2->k);
    float newk = (v1->i*v2->j) - (v1->j*v2->i);

    dest->i = newi;
    dest->j = newj;
    dest->k = newk;

    return dest;
}


//
// newt_dot
//
extern "C" float newt_dot(const NewtVector *v1, const NewtVector *v2)
{
//
// x = v1 DOT v2 =  (v1.i*v2.i) + (v1.j*v2.j) + (v1.k*v2.k)
//

    return ((v1->i*v2->i)
            + (v1->j*v2->j)
            + (v1->k*v2->k));
}


//
// newt_magnitude
//
extern "C" float newt_magnitude(const NewtVector *vect)
{
// magnitude = sqrt(i^2 + j^2 + k^3)

    return float(sqrt(vect->i*vect->i
                      + vect->j*vect->j
                      + vect->k*vect->k));
}

// End of module - newtmath.cpp 

