//
//
//                                /\    /\
//                               /  \  /  \
//                              /    \/    \
//                             /  /\    /\  \
//                            /  /  \  /  Y T H O S
//                           /  /    \/    \  \
//                          /  /            \  \
//                         /__/              \__\
//
//                  Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// mythos.cpp
//
// The Mythos Collection provides many diverse tools for development of
// entertainment software.  This module contains the MythosSystem class for
// coordinated use of the various Mythos components.
//
//

//
//
//                                Includes
//
//

#include <ivory.h>
#include <bozo.h>

#include "mythos.hpp"

//
//
//                                 Code
//
//

//Ŀ
// MythosSystem - constructor                                               
//                                                                          
// Initializes the various Mythos components in the proper sequence.        
//
MythosSystem::MythosSystem(ulong ivory_size,
                           ivory_init_codes ivory_opt) :
    Ivory(ivory_size,ivory_opt),
    Bozo(),
    Max(),
    Chronos(),
    Gutenberg(),
    Vangogh(),
    Escher()
{
};


//Ŀ
// MythosSystem - destructor                                                
//                                                                          
// Shuts down the various Mythos components in the proper sequence.         
//
MythosSystem::~MythosSystem()
{
// Uninit Chronos
    Chronos.term();
};


//Ŀ
// MythosSystem - init                                                      
//                                                                          
// Initializes the libraries with explicit initialization.                  
//
int MythosSystem::init(ulong esch_arena_size, ulong esch_sort_size,
                       IvorySubAlloc *bozo_alloc)
{
    int err;

// Init Chronos
    Chronos.init();

// Init Bozo
    if (bozo_alloc)
        Bozo.set_allocator(bozo_alloc);

// Init Escher
    err=Escher.init(esch_arena_size,esch_sort_size);

    return err;
}

// End of module - mythos.cpp 

