//	units.h
// Initialization file for Units.
// Also, controls all major movement for Bullets and Explosion.

#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

  	bool 			ShowSmoke = true;      	// Show smoke?
  	bool 			ShowDebris = true;	  	// Show Debris?

   const int 	EnTotal = 20;           // Total Enemys
   const int	BulTotal = 200;         // Total Bullets
   const int	ExTotal = 80;				// Total Explosions
   int 			curex = 0;               // Current Explosions
   int 			curEn = 0;               // Current Enemy
	int 			curbul = 1;              // Current Bullet

	int 			NukeLeft =0;			// Current Nuke Effect Remaining.

// Units
	strObj User;                     // User Object
   strObj En[EnTotal];              // Enemy Objects

// Bullets
	strBul Bul[BulTotal];            // Bullet Objects

// Explosions
	strEx Ex[ExTotal];               // Explosion Objects


void DropGround(int x,int num)
// This Function Modifies the ground and lowers the terrain.
{
   for(int i=1;i<=num;i++)									// # of times to be lowered.
   {
		if ((x >= 0)&&(x <= 65)) {         				// Error checking
			CurLvl.lhgt[x]=CurLvl.hgt[x];             // last height.
			CurLvl.hgt[x]-=1;                         // Height decreases.
         if (CurLvl.hgt[x]<=120) CurLvl.hgt[x]=120;// Make sure !< 120
			DrawLevel(false,false,x-1,x+1);           // Redraw Terrain.
   	}
   }
}


void InitializeUnits ()
// This Function initializes the Units.
{
   for(int i=1;i<EnTotal;i++) En[i].objTyp =0;     // Init the Enemies
   for(int i=1;i<BulTotal;i++) Bul[i].bulTyp =0;   // Init the Bullets
   for(int i=1;i<ExTotal;i++) Ex[i].exTyp =0;      // Init the Explosions
 	User.dead=false;                                // User is active
 	User.Gfx=1;
 	User.hp=50;
 	User.lhp=1;                                     // These are the starting
 	User.sp=25;                                     // settings for the User tank
 	User.lsp=1;
   User.x=200;
   User.y=200;
   User.objTyp=1;
   User.angle=0;
   User.vx=0;
   User.vy=0;
   User.scale=1;
   User.Gangle=245;
   User.lGangle=245;
   User.Gwait=1;
}
void Debris(int x,int y,double vx,double vy,double grow)
// This function fires off some debris.
{
	if (ShowDebris == true){    			// If debris is to be shown.
 		curbul++;                        	// Increment curent bullet
   	if (curbul>=BulTotal) curbul=1;     // Not to go over BulTotal.
		Bul[curbul].x=x;
   	Bul[curbul].y=y;                    // Init settings for debree.
		Bul[curbul].bulTyp=1;
   	Bul[curbul].vx = vx;
   	Bul[curbul].vy = vy;
   	Bul[curbul].angle=random(360);
   	Bul[curbul].scale=random(30)/10.+1;
   	Bul[curbul].grav=.3;                // Gravity is .3
   	Bul[curbul].dmg=1;
		Bul[curbul].grow=grow;
   }
}
void CreateUnit (int Type)
// This Function initializes the Units.
{
   curEn++;                               // Increment Current Enemy
   if (curEn >= EnTotal) curEn=1;         // Not to go over EnTotal
 	En[curEn].lGfx=1;
 	En[curEn].Gfx=1;
 	En[curEn].hp=10;
 	En[curEn].dead=false;                  // Standard Inits for Enemy
   En[curEn].objTyp=Type;
   En[curEn].angle=0;
   En[curEn].vx=0;
   En[curEn].vy=0;
   En[curEn].scale=2;
   En[curEn].Gwait=1;
   En[curEn].PlaneSpin = (random(3) == 1);
   int dir;
	switch(Type)                       	// switch decides further initialization.
   {
   	// These cases modify the standard initialization depending on typ of obj.
   	case 2:                          // Plane
      	dir = (random(2)*2)-1;        // Direction
      	En[curEn].x=dir*360+320;      // Starting Position
      	En[curEn].y=300+random(180);  // Starting Height.
         En[curEn].vx=-dir*8;          // Starting X Velocity
         En[curEn].vy=-3;              // Starting Y Velocity
 			En[curEn].hp=6;               // Starting HP
      	break;
   	case 3:                          // Helicopter
      	dir = (random(2)*2)-1;
      	En[curEn].x=dir*360+320;
      	En[curEn].y=300+random(180);
         En[curEn].vx=-dir*(random(4)+6);
   	break;
		case 4:                          // Interceptor
      	En[curEn].x=random(40)+300;
      	En[curEn].y=400+random(80);
         En[curEn].vx=random(5)-2;
         if (En[curEn].vx == 0) En[curEn].vx=-1; 	// Error checking (divide by
         En[curEn].vy=-2;                          // zero).
         En[curEn].scale = .01;                    // Start small.
 			En[curEn].hp=8;
      break;
   	default:
   	break;
   }

}

void Explode(int x,int y,int vx,int vy,int xsize,int ysize,int Type)
// This function creates an Explosion.
{
   if (!(ShowSmoke == false && Type == 2)){	// if Smoke is to be shown
		for(int i = 1;i < ExTotal;i++){        // This loop finds an inactive Ex.
			curex++;                            	// increment current Ex
   		if (curex>=ExTotal) curex=1;           // Not to go too high
      	if (Ex[curex].exTyp == 0) i = ExTotal+1;	// if inactive, end loop.
   	}
		Ex[curex].x = x;
   	Ex[curex].y = y;
   	Ex[curex].xsize = xsize;
   	Ex[curex].ysize = ysize;               // Initialization settings for an
   	Ex[curex].vx=vx;                       // Explosion
		Ex[curex].vy=vy;
   	Ex[curex].lx = x;
   	Ex[curex].ly = y;
   	Ex[curex].lxsize = xsize;
   	Ex[curex].lysize = ysize;
   	Ex[curex].exTyp = Type;
   }
}

void DrawAllGFXObjs()
// This function Draws all Graphical Objects in there locations
// and calculates positions of bullets and explosions.
{
   if (User.objTyp == 1){    	// If User tank is active.
   	// Draw the User Tank
   	ClrObj(Gobj[1][1],User.lx,User.ly,User.langle,User.lscale,1);
   	DrawObj(Gobj[1][1],User.x,User.y,User.angle,User.scale,1);
   }
   if (User.dead == false){   // If User tank is not dead
   	// Draw the Tank's Gun
   	int x1=0,y1=11;         			// temp variables
   	int x2=0,y2=11;
   	Rotate(x1,y1,User.angle);        // rotate the gun
   	Rotate(x2,y2,User.langle);

   	ClrObj(Gun,User.lx+x2,User.ly+y2,User.lGangle+User.langle,User.lscale,1);
   	DrawObj(Gun,User.x+x1,User.y+y1,User.Gangle+User.angle,User.scale,1);
      // clear the last Obj and draw the new one.
   }
   // Draw the Enemies.
   for(int i=1;i<EnTotal;i++)         	// Loop covers all enemies.
   {
      if (En[i].objTyp>0){
   	ClrObj(Gobj[En[i].objTyp][En[i].lGfx],En[i].lx,En[i].ly,En[i].langle,En[i].lscale,En[i].vx);
   	DrawObj(Gobj[En[i].objTyp][En[i].Gfx],En[i].x,En[i].y,En[i].angle,En[i].scale,En[i].vx);
      // clear the last Obj and draw the new one.
      }
   }


   // Draw all Bullets
   for(int i=1;i<BulTotal;i++)         // Loop covers all bullets.
   {
      if((Bul[i].bulTyp>0)&&(Bul[i].bulTyp<11))		// if bullet is active.
      {

      	if (Bul[i].x>745) Bul[i].bulTyp=0;
      	if (Bul[i].x<-105) Bul[i].bulTyp=0;          // If bullet is offscreen
      	if (Bul[i].y>560) Bul[i].bulTyp=11;          // get rid of bullet.
      	if (Bul[i].y<-35) Bul[i].bulTyp=0; 				// Error Checking.

         if (Bul[i].y<=LvlHgt(Bul[i].x)) Bul[i].bulTyp=0;	// If bul hit ground
      	Bul[i].lx=Bul[i].x;
      	Bul[i].ly=Bul[i].y;                    // Remember last positions
      	Bul[i].langle=Bul[i].angle;
      	Bul[i].lscale=Bul[i].scale;            // and last angles.
      	Bul[i].x+=Bul[i].vx;                 	// position increases with
      	Bul[i].y+=Bul[i].vy;                   // velocity to create movement.
         Bul[i].vy-=Bul[i].grav;                // gravity decellerates.
         Bul[i].scale+=Bul[i].grow;             // grows or shrinks.
         if (Bul[i].grow != 0){                 // if bullet is growing,
	         Bul[i].vx*=Bul[i].grow*1.3;         	// velocity increases with
   	      Bul[i].vy*=Bul[i].grow*1.3;            // size.
      	}
         if (Bul[i].scale>30) Bul[i].y = -2000; // If bullet is too big, die!
        	int dmg=Bul[i].dmg;
         int dir = Bul[i].vx;
         int tar;                               // Temp variables to simplify
         int EX;                                // things within the cases
         int EY;
         int siz;
         double ED;
         switch(Bul[i].bulTyp)
      		{
            	// if case is empty then all calculations have already been made.
            	case 0:	// dead bullet
               	if (dmg>=5){	// if dammage is greater than 5,
               		Explode(Bul[i].x,LvlHgt(Bul[i].x),0,0,dmg*4+random(dmg),dmg*3+random(dmg),1);
               		Explode(Bul[i].x,LvlHgt(Bul[i].x),0,3,1,1,2);
                     	// make some explosions relative to size.
               		DropGround(Bul[i].x/10+random(4)-2,1);
                     	// Modify the terrain.
               		for(int iii =1;iii<5;iii++)
               			Debris(Bul[i].x-4+random(9),Bul[i].y+random(19)-Bul[i].vy*2,Bul[i].vx*((random(10))/20.)+((random(20)-10)/20.),(random(100)/20.),0);
                     		// create some debris.
               		}
                  else
                    	DrawLevel(true,false,(Bul[i].x)/10-1,(Bul[i].x)/10+2);
                     	// if dammage <5, just redraw level.
      	      	break;
            	case 1:  // debree
                  Bul[i].angle+=Bul[i].vx*3*Bul[i].scale;
                  	// rotate relative to velocity.
                  if (Bul[i].scale<1.3) Bul[i].angle=0;
                  	// if bullet is too small, do not rotate.
       	      	break;
            	case 2:	// User bullet
       	      	break;
            	case 3:  // Bomber's bomb
       	      	break;
               case 4:  // The Helicopter's Back Propellor
                  Bul[i].angle+=Bul[i].vx*5;
                  break;
           		case 5:  // The Helicopter's Bullet
       	      	break;
           		case 6:  // The Helicopter's Main Propellor
                  Bul[i].angle+=Bul[i].vx*5;
                   	// rotate relative to velocity.
                  if (Bul[i].angle>=180) Bul[i].angle = 0;	// when not to
                  if (Bul[i].angle<=-180) Bul[i].angle = 0; // rotate.
                  Bul[i].scale = (abs(Bul[i].angle)-90)/60.+.2;
                  	// resize relative to rotation.
       	      	break;
               case 7:	// Interceptor's Incomming missile
               	if (random(8)>6)
                  	Explode(Bul[i].x,Bul[i].y,0,-Bul[i].vy,Bul[i].scale*10,Bul[i].scale*10,1);
                  	// Make random trailing explosions.
               	Bul[i].vy = -(Bul[i].y - LvlHgt(Bul[i].x))/15;
                  	// velocity is relative to ground level.
                  Bul[i].scale*=1.06;
                  	// scale increases.
                  Bul[i].angle+=Bul[i].vy*5;
                  	// rotate relative to velocity.
                  if (Bul[i].scale>4) {	// if missile to big (close), die!
                  	Bul[i].bulTyp = 0;   // make inactive.
                  	Explode(Bul[i].x,Bul[i].y,0,0,70,40,1);
                     	// Make an explosion.
                     for(int ii = 0; ii < 7;ii++){
                     		//Make random explosions and debris.
 	                 		if (random(9)>5) Explode(Bul[i].x+random(140)-70,Bul[i].y+random(80)-40,0,0,18,18,1);
               			Debris(Bul[i].x,Bul[i].y,(random(100)-50)/6.,random(100)/10.,.8);
              				Debris(Bul[i].x,Bul[i].y,(random(100)-50)/6.,random(100)/10.,0);
                        	// regular debris and growing debris.
                        }
                     int x = Bul[i].x-User.x;	// X difference
                     int y = Bul[i].y-User.y;	// Y difference
                     int d = sqrt(x*x+y*y/3);   // Distance apart from User
                     if (d<70) {                // if distance is <70 pixels
                        int dmg = Bul[i].dmg;      // To simplify things...
           					if (User.sp>0){            // If User Shields are still working,
         						User.sp -= dmg; 			// User SP is dropped by the Bullets' dmg.
         						Explode(User.x,User.y,0,0,15+dmg*5,10+dmg*3,4);
         						if (User.sp < 0) {      // If Shields dropped,
               					User.hp += User.sp;  	// User HP takes the damage
                  				User.sp = 0;            // Make Sure Shields are gone.
               				}
           				 	}
            				else                       // If Shields are down,
            				{
         						User.hp -= dmg; 			// User HP is dropped by the Bullets' dmg.
				            }


         					if ((User.hp <= 0) && (User.dead == false)) {	
                        		// If user is dead,
            					User.dead = true; 	// Set User to dead.
               				User.vx=0;           // Stop User
   								User.smoke = 100;    // Start the smoking death.
             				}
                  	}	// End if Hit
                  }  // End if Missile died.
               break;
            	case 8:	// User's Gun when it flyes off at death,
               	Bul[i].angle+=Bul[i].vx*4;
                  	// rotate with velocitiy
                  if (random(30)>28) Explode(Bul[i].x,Bul[i].y,0,0,15,15,1);
                   	// randomly explode
               	break;
            	case 9:	// User's homing missile.
               	Bul[i].angle = atan(-(Bul[i].vy)/(Bul[i].vx))/DEG;
                  // angle is relative to velocity.
                  tar = Bul[i].EnTarget; // simplified variable
                  if ((En[tar].objTyp == 0) || (En[tar].dead == true)) {
                  	// if target is already dead,
                     for(EX = 1;EX<EnTotal;EX++){	// this covers all enemies,
                     	EX+=random(2);             // choose random enemy
                     	if ((En[EX].objTyp == 2) || (En[EX].objTyp == 3))
               			Bul[i].EnTarget = EX;
                        // if enemy is a plane or helicopter, target it!
                     }
                  }
                  EX = Bul[i].x-En[tar].x-En[tar].vx*4; 	// X Distance
                  EY = Bul[i].y-En[tar].y-En[tar].vy*4; 	// Y Distance
                  ED = sqrt(EX*EX + EY*EY)/25.;          // linear distance
                  siz = random(4)+5;                     // random size.
                  if(En[tar].objTyp>1) {                 // if target is active,
                  	if(Bul[i].vx<-EX/ED) Bul[i].vx++;   	// decrease or
                  	if(Bul[i].vx>-EX/ED) Bul[i].vx--;      // increase velocity
                  	if(Bul[i].vy<-EY/ED) Bul[i].vy++;      // to follow target.
                  	if(Bul[i].vy>-EY/ED) Bul[i].vy--;
                  	siz = random(4)+10;                    // random size
                  }
                  else{                                     // if no target is
                  	if (abs(Bul[i].vx)>6) Bul[i].vx*=.9;   // available,
                  	if (abs(Bul[i].vy)>4) Bul[i].vy*=.9;   // slow down missile
                  }
                  Explode(Bul[i].x,Bul[i].y,-Bul[i].vx + random(2)-.5,-Bul[i].vy + random(2)-.5,siz,siz,1);
                  		// make a trailing explosion following the missile.
               	break;
               case 10:	// a NUKE!!!!
               	Bul[i].angle = atan(-(Bul[i].vy)/(Bul[i].vx))/DEG;
                  	// angle is relative to velocity.
                  EX = Bul[i].x-320;	// Distance from the middle of the
                  EY = Bul[i].y-400;	// screen
                  ED = sqrt(EX*EX + EY*EY)/15.; // Linear distance
                  siz = random(8)+13;           // random size
                  if(Bul[i].vx<-EX/ED) Bul[i].vx++;      // decrease or
                  if(Bul[i].vx>-EX/ED) Bul[i].vx--;    	// increase velocity
                  if(Bul[i].vy<-EY/ED) Bul[i].vy++;  		// to go to the center
                  if(Bul[i].vy>-EY/ED) Bul[i].vy--;		// of the screen.
                  Explode(Bul[i].x,Bul[i].y,-Bul[i].vx,-Bul[i].vy,siz,siz,1);
                  //make an explosion relative to size.
                  if(ED<1){	// If Nuke hit the center,
                     NukeLeft=40;         	// start the NUKE timer.
                  	Explode(Bul[i].x,Bul[i].y,0,8,150,120,3);	// make a BIIIGG
                   	Explode(Bul[i].x,Bul[i].y,0,1,240,170,1); // Explosion!!!
                     Bul[i].bulTyp = 0;                  // make bullet inactive
                     for(EX = 1;EX<90;EX++){             // Debris loop
                     	if (random(3) == 1) Explode(Bul[i].x,Bul[i].y,random(1000)/10-50,random(800)/10-40,1,1,2);
                  		Debris(Bul[i].x,Bul[i].y,random(1000)/10-50,random(1000)/10-50,0);
                     	// cause random debris and explosions.
                     }
                  }
                  int vx,vy,x,y; 	// temp variables
                  x = random(120)+Bul[i].x-60; // distance from center
                  y = random(100)+Bul[i].y-50;
                  vx = -(x-Bul[i].x-Bul[i].vx*3)/6; // velocity set to move
                  vy = -(y-Bul[i].y-Bul[i].vy*3)/6; // away from Explosion.
                  Explode(x,y,vx,vy,8,8,1);         // Make an Explosion.

               	break;
               default:
       	     	break;
      	   }
            if (Bul[i].bulTyp >10) Bul[i].bulTyp =0;	// If bullet is inactive.

      	ClrObj(SmBul[Bul[i].bulTyp],Bul[i].lx,Bul[i].ly,Bul[i].langle,Bul[i].lscale,dir);
         	// Clear the current bullet.
      	if ((Bul[i].bulTyp>0)&&(Bul[i].y>LvlHgt(Bul[i].x))) DrawObj(SmBul[Bul[i].bulTyp],Bul[i].x,Bul[i].y,Bul[i].angle,Bul[i].scale,dir);
         	// Draw the new bullet.

      }
   }

   // Draw all Explosions
   for(int i=1;i<ExTotal;i++)  	// for loop covers all explosions.
   {
      if(Ex[i].exTyp>0)          // if explosion is active,
      {

      	Ex[i].lx=Ex[i].x;
      	Ex[i].ly=Ex[i].y;       // remember last position and size.
      	Ex[i].lxsize=Ex[i].xsize;
      	Ex[i].lysize=Ex[i].ysize;
         Ex[i].x+=Ex[i].vx;      // increase position with velocity to create
         Ex[i].y+=Ex[i].vy;		// movement.
         int siz=Ex[i].xsize*2+Ex[i].ysize;	// simplify size
         if (siz>120) siz=120;               // if size is too big.

         SetFillColorRGB(BGCol);                // set fill color to black
      	Circle(Ex[i].lx - Ex[i].xsize,Ex[i].ly - Ex[i].ysize,Ex[i].lx + Ex[i].xsize,Ex[i].ly + Ex[i].ysize,BGCol);
                                             // erase last circle
      	switch(Ex[i].exTyp)     // switch decides what explosions do
      		{
            	case 1:           // regular explosion
               	Ex[i].xsize-=2;	// decrease size
               	Ex[i].ysize-=2;
                  SetFillColor(siz/2.+180,siz*1.75+30,0);   // Explosion color.
                  if (Ex[i].xsize<=0) Ex[i].exTyp=0;     // if explosion is too
         			if (Ex[i].ysize<=0) Ex[i].exTyp=0; 		// small, make inactive
         		break;
           		case 2:           // cloud
               	Ex[i].xsize+=2;	// increase size
               	Ex[i].ysize+=1;
                  SetFillColor(siz/2.+80,siz/2.+80,siz/2.+80);   // Explosion color
         			if (Ex[i].xsize>=22) Ex[i].exTyp=0;         // if too big,
                  														  // make inactive
               break;
           		case 3:          // Rapidly increasing Nuke explosion
               	Ex[i].xsize+=50;	// greatly increase size
               	Ex[i].ysize+=20;
                  SetFillColor(240,120,60);   // Explosion color.
         			if (Ex[i].xsize>=600) Ex[i].exTyp=0;        // if too big,
             														  		  // make inactive
               break;
               case 4:          // Shield explosion
               	Ex[i].x = User.x;  // position falls on User Tank
                  Ex[i].y = User.y+9;
               	Ex[i].xsize-=2;    // decrease size.
               	Ex[i].ysize-=2;
                  SetFillColor(1,siz,255);   // Explosion color, bluish.
         			if (Ex[i].ysize<=0) Ex[i].exTyp=0;			  // if too small,
                  														  // make inactive
               break;
               default:

       	     	break;
      	   }

      	if (Ex[i].exTyp>0) Circle(Ex[i].x - Ex[i].xsize,Ex[i].y - Ex[i].ysize,Ex[i].x + Ex[i].xsize,Ex[i].y + Ex[i].ysize,RGB(siz*2,siz/1.4,siz/2));
         	// draw the circle with the current variables
         if (Ex[i].y < 5+Ex[i].ysize+LvlHgt(Ex[i].x))
         	DrawLevel(true,false,(Ex[i].x-Ex[i].xsize)/10,(Ex[i].x+Ex[i].xsize)/10+1);
         	// if explosion is close to the ground, redraw the ground.

      }   // End if Explosion is active
   } 	// End Ex for loop 



}


