/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BuildTif {
    private static final byte bigEndian = 77;
    private static final byte littleEndian = 73;
    private static final short thisisaTIF = 42;
    private static final int fieldoffset = 8;
    private static final short numfields = 19;
    private static final short NewSubFile = 254;
    private static final short ImageWidth = 256;
    private static final short ImageLength = 257;
    private static final short BitsPerSample = 258;
    private static final short Compression = 259;
    private static final short PhotometricInterpretation = 262;
    private static final short StripOffsets = 273;
    private static final short SamplesPerPixel = 277;
    private static final short RowsPerStrip = 278;
    private static final short StripByteCounts = 279;
    private static final short XResolution = 282;
    private static final short YResolution = 283;
    private static final short PlanarConfiguration = 284;
    private static final short ResolutionUnit = 296;
    private static final short DifferencingPredictor = 317;
    private static final short datais4B = 4;
    private static final short datais2B = 3;
    private static final short dataisrational = 5;
    private static final int onedatavalue = 1;
    private static final int threedatavalues = 3;
    private static final int BPSoffset = 166;
    private static final int XRoffset = 172;
    private static final int YRoffset = 180;
    private static final int SOoffsetvalue = 188;
    private static final short bitspercolour = 8;
    private static final int resdenom = 1;
    private static final byte defaultcolour = -53;
    private static final int BPP = 3;
    private int w;
    private int h;
    private int xres;
    private int yres;
    private File tifname;
    private long pixeloffset;
    private RandomAccessFile outRAF;
    private boolean uselittleEndian = true;

    public BuildTif(int n, int n2, File file, int n3, int n4, boolean bl) {
        this.w = n;
        this.h = n2;
        this.tifname = file;
        this.xres = n3;
        this.yres = n4;
        this.uselittleEndian = bl;
        try {
            this.outRAF = new RandomAccessFile(this.tifname, "rw");
        }
        catch (IOException iOException) {
            System.out.println("BuildTif: Unable to open output file " + this.tifname.toString());
            System.exit(-1);
        }
        this.buildheader();
    }

    private void buildheader() {
        int n;
        long l = 0L;
        try {
            this.outRAF.seek(l);
            if (this.uselittleEndian) {
                this.outRAF.writeByte(73);
                this.outRAF.writeByte(73);
            } else {
                this.outRAF.writeByte(77);
                this.outRAF.writeByte(77);
            }
            this.outRAF.writeShort(this.sflip((short)42));
            this.outRAF.writeInt(this.flip(8));
            this.outRAF.writeShort(this.sflip((short)19));
            this.outRAF.writeShort(this.sflip((short)256));
            this.outRAF.writeShort(this.sflip((short)4));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(this.w));
            this.outRAF.writeShort(this.sflip((short)257));
            this.outRAF.writeShort(this.sflip((short)4));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(this.h));
            this.outRAF.writeShort(this.sflip((short)258));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(3));
            this.outRAF.writeInt(this.flip(166));
            this.outRAF.writeShort(this.sflip((short)259));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeShort(this.sflip((short)262));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(2));
            this.outRAF.writeShort(this.sflip((short)273));
            this.outRAF.writeShort(this.sflip((short)4));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(188));
            this.outRAF.writeShort(this.sflip((short)277));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(3));
            this.outRAF.writeShort(this.sflip((short)278));
            this.outRAF.writeShort(this.sflip((short)4));
            this.outRAF.writeInt(this.flip(1));
            int n2 = this.h;
            n = n2 * this.w * 3;
            this.outRAF.writeInt(this.flip(n2));
            this.outRAF.writeShort(this.sflip((short)279));
            this.outRAF.writeShort(this.sflip((short)4));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(n));
            this.outRAF.writeShort(this.sflip((short)282));
            this.outRAF.writeShort(this.sflip((short)5));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(172));
            this.outRAF.writeShort(this.sflip((short)283));
            this.outRAF.writeShort(this.sflip((short)5));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(180));
            this.outRAF.writeShort(this.sflip((short)284));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeShort(this.sflip((short)296));
            this.outRAF.writeShort(this.sflip((short)3));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeShort(this.sflip((short)8));
            this.outRAF.writeShort(this.sflip((short)8));
            this.outRAF.writeShort(this.sflip((short)8));
            this.outRAF.writeInt(this.flip(this.xres));
            this.outRAF.writeInt(this.flip(1));
            this.outRAF.writeInt(this.flip(this.yres));
            this.outRAF.writeInt(this.flip(1));
            this.pixeloffset = l = this.outRAF.getFilePointer();
        }
        catch (IOException iOException) {
            System.out.println("BuildHeader: Unable to write header to output file " + this.tifname.toString());
            System.exit(-1);
        }
        try {
            byte[] byArray = new byte[this.w * 3];
            n = 0;
            while (n < byArray.length) {
                byArray[n] = -53;
                ++n;
            }
            int n3 = 0;
            while (n3 < this.h) {
                this.outRAF.write(byArray);
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.out.println("BuildHeader: Unable to initialize image to grey: " + this.tifname.toString());
            System.exit(-1);
        }
    }

    public void fintif() {
        try {
            this.outRAF.close();
        }
        catch (IOException iOException) {
            System.out.println("FinTIF: Unable to close output file " + this.tifname.toString());
            System.exit(-1);
        }
    }

    private int flip(int n) {
        if (this.uselittleEndian) {
            int n2 = n >> 24 & 0xFF;
            int n3 = n >> 16 & 0xFF;
            int n4 = n >> 8 & 0xFF;
            int n5 = n & 0xFF;
            return n5 << 24 | n4 << 16 | n3 << 8 | n2;
        }
        return n;
    }

    private TriCol getcolours(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        TriCol triCol = new TriCol(n2, n3, n4);
        return triCol;
    }

    public void putpixels(int n, int n2, int[] nArray) {
        byte[] byArray = new byte[nArray.length * 3];
        int n3 = 0;
        while (n3 < nArray.length) {
            TriCol triCol = this.getcolours(nArray[n3]);
            byArray[n3 * 3] = (byte)triCol.R;
            byArray[n3 * 3 + 1] = (byte)triCol.G;
            byArray[n3 * 3 + 2] = (byte)triCol.B;
            ++n3;
        }
        try {
            this.outRAF.seek(this.pixeloffset + (long)((n + n2 * this.w) * 3));
            this.outRAF.write(byArray);
        }
        catch (IOException iOException) {
            System.out.println("PutPixels: Unable to write pixels to image: " + this.tifname.toString());
            System.exit(-1);
        }
    }

    private short sflip(short s) {
        if (this.uselittleEndian) {
            short s2 = (short)(s >> 8 & 0xFF);
            short s3 = (short)(s & 0xFF);
            return (short)(s3 << 8 | s2);
        }
        return s;
    }
}

