
#include "sources.cpp\licht.h"


/*
  Helligkeitsberechnung:

Ich ermittle die Distanz zwischen einer gegebenen 3D-Koordinate und der
Lichtquelle, indem ich zunaechst die Unterschiede fuer die einzelnen
Komponenten errechne;

 dx= x(licht) - x(punkt)  dy= y(licht) - y(punkt)  dz= z(licht) - z(punkt)

Nach Pythagoras gilt dann:  d^2=dx^2+dy^2+dz^2

Da Quadratwurzeln rechenintensiv sind, und ich das Ergebnis nur zum Vergleich
mit der Reichweite der Lichtquelle brauche, lege ich mir eine Tabelle an,
in der die Reichweite schon fuer jede Intensitaetsstufe als Grenzwert fuer
d^2 quadriert vorliegt.

Um die Intensitaet eines Punktes zu berechnen, ermittle ich d^2 und vergleiche
es mit dem groessten Grenzwert. Ist dieser groesser so vergleiche ich mit dem
naechst kleineren. Der Index ergibt die Intensitaet von einer Lichtquelle an
einem bestimmten Punkt, zu dem noch der Intensitaetsoffset der Leuchte addiert
wird.

So summiere ich ambientes Licht mit den Helligkeitswerten aller angeschalteten
Lichtquellen, indem ich die verkettete Liste von Leuchten durcharbeite.

Das hier vorgestellte Beleuchtungsmodell wird der Physik nur aeusserst wage
gerecht, bietet jedoch eine schnelle Annaeherung, die fuer unsere Abbildungen
(die ihrerseits natuerlich auch nur Annaeherungen an eine dreidimensionale
Szenerie sind) genuegen sollte.

*/


/////////// Implementation Klasse Leuchte //////////////////////////////////


leuchte::leuchte(punkt ort,word laenge,int intens)
{
  x=ort.x; y=ort.y; z=ort.z;
  reichweite=laenge;
  intensitaet=intens;
  power=an;
  for(int c=0; c<=licht_tiefe; c++)
    grenzwert[c]=(unsigned long int)(laenge/licht_tiefe*c)*(laenge/licht_tiefe*c);
  naechste=vorherig=NULL;
}


punkt leuchte::ort_holen()
{
  punkt p;
  p.x=x; p.y=y; p.z=z;
  return(p);
}


void leuchte::ort_setzen(punkt ort)
{
  x=ort.x; y=ort.y; z=ort.z;
}


void leuchte::an_aus_schalter(schalter an_aus)
{
  power=an_aus;
}



/////////// Implementation Klasse Beleuchtung //////////////////////////////


beleuchtung::beleuchtung(word mnl)
{
  erste_leuchte=letzte_leuchte=NULL;
  minimal_licht=mnl;
}


void beleuchtung::minimal_licht_setzen(word mnl)
{
  minimal_licht=mnl;
}


void beleuchtung::leuchte_einfuegen(leuchte *zeiger)
{
  if (erste_leuchte!=NULL) {
    letzte_leuchte->naechste=zeiger;
    zeiger->vorherig=letzte_leuchte;
    letzte_leuchte=zeiger;
  } else {
    erste_leuchte=letzte_leuchte=zeiger;
  }
}


void beleuchtung::leuchte_herausnehmen(leuchte *zeiger)
{
  leuchte *v,*n;

  v=zeiger->vorherig;
  n=zeiger->naechste;

  if (v!=NULL) {
    v->naechste=n;
  } else {
    erste_leuchte=n;
  }
  if (n!=NULL) {
    n->vorherig=v;
  } else {
    letzte_leuchte=v;
  }
}


word beleuchtung::helligkeit_ermitteln(int x,int y,int z)
{
  word c,licht;
  unsigned long delta,dx,dy,dz;
  leuchte *akt=erste_leuchte;
  licht=minimal_licht;
  while (akt!=NULL) {
    if (akt->power!=aus) {
      dx=akt->x-x; dy=akt->y-y; dz=akt->z-z;
      delta=dx*dx+dy*dy+dz*dz;
      c=licht_tiefe;
      while (akt->grenzwert[c]>=delta) c--;
      licht+=licht_tiefe-c+akt->intensitaet;
    }
    akt=akt->naechste;
  }
  if (licht>maximal_licht) licht=maximal_licht;
  return(licht);
}


