// DlgEditPlotP.cpp : implementation file
//

#include "stdafx.h"
#include "Plot3dp.h"
#include "Win3dp.h"
#include "DlgEditPlotP.h"
#include "DlgHelpParm.h"
#include "DlgNewSurface.h"
#include "DlgSyntax.h"
#include "..\Common\WinPlotReg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotP dialog


DlgEditPlotP::DlgEditPlotP(CWnd* pParent /*=NULL*/)
	: CDialog(DlgEditPlotP::IDD, pParent)
{
	m_pXPlotCalc = 0;
	m_pYPlotCalc = 0;
	m_pZPlotCalc = 0;
	m_pRPlotCalc = 0;
	m_pGPlotCalc = 0;
	m_pBPlotCalc = 0;
	//{{AFX_DATA_INIT(DlgEditPlotP)
	//}}AFX_DATA_INIT
	m_surface_name = DEFAULT_SURFACE;
	// other data is iniitalized in OnInitDialog()
}

void DlgEditPlotP::SetDefaults()
{
 	UpdateData(FALSE);	// load these values into the dialog
	// Note: don't set m_surface_name
	m_xPlotEquation = _T("u");
	m_yPlotEquation = _T("v");
	m_zPlotEquation = _T("1");
	m_rPlotEquation = _T("100");
	m_gPlotEquation = _T("100");
	m_bPlotEquation = _T("100");
	m_sC1 = _T("1");
	m_sC2 = _T("1");
	m_sC3 = _T("1");
	m_sC4 = _T("1");
	m_sC5 = _T("1");
	m_sC6 = _T("1");
	m_sC7 = _T("1");
	m_sC8 = _T("1");
	m_zrotate = 70.0;
	m_xytilt  = 60.0;
	m_line_color = RGB(0,0,0);	// black
	m_background_color = RGB(255,255,255);	// white
	m_is_color = FALSE;
	m_remove_hidden_lines = TRUE;
	m_scale = 1.0;
	m_show_axis = FALSE;
	m_draw_ulines = TRUE;
	m_draw_vlines = TRUE;
	m_sEquationStatus = _T("");
	m_is_equation_ok = 0;
	m_umin = -10.0;
	m_umax =  10.0;
	m_vmin = -10.0;
	m_vmax =  10.0;
	m_uLines = 100;
	m_vLines = 100;
}

void DlgEditPlotP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DlgEditPlotP)
	DDX_Control(pDX, IDC_COMBO_LIST_SURFACE, m_list_surfaces);
	DDX_Text(pDX, IDC_EDIT_ZROTATE, m_zrotate);
	DDX_Text(pDX, IDC_EDIT_XYTILT, m_xytilt);
	DDX_Check(pDX, IDC_CHECK_HIDDEN_LINE_REMOVAL, m_remove_hidden_lines);
	DDX_Text(pDX, IDC_EDIT_SCALE, m_scale);
	DDV_MinMaxDouble(pDX, m_scale, 1.e-002, 1.);
	DDX_Text(pDX, IDC_EDIT_C1, m_sC1);
	DDX_Text(pDX, IDC_EDIT_C2, m_sC2);
	DDX_Text(pDX, IDC_EDIT_C3, m_sC3);
	DDX_Text(pDX, IDC_EDIT_C4, m_sC4);
	DDX_Text(pDX, IDC_EDIT_C5, m_sC5);
	DDX_Text(pDX, IDC_EDIT_C6, m_sC6);
	DDX_Text(pDX, IDC_EDIT_C7, m_sC7);
	DDX_Text(pDX, IDC_EDIT_C8, m_sC8);
	DDX_Text(pDX, IDC_EDIT_EQUATION_STATUS, m_sEquationStatus);
	DDX_Check(pDX, IDC_CHECK_SHOW_AXIS, m_show_axis);
	DDX_Text(pDX, IDC_EDIT_ULINES, m_uLines);
	DDX_Text(pDX, IDC_EDIT_UMAX, m_umax);
	DDX_Text(pDX, IDC_EDIT_UMIN, m_umin);
	DDX_Text(pDX, IDC_EDIT_VLINES, m_vLines);
	DDX_Text(pDX, IDC_EDIT_VMAX, m_vmax);
	DDX_Text(pDX, IDC_EDIT_VMIN, m_vmin);
	DDX_Text(pDX, IDC_EDIT_XPLOT_EQUATION, m_xPlotEquation);
	DDX_Text(pDX, IDC_EDIT_YPLOT_EQUATION, m_yPlotEquation);
	DDX_Text(pDX, IDC_EDIT_ZPLOT_EQUATION, m_zPlotEquation);
	DDX_Text(pDX, IDC_EDIT_RPLOT_EQUATION, m_rPlotEquation);
	DDX_Text(pDX, IDC_EDIT_GPLOT_EQUATION, m_gPlotEquation);
	DDX_Text(pDX, IDC_EDIT_BPLOT_EQUATION, m_bPlotEquation);
	DDX_Check(pDX, IDC_CHECK_DRAW_ULINES, m_draw_ulines);
	DDX_Check(pDX, IDC_CHECK_DRAW_VLINES, m_draw_vlines);
	DDX_Check(pDX, IDC_CHECK_SHOW_COLOR, m_is_color);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DlgEditPlotP, CDialog)
	//{{AFX_MSG_MAP(DlgEditPlotP)
	ON_BN_CLICKED(IDC_BUTTON_LINE_COLOR, OnButtonLineColor)
	ON_BN_CLICKED(IDC_BUTTON_BACKGROUND_COLOR, OnButtonBackgroundColor)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_PARM_HELP, OnParmHelp)
	ON_BN_CLICKED(IDC_BUTTON_TEST, OnButtonTest)
	ON_BN_CLICKED(IDC_BUTTON_NEW, OnButtonNew)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_CBN_SELCHANGE(IDC_COMBO_LIST_SURFACE, OnSelchangeComboListSurface)
	ON_BN_CLICKED(IDC_BUTTON_SYNTAX, OnButtonSyntax)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_BN_CLICKED(IDC_CANCEL, OnCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// if name is null, just save existing name
int DlgEditPlotP::SetSurfaceName(CString name)
{
	HKEY hkey = 0;

	if (OpenReg(PLOT_REGISTRY_HIVE,1,&hkey)!=0) return(1);
	if (!name.IsEmpty())
		m_surface_name = name;
	if (m_surface_name.IsEmpty()) m_surface_name = DEFAULT_SURFACE;
	SetRegStr(hkey,"CurrentSurface", m_surface_name);
	CloseReg(hkey);
	return(0);
}

// ------------------------------------------------------------------------
// get current surface name from regisitry
CString DlgEditPlotP::GetSurfaceName()
{
	HKEY hkey = 0;
	char TempBuf[200];
	CString name = DEFAULT_SURFACE;

	if (OpenReg(PLOT_REGISTRY_HIVE,1,&hkey)!=0) return(name);
	if (GetRegStr(hkey, "CurrentSurface", TempBuf,sizeof(TempBuf)) == 0)
		name = TempBuf;
	CloseReg(hkey);
	if (name.IsEmpty()) name = DEFAULT_SURFACE;
	return(name);
}

// ------------------------------------------------------------------------
void DlgEditPlotP::SaveToRegistry()
{
	HKEY hkey = 0;

	// save the current surface name
	SetSurfaceName();

	// open registry
	if (OpenReg(GetSurfaceRegPath(),1,&hkey)!=0) return;

	// save the surface parameters
 	UpdateData(TRUE);	// get values from dialog
 	SetRegStr   (hkey, "XPlotEquation", m_xPlotEquation);
 	SetRegStr   (hkey, "YPlotEquation", m_yPlotEquation);
 	SetRegStr   (hkey, "ZPlotEquation", m_zPlotEquation);
 	SetRegStr   (hkey, "RPlotEquation", m_rPlotEquation);
 	SetRegStr   (hkey, "GPlotEquation", m_gPlotEquation);
 	SetRegStr   (hkey, "BPlotEquation", m_bPlotEquation);
	SetRegStr   (hkey, "C1",	       m_sC1);
	SetRegStr   (hkey, "C2",	       m_sC2);
	SetRegStr   (hkey, "C3",	       m_sC3);
	SetRegStr   (hkey, "C4",	       m_sC4);
	SetRegStr   (hkey, "C5",	       m_sC5);
	SetRegStr   (hkey, "C6",	       m_sC6);
	SetRegStr   (hkey, "C7",	       m_sC7);
	SetRegStr   (hkey, "C8",	       m_sC8);
	SetRegDouble(hkey, "ZRotate",      m_zrotate);
	SetRegDouble(hkey, "XYTilt",       m_xytilt);
	SetRegLong  (hkey, "LineColor",    m_line_color);
	SetRegLong  (hkey, "BackgroundColor",  m_background_color);
	SetRegInt   (hkey, "ShowColor",    m_is_color);
	SetRegInt   (hkey, "DrawULines",   m_draw_ulines);
	SetRegInt   (hkey, "DrawVLines",   m_draw_vlines);
	SetRegInt   (hkey, "RemoveHidden", m_remove_hidden_lines);
	SetRegDouble(hkey, "PlotScale",    m_scale);
 	SetRegInt   (hkey, "ShowAxis",     m_show_axis);
	SetRegDouble(hkey, "UMin",         m_umin);
	SetRegDouble(hkey, "UMax",         m_umax);
	SetRegDouble(hkey, "VMin",         m_vmin);
	SetRegDouble(hkey, "VMax",         m_vmax);
	SetRegInt   (hkey, "NULines",      m_uLines);
	SetRegInt   (hkey, "NVLines",      m_vLines);
	CloseReg(hkey);
}

/////////////////////////////////////////////////////////////////////////////
int  DlgEditPlotP::GetFromRegistry()
{
	HKEY hkey = 0;
	char TempBuf[200];


	// get the current surface name
	m_surface_name = GetSurfaceName();

	// open registry
	if (OpenReg(GetSurfaceRegPath(),1,&hkey)!=0) return(1);

	// get surface parameters
 	UpdateData(FALSE);	// load these values into the dialog
	if(GetRegStr(hkey, "XPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_xPlotEquation = TempBuf;
	if(GetRegStr(hkey, "YPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_yPlotEquation = TempBuf;
	if(GetRegStr(hkey, "ZPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_zPlotEquation = TempBuf;
	if(GetRegStr(hkey, "RPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_rPlotEquation = TempBuf;
	if(GetRegStr(hkey, "GPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_gPlotEquation = TempBuf;
	if(GetRegStr(hkey, "BPlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_bPlotEquation = TempBuf;
	if(GetRegStr(hkey, "C1", TempBuf,sizeof(TempBuf)) == 0)  m_sC1 = TempBuf;
	if(GetRegStr(hkey, "C2", TempBuf,sizeof(TempBuf)) == 0)  m_sC2 = TempBuf;
	if(GetRegStr(hkey, "C3", TempBuf,sizeof(TempBuf)) == 0)  m_sC3 = TempBuf;
	if(GetRegStr(hkey, "C4", TempBuf,sizeof(TempBuf)) == 0)  m_sC4 = TempBuf;
	if(GetRegStr(hkey, "C5", TempBuf,sizeof(TempBuf)) == 0)  m_sC5 = TempBuf;
	if(GetRegStr(hkey, "C6", TempBuf,sizeof(TempBuf)) == 0)  m_sC6 = TempBuf;
	if(GetRegStr(hkey, "C7", TempBuf,sizeof(TempBuf)) == 0)  m_sC7 = TempBuf;
	if(GetRegStr(hkey, "C8", TempBuf,sizeof(TempBuf)) == 0)  m_sC8 = TempBuf;
	GetRegDouble(hkey, "ZRotate",      &m_zrotate);
	GetRegDouble(hkey, "XYTilt",       &m_xytilt);
	GetRegLong  (hkey, "LineColor",    (long*)&m_line_color);
	GetRegLong  (hkey, "BackgroundColor",  (long*)&m_background_color);
	GetRegInt   (hkey, "ShowColor",    &m_is_color);
	GetRegInt   (hkey, "RemoveHidden", &m_remove_hidden_lines);
	GetRegDouble(hkey, "PlotScale",    &m_scale);
 	GetRegInt   (hkey, "ShowAxis",     &m_show_axis);
 	GetRegInt   (hkey, "DrawULines",   &m_draw_ulines);
 	GetRegInt   (hkey, "DrawVLines",   &m_draw_vlines);
	GetRegDouble(hkey, "UMin",         &m_umin);
	GetRegDouble(hkey, "UMax",         &m_umax);
	GetRegDouble(hkey, "VMin",         &m_vmin);
	GetRegDouble(hkey, "VMax",         &m_vmax);
	GetRegInt   (hkey, "NULines",      (int*)&m_uLines);
	GetRegInt   (hkey, "NVLines",      (int*)&m_vLines);
	CloseReg(hkey);
	return(0);
}

// ------------------------------------------------------
// create a string path for the plot registry
CString DlgEditPlotP::GetPlotRegPath()
{
	CString sHive = PLOT_REGISTRY_HIVE;
	sHive += "\\";
	sHive += SURFACE_HIVE_SUBDIR;
	return(sHive);
}

// ------------------------------------------------------
// create a string path for the suface registry
CString DlgEditPlotP::GetSurfaceRegPath()
{
	CString sHive = PLOT_REGISTRY_HIVE;
	sHive += "\\";
	sHive += SURFACE_HIVE_SUBDIR;
	sHive += "\\";
	if (m_surface_name.IsEmpty()) m_surface_name = DEFAULT_SURFACE;
	sHive += m_surface_name;
	return(sHive);
}

// ------------------------------------------------------
void DlgEditPlotP::UpdateDialogState()
{
 	UpdateData(FALSE); // load values into dialog
	// set color buttons
	CWnd* pWnd;
	RECT rect;
	pWnd = (CWnd *)GetDlgItem(IDC_STATIC_FG);
	if (pWnd)
	{
		pWnd->GetClientRect(&rect);
		pWnd->GetDC()->FillSolidRect(&rect,m_line_color);
		pWnd->Invalidate();
	}

	pWnd = (CWnd *)GetDlgItem(IDC_STATIC_BG);
	if (pWnd)
	{
		pWnd->GetClientRect(&rect);
		pWnd->GetDC()->FillSolidRect(&rect,m_background_color);
		pWnd->Invalidate();
	}

	// update surface name drop-down box
	HKEY hKey;
	char Buffer[200];
	int index;
	if (OpenReg(GetPlotRegPath(),0,&hKey) == 0)
	{
	 	m_list_surfaces.ResetContent();
		m_list_surfaces.SetCurSel(0);
		for (index=0;   ;index++)
		{
			if (EnumRegKey(hKey,index,Buffer,sizeof(Buffer))) break;
	 		m_list_surfaces.AddString(Buffer);
			if (stricmp(Buffer,(LPCTSTR)m_surface_name)!=0) continue;
			m_list_surfaces.SetCurSel(index);
		} // for
		m_list_surfaces.Invalidate();
		CloseReg(hKey);
	}
}

// ------------------------------------------------------
// Attatch the calculator to the dialog
void DlgEditPlotP::AttachCalculator(PlotCalc* pXPlotCalc,PlotCalc* pYPlotCalc,PlotCalc* pZPlotCalc,
									PlotCalc* pRPlotCalc,PlotCalc* pGPlotCalc,PlotCalc* pBPlotCalc)
{
	m_pXPlotCalc = pXPlotCalc;
	m_pYPlotCalc = pYPlotCalc;
	m_pZPlotCalc = pZPlotCalc;
	m_pRPlotCalc = pRPlotCalc;
	m_pGPlotCalc = pGPlotCalc;
	m_pBPlotCalc = pBPlotCalc;
}

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotP message handlers

void DlgEditPlotP::OnOK() 
{
	OnButtonTest();	// test equation before returning
	if (!m_is_equation_ok)
	{
		AfxMessageBox("Plot equation errors", MB_OK);
		return;
	}

	// save settings to windows registry
	SaveToRegistry();
	
	CDialog::OnOK();
}

// ------------------------------------------------------
void DlgEditPlotP::OnCancel() 
{
	CDialog::OnCancel();
}

// ------------------------------------------------------
BOOL DlgEditPlotP::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// initialize data
	SetDefaults();
	GetFromRegistry();
	// update dialog to reflect state
	UpdateDialogState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ------------------------------------------------------
void DlgEditPlotP::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotP::OnParmHelp() 
{
	CDlgHelpParm dlg;
	dlg.DoModal();
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonTest() 
{
	int xcol, ycol, zcol, rcol, gcol, bcol;

	if (m_pXPlotCalc==0) return;
	if (m_pYPlotCalc==0) return;
	if (m_pZPlotCalc==0) return;
	if (m_pRPlotCalc==0) return;
	if (m_pGPlotCalc==0) return;
	if (m_pBPlotCalc==0) return;

	// update calculator - load constants and program
 	UpdateData(TRUE); // get values from dialog
 	xcol = m_pXPlotCalc->LoadProgram("X",(LPCTSTR)m_xPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

 	ycol = m_pYPlotCalc->LoadProgram("Y",(LPCTSTR)m_yPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

 	zcol = m_pZPlotCalc->LoadProgram("Z",(LPCTSTR)m_zPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

 	rcol = m_pRPlotCalc->LoadProgram("R",(LPCTSTR)m_rPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

 	gcol = m_pGPlotCalc->LoadProgram("G",(LPCTSTR)m_gPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

 	bcol = m_pBPlotCalc->LoadProgram("B",(LPCTSTR)m_bPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8,1);

	m_is_equation_ok = (xcol || ycol || zcol || rcol || gcol || bcol) ? 0 : 1;

	// show Status string
	if (xcol)
	{ m_sEquationStatus = m_pXPlotCalc->GetErrString(); }
	else if (ycol)
	{ m_sEquationStatus = m_pYPlotCalc->GetErrString(); }
	else if (zcol)
	{ m_sEquationStatus = m_pZPlotCalc->GetErrString(); }
	else if (rcol)
	{ m_sEquationStatus = m_pRPlotCalc->GetErrString(); }
	else if (gcol)
	{ m_sEquationStatus = m_pGPlotCalc->GetErrString(); }
	else
	{ m_sEquationStatus = m_pBPlotCalc->GetErrString(); }

 	SetDlgItemText(IDC_EDIT_EQUATION_STATUS,m_sEquationStatus);
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonLineColor() 
{
	CColorDialog dlg(m_line_color,CC_ANYCOLOR,this);
	if (dlg.DoModal() == IDOK)
	{
		m_line_color = dlg.GetColor();
		UpdateDialogState();
	}
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonBackgroundColor() 
{
	CColorDialog dlg(m_background_color,CC_ANYCOLOR,this);
	if (dlg.DoModal() == IDOK)
	{
		m_background_color = dlg.GetColor();
		UpdateDialogState();
	}
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonNew() 
{
	CDlgNewSurface dlg;
	if (dlg.DoModal() != IDOK) return;
	CString sNewName = dlg.GetNewName();

	HKEY hKey;
	char Buffer[200];
	int is_dup=0, index;

	// see if name already exists
	if (OpenReg(GetPlotRegPath(),0,&hKey)==0)
	{
		for (index=0; ;index++)
		{
			if (EnumRegKey(hKey,index,Buffer,sizeof(Buffer))) break;
			if (stricmp(Buffer,(LPCTSTR)sNewName)!=0) continue;
			is_dup = 1;
			break;
		} // for
		CloseReg(hKey);
	}
	if (is_dup)
	{
		sprintf(Buffer,"%s already exists", (LPCTSTR)sNewName );
		AfxMessageBox(Buffer, MB_OK);
		return;
	}

	// save data to registry
	m_surface_name = sNewName;
	SaveToRegistry();
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonDelete() 
{
	int rc;
	CString msg;

	msg.Format("Delete %s surface?", (LPCTSTR)m_surface_name);
	if (AfxMessageBox((LPCTSTR)msg, MB_OKCANCEL) != IDOK) return;

	// delete surface registry info
	HKEY hKey;
	char Buffer[200];
	int index;
	if (OpenReg(GetSurfaceRegPath(),0,&hKey)==0)
	{
		// delete all registry values first
	 	for (index=0; ;index++)
	 	{
	 		if (EnumRegValue(hKey,index,Buffer,sizeof(Buffer))) break;
			rc = DelRegValue(hKey,Buffer);
	 	} // for
		CloseReg(hKey);
	}
	// delete registry key
	if (OpenReg(GetPlotRegPath(),0,&hKey)==0)
	{
		rc = DelRegKey(hKey,(LPCTSTR)m_surface_name);
		CloseReg(hKey);
	}

	// set current to first list item
	UpdateData(FALSE); // load values into dialog
	CString sNewName;
	m_list_surfaces.GetLBText(0,sNewName);
	if (sNewName==m_surface_name)
		m_list_surfaces.GetLBText(1,sNewName);
	// change to selected surface
	SetSurfaceName(sNewName);
	// get surface info from registry
	GetFromRegistry();
	// update the dialog
	UpdateDialogState();
	Invalidate();
}

// ------------------------------------------------------
void DlgEditPlotP::OnSelchangeComboListSurface() 
{
	CString sNewName;
	int index;

 	UpdateData(TRUE); // get values from dialog
	index = m_list_surfaces.GetCurSel();
	m_list_surfaces.GetLBText(index,sNewName);
	if (sNewName.IsEmpty()) return;
	// save current surface
	SaveToRegistry();
	// change to selected surface
	SetSurfaceName(sNewName);
	// get surface info from registry
	GetFromRegistry();
	// update the dialog
	UpdateDialogState();
	Invalidate();
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonSyntax() 
{
	DlgSyntax dlg;
	dlg.DoModal();
}

// ------------------------------------------------------
void DlgEditPlotP::OnButtonSave() 
{
	SaveToRegistry();
	UpdateDialogState();
}

