// Win3DZView.cpp : implementation of the CWin3DZView class
//

#include "stdafx.h"
#include "Win3DZ.h"
#include "WinPlot3DZ.h"
#include "Win3DZDoc.h"
#include "Win3DZView.h"
#include "DlgEditPlotZ.h"
#include "DlgWinResize.h"
#include "DlgGetStart.h"
#include "DlgIntro.h"
#include "DlgTips.h"
#include "DlgHiddenLine.h"
#include "DlgHelpParm.h"
#include "DlgCppProgram.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	CWin3DZApp theApp;	// access the windows application


/////////////////////////////////////////////////////////////////////////////
// CWin3DZView

IMPLEMENT_DYNCREATE(CWin3DZView, CView)

BEGIN_MESSAGE_MAP(CWin3DZView, CView)
	//{{AFX_MSG_MAP(CWin3DZView)
	ON_WM_CHAR()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_HELP_GETTINGSTARTED, OnHelpGettingstarted)
	ON_COMMAND(ID_HELP_INTRODUCTION, OnHelpIntroduction)
	ON_COMMAND(ID_HELP_TIPS, OnHelpTips)
	ON_COMMAND(ID_RESIZE_WINDOW, OnResizeWindow)
	ON_COMMAND(ID_DRAW_PLOT, OnDrawPlot)
	ON_COMMAND(ID_HELP_HIDDENLINEREMOVAL, OnHelpHiddenlineremoval)
	ON_COMMAND(ID_HELP_PLOTPARAMETERS, OnHelpPlotparameters)
	ON_COMMAND(ID_HELP_CPROGRAMMING, OnHelpCprogramming)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWin3DZView construction/destruction

CWin3DZView::CWin3DZView()
{
	m_is_drawn = 0;

	char* pName=0;
	pName = _tempnam( "", "p3d" );
	if(pName == NULL)
	{
		pName = "p3d";
	}
	m_fn_cap = CString(pName) + CString(".tmp");
	m_abort_plotting = 0;
}

CWin3DZView::~CWin3DZView()
{
	remove((LPCTSTR)m_fn_cap);	// remove the scratch file
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DZView drawing

void CWin3DZView::OnDraw(CDC* pDC)
{
	if (!m_is_drawn) return;
	FILE* fh;
	char ReadBuf[100];
	char TextBuf[100];
	char FontNameBuf[100];
	int	is_color=0,xv,yv,it1,it2;
	char* pStr;
	long color=1, ltemp, ltemp2, ltemp3;

	// get window size
	RECT rect;
	GetClientRect(&rect);
	CSize wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);

	// rescale for printer
	if (pDC->IsPrinting())
	{
		CWnd* pdcWnd = pDC->GetWindow();
		if (pdcWnd)
		{
			pdcWnd->GetClientRect(&rect);
			wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);
		}
	}

	// set mapping mode and view port extents
	pDC->SetMapMode(MM_ISOTROPIC);
	pDC->SetWindowOrg(0,wsize.cy);
	pDC->SetWindowExt(wsize);
	pDC->SetViewportExt(wsize);
	pDC->ScaleViewportExt(1,1,-1,1);	// invert y coordinate

	// open the drawing command file
	fh = fopen((LPCTSTR)m_fn_cap,"r");
	if (fh==0) return;
	memset(ReadBuf,0,sizeof(ReadBuf));
	fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
	if (memcmp(ReadBuf,PLOT3D_FILE_SIG,strlen(PLOT3D_FILE_SIG)) != 0) { fclose(fh); return; }
	pStr = &ReadBuf[strlen(PLOT3D_FILE_SIG)+1];
	if (memcmp(pStr,PLOT3D_COLOR_MODE,strlen(PLOT3D_COLOR_MODE)) == 0) is_color=1;

	// interpret drawing commands from file
	while( !feof(fh) )
	{
		memset(ReadBuf,0,sizeof(ReadBuf));
		fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
		if (ReadBuf[0] == 'S')
		{
			// "S=%ld,%ld"  background,pencolor
			if (sscanf(&ReadBuf[2],"%ld,%ld",&ltemp, &ltemp2) != EOF)
			{
				// clear screen to background color
				RECT rect;
				GetClientRect(&rect);
				pDC->FillSolidRect(&rect,ltemp);

				// set pen color
				CPen* pOldPen;
				CPen Pen(PS_SOLID,1,ltemp2);		// construct a pen with the desired color
		        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
			}
		}
		else if (ReadBuf[0] == 'C')	// color
		{
			// "C=%-12d\n"
			if (sscanf(&ReadBuf[2],"%d",&ltemp) != EOF) color = ltemp;
		}
		else if (ReadBuf[0] == 'M')	// move
		{
			// "M=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;
				pDC->MoveTo(xv,yv);
			}
		}
		else if (ReadBuf[0] == 'D')	// draw
		{
			// "D=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;

				if (is_color)
				{
					CPen* pOldPen;
					CPen Pen(PS_SOLID,1,color);	// construct a pen with the desired color
			        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
					pDC->LineTo(xv,yv);		   	// draw the colored line
			        pDC->SelectObject(pOldPen);	// restore the original pen
				}
				else
				{
					// just draw the line if in monochrome mode
					pDC->LineTo(xv,yv);
				}
			}
		}
		else if (ReadBuf[0] == 'T')	// text
		{
			// "T=%6d,%6d,%ld,%ld,%ld,%s,%s\n",
			if (sscanf(&ReadBuf[2],"%6d,%6d,%ld,%ld,%ld,%s %s",&it1,&it2,&ltemp,&ltemp2,&ltemp3,FontNameBuf,TextBuf) != EOF)
			{
				xv = it1;
				yv = it2;

				// setup font info
				LOGFONT logFont;
				memset((char*)&logFont,0,sizeof(logFont));
				strcpy(logFont.lfFaceName,FontNameBuf);
				logFont.lfHeight = ltemp;
				logFont.lfWidth  = ltemp2;
				logFont.lfEscapement = ltemp3;
		
				// create a rotated font
				CFont rotFont;
				rotFont.CreateFontIndirect(&logFont);
		
				// output the text
				// ### show text in m_line_color
				pDC->SelectObject(rotFont);
				pDC->TextOut(xv,yv,CString(TextBuf));
			}
		}

	} // while
	fclose(fh);
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DZView diagnostics

#ifdef _DEBUG
void CWin3DZView::AssertValid() const
{
	CView::AssertValid();
}

void CWin3DZView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWin3DZDoc* CWin3DZView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWin3DZDoc)));
	return (CWin3DZDoc*)m_pDocument;
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CWin3DZView message handlers

void CWin3DZView::OnResizeWindow() 
{
	DlgWinResize dlg;
	if (dlg.DoModal()!=IDOK || !dlg.IsSizeSet())
		return;

	GetParent()->MoveWindow(0,0,dlg.m_WinCols,dlg.m_WinRows,TRUE);
}

////////////////////////////////////////////////////////////////////////////////////////////
// used to check for user abort via ESC key pressed
void CWin3DZView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// check for ESC key pressed
	if (nChar == VK_ESCAPE)
		m_abort_plotting = 1;

	CView::OnChar(nChar, nRepCnt, nFlags);
}

////////////////////////////////////////////////////////////////////////////////////////////

BOOL CWin3DZView::OnPreparePrinting(CPrintInfo* pInfo) 
{
	pInfo->SetMaxPage(1);
	return DoPreparePrinting(pInfo);
}

void CWin3DZView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	CSize winsize = pDC->GetWindowExt();
//	unsigned int dx = pDC->GetDeviceCaps(HORZRES);
//	unsigned int dy = pDC->GetDeviceCaps(VERTRES);


	CView::OnBeginPrinting(pDC, pInfo);
}

void CWin3DZView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
	CView::OnEndPrinting(pDC, pInfo);
}

void CWin3DZView::OnEndPrintPreview(CDC* pDC, CPrintInfo* pInfo, POINT point, CPreviewView* pView) 
{
	CView::OnEndPrintPreview(pDC, pInfo, point, pView);
}

void CWin3DZView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	CView::OnPrepareDC(pDC, pInfo);
}

void CWin3DZView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	CView::OnPrint(pDC, pInfo);
}

void CWin3DZView::OnDrawPlot() 
{
	// create a plot object
	WinPlot3DZ	 plot3D;

	// create a dialog box and allow user input
	DlgEditPlotZ  dlg;
	dlg.AttachCalculator(plot3D.m_pPlotCalc);
	if (dlg.DoModal()!=IDOK)
		return;

	// get clients rectangle size
	GetClientRect(&m_plot_rect);

	// set plot object parameters from dialog info
	plot3D.SetWnd(this,&theApp);
	plot3D.SetRanges(dlg.m_xmin,dlg.m_xmax,dlg.m_ymin,dlg.m_ymax,dlg.m_zmin,dlg.m_zmax);
	plot3D.SetViewingPosition(dlg.m_xytilt,dlg.m_zrotate);
	plot3D.SetParameters(dlg.m_nxlines,dlg.m_nylines,dlg.m_show_xlines,dlg.m_show_ylines,dlg.m_remove_hidden_lines);
	plot3D.SetVideoRes((int)m_plot_rect.left,(int)m_plot_rect.top,(int)m_plot_rect.right,(int)m_plot_rect.bottom,dlg.m_scale);
	plot3D.SetDrawRate(dlg.m_slow_draw?dlg.m_slow_draw_rate:0);
	plot3D.SetColorMode(dlg.m_is_color);
	plot3D.SetFileName(m_fn_cap);
	plot3D.SetAbortFlag(&m_abort_plotting);
	plot3D.SetAxisParameters(dlg.m_show_axis);
	plot3D.SetMonochromePen(dlg.m_line_color);
	plot3D.SetBackgroundColor(dlg.m_background_color);

	// draw the plot
	m_is_drawn = 0;
	m_abort_plotting = 0;
	CWaitCursor wait;	// put up hour glass
	if (plot3D.Plot()==0) m_is_drawn = 1;
}

void CWin3DZView::OnEditCopy() 
{
	CDC memdc;
	CDC* dc = GetDC();
	HBITMAP hBitmap;      
	BITMAP bm;
	BOOL bval;
	RECT wrect;
	int	nWidth, nHeight;
	int rc2; 

 	// create a bitmap from the window contents
	GetClientRect(&wrect);
	nWidth  = wrect.right  - wrect.left;
	nHeight = wrect.bottom - wrect.top;
  	bval = memdc.CreateCompatibleDC(NULL);
  	hBitmap = CreateCompatibleBitmap(dc->m_hDC, nWidth, nHeight);
	SelectObject(memdc.m_hDC,hBitmap);
	rc2 = memdc.SetStretchBltMode(STRETCH_DELETESCANS); 
	bval = memdc.StretchBlt(0,0,nWidth,nHeight,dc,0,0,nWidth,nHeight,SRCCOPY);
	rc2 = GetObject(hBitmap,sizeof(bm),&bm);
	
	// Open the clipboard
	if (OpenClipboard())
	{
		// Clean the contents of the clipboard
		bval = EmptyClipboard();

	 	// ----- put data to the clipboard data -----
	 	SetClipboardData(CF_BITMAP, hBitmap);

  		// Close the clipboard
	 	bval = CloseClipboard();
	}
	else
	{
		AfxMessageBox( "Clipboard unavailable" );
	}
}

void CWin3DZView::OnHelpGettingstarted() 
{
	CDlgGettingStarted dlg;
	dlg.DoModal();
}

void CWin3DZView::OnHelpIntroduction() 
{
	CDlgIntro dlg;
	dlg.DoModal();
}

void CWin3DZView::OnHelpTips() 
{
	CDlgTips dlg;
	dlg.DoModal();
}

void CWin3DZView::OnHelpHiddenlineremoval() 
{
	CDlgHiddenLine dlg;
	dlg.DoModal();
}

void CWin3DZView::OnHelpPlotparameters() 
{
	CDlgHelpParm dlg;
	dlg.DoModal();
}

void CWin3DZView::OnHelpCprogramming() 
{
	CDlgCppProgram dlg;
	dlg.DoModal();
}
