#include <qwidget.h>
#include <qmenubar.h>
#include <qevent.h>
#include <qscrbar.h>

#include "main.h"

class QuatMenu : public QWidget
{
   Q_OBJECT
public:
   QuatMenu(QWidget *parent=0, const char *name=0, QCmds *s_cmd = 0);
   void TitleImage();
   void ChangeState(bool ImgInMem, bool ZBufInMem, 
      bool ImgChanged, bool ZBufChanged, bool ImgReady, bool ZBufReady,
      bool InCalc); 
   void setAllDisabled();
   QMenuBar *menu;
   QScrollBar *VScroll, *HScroll;
public slots:
   void SetHScrollPos(int);
   void SetVScrollPos(int);
protected:
   void paintEvent(QPaintEvent *);
   void resizeEvent(QResizeEvent *);
private:
   QCmds *cmd;
   int ID_ImageOpen;
   int ID_ImageClose;
   int ID_ImageSave;
   int ID_ImageSaveAs;
   int ID_ImageAdjustWindow;
   int ID_ImageExit;
   int ID_CalculationStartImage;
   int ID_CalculationStartZBuf;
   int ID_CalculationStop;
   int ID_ParametersReset;
   int ID_ParametersReadINI;
   int ID_ParametersReadPNG;
   int ID_ParametersSaveAs;
   int ID_ParametersObjectEditor;
   int ID_ParametersViewEditor;
   int ID_ParametersColorEditor;
   int ID_ParametersIntersectionEditor;
   int ID_ParametersOther;
   int ID_ZBufferOpen;
   int ID_ZBufferClose;
   int ID_ZBufferSave;
   int ID_ZBufferSaveAs;
   QPopupMenu *Image;
   QPopupMenu *Calculation;
   QPopupMenu *Parameters;
   QPopupMenu *ZBuffer;
};

