/* titcomp - A title image compiler for Quat 0.92 */
/* Copyright (C) 1998 Dirk Meyer */
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */
/* mail:  Dirk Meyer */
/*        Marbacher Weg 29 */
/*        D-71334 Waiblingen */
/*        Germany */
/* */
/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */
/* */
/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */
/* */
/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "png.h"

int main(int argc, char *argv[])
{
	unsigned char *line, *oldline, *InBuf, *OutBuf;
	char fname[1024], *suffix;
	FILE *f;
	float fOutLen;
	long OutLen, i, j;
	struct png_info_struct info;
	struct png_internal_struct internal;
	uLongf destLen;
	uLong sourceLen;
	int opt;
	char force;
   
	printf("Title image compiler for Quat 0.92\n");
	printf("Copyright (C) 1998 Dirk Meyer\n");
	printf("Distributed under the terms of the GNU General Public License, version 2.\n");
	if (argc == 2 && argv[1][0] != '-') strcpy(fname, argv[1]);
	else if (argc == 3 && argv[1][0] == '-' && argv[2][0] != '-') opt = 1;
	else if (argc == 3 && argv[2][0] == '-' && argv[1][0] != '-') opt = 2;
	if (opt==1) strcpy(fname, argv[2]);
	if (opt==2) strcpy(fname, argv[1]); 
	if (fname[0] == 0) {
		printf("Error: No file given\nSyntax: titcomp [-f] <png-file>\n"
		"The image must be true color.\n");
		return 1;
	}
	if (argc==3 && (opt==0 || strcmp(argv[opt], "-f")) != 0) {
		printf("Syntax: titcomp [-f] <png-file>\n");
		return(1);
	}
	if (opt != 0) force = 1; else force = 0;
	if ((f = fopen(fname, "rb")) == NULL && !force) {
		printf("Error: Given file cannot be opened.\n");
		return 1;
	}
	if (f != NULL) {
		if (InitPNG(f, &info, &internal) == -1) {
			printf("Error: Given file is not a valid png file.\n");
			fclose(f);
			EndPNG(&internal);
			return 1;
		}
		fOutLen = (float)(info.width*info.height*3)*1.001+12;
		OutLen = (long)(fOutLen+1);
		InBuf = calloc(info.width*info.height*3, 1);
		line = calloc(info.width*3+10, 1);
		oldline = calloc(info.width*3+10, 1);
		OutBuf = calloc(OutLen, 1);
		if (!InBuf || !OutBuf || !line || !oldline) {
			printf("Error: Could not allocate memory. (approx. %i bytes)\n", 
				info.width*info.height*6);
			free(line); free(InBuf); free(OutBuf); free(oldline);
			return 1;
		}

		while (strncmp(internal.chunk_type, "IDAT", 4) != 0 
			&& strncmp(internal.chunk_type, "IEND", 4) != 0)
			GetNextChunk(&internal);
		if (strncmp(internal.chunk_type, "IDAT", 4) != 0) {
			printf("Error: Png file contains no IDAT chunk.\n");
			free(line); free(InBuf); free(OutBuf); free(oldline);
		}
/*		printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
			0,0,2,0,0,0,0,0,0,0,0,0,0x40,1,0xf0,0,24,32);*/
		for (i=0; i<info.height; i++) {
			ReadPNGLine(&internal, line);
			if (i==0) DoUnFiltering(&internal, line, NULL);
			else DoUnFiltering(&internal, line, oldline);
/*			for (j=0; j<info.width*3; j++)
			printf("%c", line[j+1]);*/
			memcpy(InBuf+i*info.width*3, line+1, info.width*3);
			memcpy(oldline, line, info.width*3+1);
		}
		EndPNG(&internal);
		fclose(f);

		sourceLen = (long)info.width*(long)info.height*3; destLen = OutLen;
		if (compress(OutBuf, &destLen, InBuf, sourceLen) != Z_OK) {
			printf("Error: There has been an error while compressing.\n");
			free(OutBuf); free(InBuf); free(line);
			return 1;
		}
	}	

	suffix = strchr(fname, '.'); if (suffix) *suffix = 0;
	strcat(fname, ".c");
	if ((f = fopen(fname, "r")) != NULL) {
		fclose(f);
		if (!force) {
			printf("Error: File %s already exists.\n", fname);
			free(OutBuf); free(InBuf); free(line);
			return 1;
		}
	}
	if ((f = fopen(fname, "w")) == NULL) {
		printf("Error: Could not create file %s.\n", fname);
		free(OutBuf); free(InBuf); free(line);
		return 1;
	}
	fprintf(f, "/* Automatically generated file by titcomp. */\n");
	fprintf(f, "/* It defines a char-array which contains the title image */\n");
	fprintf(f, "/* as a zlib-compressed stream. */\n");
	fprintf(f, "/* If you do not want a title image, simply rename title.png, */\n");
	fprintf(f, "/* so that it cannot be found, then recompile */\n");
	fprintf(f, "/* ------------------------------------------- */\n");
	fprintf(f, "/* Do not edit! Every change you make will be  */\n");
	fprintf(f, "/* overwritten!                                */\n");
	fprintf(f, "/* ------------------------------------------- */\n\n");
	fprintf(f, "long TitleImg_X = %i;\n", info.width);
	fprintf(f, "long TitleImg_Y = %i;\n", info.height);
	fprintf(f, "long TitleImg_Length = %i;\n", destLen);
	fprintf(f, "unsigned char TitleImg[%i] = {\n", destLen);
	for (i=0; i<destLen; i++) {
		if (i != destLen-1) fprintf(f, "%i,", OutBuf[i]);
		else fprintf(f, "%i", OutBuf[i]);
		if ((i+1) % 20 == 0) fprintf(f, "\n");
	}
	fprintf(f, "};\n");
	fclose(f);
	printf("%s written successfully.\n", fname);
	return 0;
}
