/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.AddressBookResources;
import addressbook.NewContactFrame;
import addressbook.OptionsFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import rogatkin.BaseController;
import rogatkin.Program;
import rogatkin.Serializer;

public class AddressBookFrame
extends JFrame
implements ActionListener,
Program {
    public static final String PROGRAMNAME = "R-AddressBook";
    public static final String VERSION = "version 1.0 beta";
    static final int MENU = 1;
    static final int TOOL = 2;
    static final int STATUS = 4;
    static final int SEARCH = 8;
    static final int FOLDER = 16;
    int view = 31;
    boolean standalone;
    BaseController controller;

    public AddressBookFrame(BaseController baseController) {
        super(PROGRAMNAME);
        this.controller = baseController;
        if (this.controller == null) {
            this.controller = new BaseController(this){
                Image mainicon;
                {
                    AddressBookFrame.this.standalone = true;
                }

                public Image getMainIcon() {
                    if (this.mainicon == null) {
                        this.mainicon = BaseController.getResourceIcon("photoorganizer.jpg").getImage();
                    }
                    return this.mainicon;
                }
            };
        }
        this.controller.load();
        ((Frame)this).setIconImage(this.controller.getMainIcon());
        Container container = this.getContentPane();
        if ((this.view & 1) != 0) {
            this.setJMenuBar(this.createMenu());
        }
        if ((this.view & 2) != 0) {
            container.add((Component)this.createToolBar(0), "North");
        }
        container.add((Component)this.createBook(), "Center");
        if ((this.view & 4) != 0) {
            container.add((Component)this.createStatusBar(), "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddressBookFrame.this.actionPerformed(new ActionEvent(this, 0, AddressBookFrame.this.standalone ? "Exit" : "Close"));
            }
        });
        this.pack();
        ((Component)this).setVisible(true);
    }

    public String getName() {
        return PROGRAMNAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.createNewMenu(jMenu, this);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Properties");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Delete");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Import");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Address Book...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Business Card(vCard)...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Other Address Book...");
        jMenu2.add(jMenuItem);
        jMenu2 = new JMenu("Export");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Address Book...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Business Card(vCard)...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Other Address Book...");
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.standalone ? "Exit" : "Close");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Copy");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control C"));
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Paste");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control V"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control A"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Profile...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Find People...");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        jMenuItem = new JCheckBoxMenuItem("Toolbar");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JCheckBoxMenuItem("Statusbar");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JCheckBoxMenuItem("Folders and Groups");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Sort By");
        jMenu.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("E-Mail Address"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Business Phone"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Home Phone"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenu2.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("First Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Last Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenu2.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Ascending"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Descending"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Refresh");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Accounts");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Options");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Action");
        jMenu.add(jMenu2);
        this.createActionMenu(jMenu2, this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Synchronize now");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Contents");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("About...R-AddressBook");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        return jMenuBar;
    }

    JComponent createNewMenu(JComponent jComponent, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("New contact...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control N"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New bookmark...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control B"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New cookie...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New group...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control G"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New folder...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        jMenuItem.addActionListener(actionListener);
        return jComponent;
    }

    JComponent createActionMenu(JComponent jComponent, ActionListener actionListener) {
        int n = 0;
        while (n < AddressBookResources.MENUS_ACTION.length) {
            JMenuItem jMenuItem = new JMenuItem(AddressBookResources.MENUS_ACTION[n]);
            jComponent.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            ++n;
        }
        return jComponent;
    }

    JToolBar createToolBar(int n) {
        JToolBar jToolBar = new JToolBar(n);
        JButton jButton = jToolBar.add(new ToolAction("New"));
        jButton = jToolBar.add(new ToolAction("Properties"));
        jButton = jToolBar.add(new ToolAction("Delete"));
        jButton = jToolBar.add(new ToolAction("Find"));
        jButton = jToolBar.add(new ToolAction("Print"));
        jButton = jToolBar.add(new ToolAction("Action"));
        return jToolBar;
    }

    JComponent createBook() {
        Object[][] objectArray = new String[][]{{"Ivanov, Peter Alex", "Ivanov.P.A@kgb.gov.ru", "095-8948920", "09763438334"}, {"Gregoriev, Ivan Peter", "Greg@russianword.com.ru", "64723898129", "47299283746"}};
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel("Type name or select from list"));
        jPanel2.add(new JTextField(20));
        jPanel.add((Component)jPanel2, "North");
        JTable jTable = new JTable(objectArray, AddressBookResources.HEADER_ADDRBOOK);
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        if ((this.view & 0x10) != 0) {
            JTree jTree = new JTree();
            return new JSplitPane(1, true, new JScrollPane(jTree), new JScrollPane(jPanel));
        }
        return jPanel;
    }

    public static JPanel createButtonPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("<html><i>Apply");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        return jPanel;
    }

    JPanel createStatusBar() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Status bar"));
        jPanel.setBorder(new BevelBorder(1));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("Find People...")) {
            if (string.equals("New contact...")) {
                new NewContactFrame();
            } else if (string.equals("Options")) {
                new OptionsFrame(this.controller);
            } else if (string.equals("Exit")) {
                this.dispose();
                System.exit(0);
            } else if (string.equals("Close")) {
                this.dispose();
            } else if (!string.equals("About...") && string.equals("Contents")) {
                this.controller.showUrl("../R-AddressBook.html");
            }
        }
    }

    public static void main(String[] stringArray) {
        new AddressBookFrame(null);
    }

    class JRadioButtonMenuItemEx
    extends JRadioButtonMenuItem {
        Action action;
        PropertyChangeListener actionPropertyChangeListener;

        JRadioButtonMenuItemEx(Action action) {
            this.setAction(action);
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            Action action2 = this.getAction();
            if (this.action == null || !this.action.equals(action)) {
                this.action = action;
                if (action2 != null) {
                    this.removeActionListener(action2);
                    action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                    this.actionPropertyChangeListener = null;
                }
                this.configurePropertiesFromAction(this.action);
                if (this.action != null) {
                    this.addActionListener(this.action);
                    this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                    this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
                }
                this.firePropertyChange("action", action2, this.action);
                this.revalidate();
                this.repaint();
            }
        }

        protected void configurePropertiesFromAction(Action action) {
            this.setEnabled(action.isEnabled());
            this.setText((String)action.getValue("Name"));
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            return new PropertyChangeListener(this){
                private final /* synthetic */ JRadioButtonMenuItemEx this$1;
                {
                    this.this$1 = jRadioButtonMenuItemEx;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            };
        }
    }

    class RadioAction
    extends AbstractAction {
        RadioAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressBookFrame.this.actionPerformed(actionEvent);
        }
    }

    class ToolAction
    extends AbstractAction {
        Icon im;

        ToolAction(String string) {
            super(string);
            this.im = BaseController.getResourceIcon(string + ".gif");
        }

        public Object getValue(String string) {
            if (string == "SmallIcon") {
                return this.im;
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("New".equals(this.getValue("Name"))) {
                Rectangle rectangle = ((Component)actionEvent.getSource()).getBounds();
                Point point = new Point(0, rectangle.height);
                SwingUtilities.convertPointToScreen(point, (Component)actionEvent.getSource());
                ((JPopupMenu)AddressBookFrame.this.createNewMenu(new JPopupMenu(), AddressBookFrame.this)).show(AddressBookFrame.this, point.x, point.y);
            } else if ("Action".equals(this.getValue("Name"))) {
                Rectangle rectangle = ((Component)actionEvent.getSource()).getBounds();
                Point point = new Point(0, rectangle.height);
                SwingUtilities.convertPointToScreen(point, (Component)actionEvent.getSource());
                ((JPopupMenu)AddressBookFrame.this.createActionMenu(new JPopupMenu(), AddressBookFrame.this)).show(AddressBookFrame.this, point.x, point.y);
            } else {
                AddressBookFrame.this.actionPerformed(actionEvent);
            }
        }
    }
}

