/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.directory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.UiUpdater;
import photoorganizer.directory.AbstractCellEditor;
import photoorganizer.directory.AbstractTreeTableModel;
import photoorganizer.directory.FileNode;
import photoorganizer.directory.FileSystemModel;
import photoorganizer.directory.TreeTableModel;
import photoorganizer.directory.TreeTableModelAdapter;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.FastMenu;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.ThumbnailsPanel;
import rogatkin.BaseController;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public class JTreeTable
extends JTable
implements ActionListener,
Persistentable {
    static final String SECNAME = "JTreeTable";
    static final String COLWIDTH = "ColumnWidthes";
    static final String DRIVE = "Drive";
    protected TreeTableCellRenderer tree;
    private PhotoImagePanel imagepanel;
    private ThumbnailsPanel thumbnailspanel;
    private PhotoCollectionPanel collectionpanel;
    private AlbumPane albumpanel;
    private Controller controller;
    static /* synthetic */ Class class$photoorganizer$directory$TreeTableModel;

    public JTreeTable(TreeTableModel treeTableModel, Controller controller) {
        this.controller = controller;
        this.imagepanel = (PhotoImagePanel)controller.component(Controller.COMP_IMAGEPANEL);
        this.thumbnailspanel = (ThumbnailsPanel)controller.component(Controller.COMP_THUMBPANEL);
        this.collectionpanel = (PhotoCollectionPanel)controller.component(Controller.COMP_COLLECTION);
        this.albumpanel = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (JTreeTable.this.isRowSelected(listSelectionEvent.getLastIndex()) || JTreeTable.this.isRowSelected(listSelectionEvent.getFirstIndex())) {
                    File[] fileArray = JTreeTable.this.getSelectedFiles();
                    if (fileArray != null) {
                        JTreeTable.this.setCursor(BaseController.WAIT_CURSOR);
                        JTreeTable.this.controller.getUiUpdater().notify(JTreeTable.this.thumbnailspanel.updateImages(fileArray), UiUpdater.FILE_SELECTED);
                        JTreeTable.this.controller.updateCaption(fileArray[0] + (fileArray.length > 1 ? "..." : ""));
                        JTreeTable.this.controller.getUiUpdater().notify(true, UiUpdater.DIRECTORY_SELECTED);
                        JTreeTable.this.setCursor(BaseController.DEFAULT_CURSOR);
                    }
                } else {
                    JTreeTable.this.controller.getUiUpdater().notify(false, UiUpdater.FILE_SELECTED);
                    JTreeTable.this.controller.getUiUpdater().notify(false, UiUpdater.DIRECTORY_SELECTED);
                }
            }
        });
        this.setDefaultRenderer(class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel, this.tree);
        this.setDefaultEditor(class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    Point point = ((JViewport)JTreeTable.this.getParent()).getViewPosition();
                    FastMenu fastMenu = new FastMenu(JTreeTable.this, JTreeTable.this.controller);
                    fastMenu.add(new JPopupMenu.Separator());
                    JMenuItem jMenuItem = new JMenuItem("Change drive");
                    fastMenu.add(jMenuItem);
                    jMenuItem.addActionListener(JTreeTable.this);
                    fastMenu.show(JTreeTable.this.getParent(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                } else if (mouseEvent.getClickCount() == 2) {
                    JTreeTable.this.actionPerformed(new ActionEvent(this, 0, "Show"));
                }
            }
        });
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
    }

    String[] getSelectedPathNames() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[treePathArray.length];
        int n = 0;
        while (n < treePathArray.length) {
            Object[] objectArray = treePathArray[n].getPath();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append(objectArray[n2]);
                if (n2 > 0 && n2 < objectArray.length - 1) {
                    stringBuffer.append(File.separator);
                }
                ++n2;
            }
            stringArray[n] = stringBuffer.toString();
            ++n;
        }
        return stringArray;
    }

    File[] getSelectedFiles() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        File[] fileArray = new File[treePathArray.length];
        int n = 0;
        while (n < treePathArray.length) {
            Object[] objectArray = treePathArray[n].getPath();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append(objectArray[n2]);
                if (n2 > 0 && n2 < objectArray.length - 1) {
                    stringBuffer.append(File.separator);
                }
                ++n2;
            }
            fileArray[n] = new File(stringBuffer.toString());
            ++n;
        }
        return fileArray;
    }

    public void fireDriveChanged() {
        FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
        Object[] objectArray = fileSystemModel.getRoots();
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                vector.addElement(objectArray[n]);
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        Object object = JOptionPane.showInputDialog(this, "Choose drive", "Change current drive", 1, null, objectArray, objectArray[0]);
        if (object == null) {
            return;
        }
        fileSystemModel.setRoot(new FileNode((File)object));
        fileSystemModel.fireTreeStructureChanged(this, new Object[]{object}, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Change drive") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("Change drive")) {
            this.fireDriveChanged();
            return;
        }
        File[] fileArray = this.getSelectedFiles();
        if (fileArray == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath().getParentPath();
        BasicJpeg basicJpeg = new BasicJpeg(fileArray[0]);
        if (string.equals("Properties...")) {
            if (basicJpeg.isValid()) {
                PropertiesPanel.showProperties(basicJpeg, this.controller);
            }
            return;
        }
        if (string.equals("To selection") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("To selection")) {
            this.collectionpanel.add(fileArray);
            return;
        }
        if (string.equals("To album")) {
            AlbumPane albumPane = (AlbumPane)this.controller.component(Controller.COMP_ALBUMPANEL);
            AlbumSelectionDialog albumSelectionDialog = albumPane.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + fileArray[0] + (fileArray.length == 1 ? "" : "..."));
            ((Component)albumSelectionDialog).setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                BasicJpeg[] basicJpegArray = null;
                if (fileArray.length == 1 && fileArray[0].isDirectory()) {
                    String[] stringArray = fileArray[0].list();
                    String string2 = fileArray[0].getPath();
                    basicJpegArray = new BasicJpeg[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        basicJpegArray[n] = new BasicJpeg(new File(string2, stringArray[n]));
                        ++n;
                    }
                } else {
                    basicJpegArray = new BasicJpeg[fileArray.length];
                    int n = 0;
                    while (n < fileArray.length) {
                        basicJpegArray[n] = new BasicJpeg(fileArray[n]);
                        ++n;
                    }
                }
                this.albumpanel.addToAlbum(basicJpegArray, treePathArray);
            }
        } else if (string.equals("Rename")) {
            int n = 0;
            while (n < fileArray.length) {
                Object object = fileArray[n].getName();
                basicJpeg = new BasicJpeg(fileArray[n]);
                Serializer serializer = this.controller.getSerializer();
                if (basicJpeg.isValid() && Serializer.getInt(serializer.getProperty("RenameOptions", "AskEdit"), 0) == 0) {
                    basicJpeg.renameTo(new File(fileArray[n].getParent(), FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(basicJpeg, this.controller))));
                } else {
                    if (basicJpeg.isValid()) {
                        object = fileArray[n].getParent() + File.separatorChar + FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(basicJpeg, this.controller));
                    }
                    if ((object = JOptionPane.showInputDialog(this, "New name", "Rename", 3, null, null, object)) != null) {
                        basicJpeg.renameTo(new File(object.toString()));
                    }
                }
                ++n;
            }
        } else if (string.equals("Delete")) {
            int n = 0;
            while (n < fileArray.length) {
                if (0 == JOptionPane.showConfirmDialog(this, fileArray[n].getName() + "- will be removed permanently.\nAre you sure?", "Delete", 0, 2)) {
                    fileArray[n].delete();
                }
                ++n;
            }
        } else {
            if (string.equals("Print")) {
                this.controller.print(fileArray);
                return;
            }
            if (string.equals("Show")) {
                this.imagepanel.updateView(new BasicJpeg(fileArray[0]));
                this.controller.updateCaption(fileArray[0].toString());
                return;
            }
        }
        ((AbstractTreeTableModel)this.tree.getModel()).fireTreeStructureChanged(this, treePath.getPath(), null, null);
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel) ? -1 : this.editingRow;
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Integer[] integerArray = new Integer[this.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = new Integer(this.getColumn(this.getColumnName(n)).getWidth());
            ++n;
        }
        serializer.setProperty(SECNAME, COLWIDTH, integerArray);
        FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
        FileNode fileNode = (FileNode)fileSystemModel.getRoot();
        serializer.setProperty(SECNAME, DRIVE, fileNode);
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray = (Object[])serializer.getProperty(SECNAME, COLWIDTH);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.getColumn(this.getColumnName(n)).setWidth((Integer)objectArray[n]);
            this.getColumn(this.getColumnName(n)).setPreferredWidth((Integer)objectArray[n]);
            ++n;
        }
        String string = (String)serializer.getProperty(SECNAME, DRIVE);
        if (string != null) {
            FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
            File file = new File(string);
            if (!file.exists()) {
                file = fileSystemModel.findFirstDrive();
            }
            fileSystemModel.setRoot(new FileNode(file));
            fileSystemModel.fireTreeStructureChanged(this, new Object[]{file}, null, null);
            this.revalidate();
            this.repaint();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            int n = this.getColumnCount() - 1;
            while (n >= 0) {
                if (this.getColumnClass(n) == (class$photoorganizer$directory$TreeTableModel == null ? JTreeTable.class$("photoorganizer.directory.TreeTableModel") : class$photoorganizer$directory$TreeTableModel)) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
                --n;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }
}

