/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import addressbook.AddressBookFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import photoorganizer.Controller;
import photoorganizer.HtmlProducer;
import photoorganizer.courier.MailCourier;
import rogatkin.GranulatedLayout;
import rogatkin.Serializer;

public class SendEmailFrame
extends JFrame
implements ActionListener {
    static final int MAX_SUBJECT_LENGTH = 100;
    Controller controller;
    File[] files_to_send;
    JTextField tf_to;
    JTextArea ta;

    public SendEmailFrame(Controller controller, File[] fileArray) {
        super("Send E-mail");
        this.controller = controller;
        ((Frame)this).setIconImage(controller.getMainIcon());
        this.files_to_send = fileArray;
        this.getContentPane().add((Component)new SendEmail(), "Center");
        this.getContentPane().add((Component)new AcionButtons(), "South");
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Address Book")) {
            new AddressBookFrame(this.controller);
            return;
        }
        if (string.equals("OK")) {
            new Thread(new Runnable(){

                public void run() {
                    SendEmailFrame.this.send();
                }
            }, "E-Mail sender").start();
        }
        this.dispose();
    }

    void send() {
        Properties properties = System.getProperties();
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty("WebPublishOptions", "SMTPServer");
        if (string != null && string.length() > 0) {
            ((Hashtable)properties).put("mail.smtp.host", string);
        }
        try {
            Session session = Session.getDefaultInstance((Properties)properties, null);
            session.setDebug(true);
            MimeMessage mimeMessage = new MimeMessage(session);
            string = (String)serializer.getProperty("WebPublishOptions", "E-MailAddress");
            String string2 = Serializer.arrayToString(serializer.getProperty("WebPublishOptions", "SMTPUser"));
            if (string != null) {
                mimeMessage.setFrom((Address)(string2 != null ? new InternetAddress(string, string2) : new InternetAddress(string)));
            } else {
                mimeMessage.setFrom();
            }
            string = this.tf_to.getText();
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string, (boolean)false));
            MimeMultipart mimeMultipart = new MimeMultipart("related");
            MimeMultipart mimeMultipart2 = new MimeMultipart("alternative");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Multipart)mimeMultipart2);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            string = this.ta.getText();
            if (string.length() > 0) {
                String string3 = new StringTokenizer(string, "\n\r").nextToken();
                if (string3.length() > 100) {
                    string3 = string3.substring(0, 99);
                }
                mimeMessage.setSubject(string3);
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setContent((Object)string, "text/plain");
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            } else {
                mimeMessage.setSubject("Information you've rquested");
            }
            new HtmlProducer(this.controller).produce(new MailCourier(this.controller, (Multipart)mimeMultipart, (Multipart)mimeMultipart2), this.files_to_send);
            mimeMessage.setHeader("X-Mailer", "R-PhotoOrganizer");
            mimeMessage.setHeader("Comments", Serializer.arrayToString(serializer.getProperty("WebPublishOptions", "Organization")));
            mimeMessage.setSentDate(new Date());
            mimeMessage.setContent((Multipart)mimeMultipart);
            Transport.send((Message)mimeMessage);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "E-Mail sending failed, check e-mail settings\n" + iOException, "Error", 0);
            iOException.printStackTrace();
        }
        catch (MessagingException messagingException) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "E-Mail sending failed, check e-mail settings\n" + (Object)((Object)messagingException), "Error", 0);
            messagingException.printStackTrace();
        }
    }

    class AcionButtons
    extends JPanel {
        AcionButtons() {
            this.setLayout(new FlowLayout(2));
            JButton jButton = new JButton("OK");
            this.add(jButton);
            jButton.addActionListener(SendEmailFrame.this);
            jButton = new JButton("Cancel");
            this.add(jButton);
            jButton.addActionListener(SendEmailFrame.this);
        }
    }

    class SendEmail
    extends JPanel {
        SendEmail() {
            this.setLayout(new GranulatedLayout(5, 6, 20, 4, 8, 8));
            this.setBorder(new BevelBorder(0));
            this.add((Component)new JLabel("Send by e-mail"), "0,0,2");
            SendEmailFrame.this.tf_to = new JTextField();
            this.add((Component)SendEmailFrame.this.tf_to, "0,1,3");
            JButton jButton = new JButton("Address Book");
            this.add((Component)jButton, "3,1,2");
            jButton.addActionListener(SendEmailFrame.this);
            SendEmailFrame.this.ta = new JTextArea(3, 1);
            this.add((Component)SendEmailFrame.this.ta, "0,2,5,3");
            SendEmailFrame.this.ta.setBorder(new BevelBorder(1));
        }
    }
}

