/* PhotoOrganizer 
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.formats;
import java.text.*;
import photoorganizer.Resources;
import java.io.File;
import java.util.Date;

/**
  Format escape seq
  %D - date/time stamp in current locale,
  %d - date stamp,
  %t - time stamp,
  %s - shutter speed,
  %a - aperture value,
  %f - flash (yes, no),
  %q - quality,
  %c - counter, can be specified as %0..0c, if leading zeros have to be present,
  %o - original file name,
  %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr
  %S - file size (undocumented)
  %z - focal length (zoom)
  %M - make
  %m - model
*/
public class FileNameFormat extends Format {
    public static int counter;
    public static String timemask;
    public static String datemask;
    public static Object []transformCodes;

    public FileNameFormat(String mask) {
	this(mask, false);
    }

    public FileNameFormat(String mask, boolean inccount) {
	this.mask = mask;
	this.inccount = inccount;
    }

    public FileNameFormat(String mask, int rotation) {
	this(mask);
	this.rotation = rotation;
    }

    public FileNameFormat(String mask, int rotation, boolean inccount) {
	this(mask, inccount);
	this.rotation = rotation;
    }
    
    final int TEXT = 0;
    final int ESC  = 1;
    final char PERCENT = '%';
    
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
	AbstractImageInfo image = null;
	long imagefilelen=0;
	try {
	    image = ((BasicJpeg)obj).getImageInfo();
	    imagefilelen = new File(((BasicJpeg)obj).getLocationName()).length();
	} catch(ClassCastException e) {
	}
        char c;
	int state = TEXT;
	String lead_zeros = "";
	StringBuffer result = new StringBuffer();
// StringCharacterIterator	
        for(int i = 0; i < mask.length(); i++) {
            c = mask.charAt(i);
            switch(state) {
	    case TEXT:
		if (c != PERCENT)
		    result.append(c);
		else
		    state = ESC;
		break;
	    case ESC:
		state = TEXT;
		switch(c) {
		case 'D':
		    DateFormat dt;
                    if ((datemask == null || datemask.length() == 0) ||
                        (timemask == null || timemask.length() == 0))
                        dt = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT);
                    else
                        dt = new SimpleDateFormat(datemask+timemask);
		    if (image == null) 
			result.append(dt.format(new Date()));
		    else
			result.append(dt.format(image.getDateTimeOriginal()));
		    break;
		case 'd':
		    DateFormat d;
                    if (datemask == null || datemask.length() == 0)
                        d = DateFormat.getDateInstance(DateFormat.SHORT);
                    else
                        d = new SimpleDateFormat(datemask);
		    if (image == null) 
			result.append(d.format(new Date()));
		    else
			result.append(d.format(image.getDateTimeOriginal()));
		    break;
		case 't':
		    DateFormat t;
                    if (timemask == null || timemask.length() == 0)
                        t = DateFormat.getTimeInstance(DateFormat.SHORT);
                    else
                        t = new SimpleDateFormat(timemask);
		    if (image == null) 
			result.append(t.format(new Date()));
		    else
			result.append(t.format(image.getDateTimeOriginal()));
		    break;
		case 's':
                    try {
		        result.append(image.getShutter().toString());
                    } catch(NullPointerException e) {
                    }
		    break;
		case 'a':
		    if (image != null) 
			result.append(image.getFNumber());
		    break;
		case 'f':
		    if (image != null) 
			result.append(image.isFlash()?Resources.CMD_YES:Resources.CMD_NO);
		    break;
		case 'q':
		    if (image != null) 
			result.append(image.getQuality());
		    break;
		case 'c':
		    if (lead_zeros.length() > 0)
			lead_zeros+='0';
		    result.append(new DecimalFormat(lead_zeros).format(counter));
		    lead_zeros = "";
		    break;
		case 'o':
		    if (image != null) 
			result.append(image.getName());
		    else
			new File(((BasicJpeg)obj).getLocationName()).getName();
		    break;
		case 'r':
		    result.append((String)transformCodes[rotation]);
		    break;
		case 'S':
		    result.append(imagefilelen);
		    break;
		case 'z':
		    if (image != null) 
			result.append(image.getFocalLength());
		    break;
		case 'm':
		    if (image != null) 
			result.append(image.getModel());
		    break;
		case 'M':
		    if (image != null) 
			result.append(image.getMake());
		    break;
		case '0':
		    lead_zeros+='0';
		    state = ESC;
		    break;
		case PERCENT:
		    result.append(c);
		    break;
		default:
		    result.append(PERCENT); result.append(c);
		}
	    }
	}
        if (inccount)
	    counter++;
	return result;
    }

    public Object parseObject (String source, ParsePosition pos) {
	return null;
    }

    public static String makeValidPathName(String name) {
        return makeValidPathName(name, null);
    }

    public static String makeValidPathName(String name, String ext) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        name = name.replace(':', '_');
        name = name.replace(File.pathSeparatorChar, '-');
        name = name.replace('*', '_');
        name = name.replace('?', '_');
        name = name.replace(' ', '_');
        if (name.indexOf('.') < 0 && ext != null)
            name += '.'+ext;
        return name;
    }

    private String mask;
    private int rotation;
    private boolean inccount;
}