/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui;

import com.l2fprod.gui.plaf.skin.CompoundSkin;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinPreviewWindow;
import com.l2fprod.util.OS;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SkinChooser
extends JPanel {
    static final String REFRESH_CMD = "refresh";
    static final String PREVIEW_CMD = "preview";
    static final String GETSKINS_CMD = "getskins";
    private JList skinList;
    private String[] directories;
    private JCheckBox backgroundCheckBox;
    private JCheckBox scrollBarCheckBox;
    private ResourceBundle bundle;
    private boolean themePackMode = false;

    public void setSkinLocations(String[] directories) {
        this.directories = directories;
        Vector skins = new Vector();
        int i = 0;
        int c = directories.length;
        while (i < c) {
            this.buildSkinList(skins, new File(directories[i]));
            ++i;
        }
        this.skinList.setListData(skins);
    }

    public void setThemePackMode(boolean b) {
        this.themePackMode = b;
    }

    public String[] getSkinLocations() {
        return this.directories;
    }

    public boolean getThemePackMode() {
        return this.themePackMode;
    }

    public String[] getSelectedSkins() {
        return (String[])this.skinList.getSelectedValues();
    }

    public void refreshList() {
        if (this.directories != null && this.directories.length > 0) {
            this.setSkinLocations(this.directories);
        }
    }

    public void apply() throws Exception {
        Object[] values = this.skinList.getSelectedValues();
        if (values == null || this.themePackMode && values.length != 1 || !this.themePackMode && values.length != 2) {
            return;
        }
        UIManager.put("JDesktopPane.backgroundEnabled", this.backgroundCheckBox.isSelected() ? Boolean.TRUE : null);
        UIManager.put("ScrollBar.alternateLayout", this.scrollBarCheckBox.isSelected() ? Boolean.TRUE : null);
        Skin skin = null;
        skin = this.themePackMode ? SkinLookAndFeel.loadThemePack((String)values[0]) : new CompoundSkin(SkinLookAndFeel.loadSkin((String)values[0]), SkinLookAndFeel.loadSkin((String)values[1]));
        SkinLookAndFeel.setSkin(skin);
        UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
    }

    protected void buildSkinList(Vector v, File directory) {
        if (!directory.isDirectory() || !directory.exists()) {
            return;
        }
        String[] files = directory.list();
        int i = 0;
        int c = files.length;
        while (i < c) {
            File f = new File(directory, files[i]);
            if (f.isDirectory()) {
                this.buildSkinList(v, f);
            } else if (this.accept(f)) {
                try {
                    v.addElement(f.getCanonicalPath());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    protected boolean accept(File f) {
        return !f.isDirectory() && (this.themePackMode && f.getName().endsWith(".zip") || f.getName().endsWith("gtkrc") || f.getName().endsWith("themerc"));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void showPreviewWindow() {
        block12: {
            block11: {
                oldSkin = SkinLookAndFeel.getSkin();
                oldLAF = UIManager.getLookAndFeel();
                try {
                    try {
                        block14: {
                            block13: {
                                values = this.skinList.getSelectedValues();
                                if (values == null) break block13;
                                if (values.length == 2) break block14;
                            }
                            var4_5 = null;
                            break block11;
                        }
                        skin = new CompoundSkin(SkinLookAndFeel.loadSkin((String)values[0]), SkinLookAndFeel.loadSkin((String)values[1]));
                        SkinLookAndFeel.setSkin(skin);
                        UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
                        window = new SkinPreviewWindow();
                        window.setVisible(true);
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        var4_7 = null;
                        SkinLookAndFeel.setSkin(oldSkin);
                        try {
                            UIManager.setLookAndFeel(oldLAF);
                            return;
                        }
                        catch (UnsupportedLookAndFeelException e) {
                            return;
                        }
                    }
                }
                catch (Throwable var3_15) {
                    var4_8 = null;
                    SkinLookAndFeel.setSkin(oldSkin);
                    ** try [egrp 2[TRYBLOCK] [2 : 118->125)] { 
lbl34:
                    // 1 sources

                    UIManager.setLookAndFeel(oldLAF);
                    throw var3_15;
lbl36:
                    // 1 sources

                    catch (UnsupportedLookAndFeelException e) {
                        // empty catch block
                    }
                    throw var3_15;
                }
            }
            SkinLookAndFeel.setSkin(oldSkin);
            ** try [egrp 2[TRYBLOCK] [2 : 118->125)] { 
lbl42:
            // 1 sources

            UIManager.setLookAndFeel(oldLAF);
            return;
lbl44:
            // 1 sources

            catch (UnsupportedLookAndFeelException e) {
                // empty catch block
            }
            return;
        }
        var4_6 = null;
        SkinLookAndFeel.setSkin(oldSkin);
        try {}
        catch (UnsupportedLookAndFeelException e) {}
        UIManager.setLookAndFeel(oldLAF);
        return;
    }

    private final void loadResourceBundle() {
        this.bundle = ResourceBundle.getBundle("com.l2fprod.gui.plaf.skin.resources.skin");
    }

    public SkinChooser() {
        this.loadResourceBundle();
        this.setLayout(new BorderLayout(3, 3));
        JPanel listPane = new JPanel(new BorderLayout(3, 3));
        JPanel buttonPane = new JPanel(new GridLayout(1, 3, 3, 3));
        JButton button = new JButton(this.bundle.getString("SkinChooser.getskins"));
        buttonPane.add(button);
        button.addActionListener(new GetSkinsAction());
        button.setToolTipText(this.bundle.getString("SkinChooser.getskins.tip"));
        button = new JButton(this.bundle.getString("SkinChooser.preview"));
        buttonPane.add(button);
        button.addActionListener(new PreviewAction());
        button = new JButton(this.bundle.getString("SkinChooser.refresh"));
        buttonPane.add(button);
        button.addActionListener(new RefreshAction());
        this.skinList = new JList();
        listPane.add("Center", new JScrollPane(this.skinList));
        listPane.add("South", buttonPane);
        this.add("Center", listPane);
        Box optionPane = Box.createVerticalBox();
        this.backgroundCheckBox = new JCheckBox(this.bundle.getString("SkinChooser.enableBackground"));
        optionPane.add(this.backgroundCheckBox);
        this.scrollBarCheckBox = new JCheckBox(this.bundle.getString("SkinChooser.enableScrollBar"));
        optionPane.add(this.scrollBarCheckBox);
        this.add("East", optionPane);
    }

    private class RefreshAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            SkinChooser.this.refreshList();
        }

        public RefreshAction() {
            super(SkinChooser.REFRESH_CMD);
        }
    }

    private class GetSkinsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            try {
                OS.openDocument(SkinChooser.this.bundle.getString("SkinChooser.getskins.url"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public GetSkinsAction() {
            super(SkinChooser.GETSKINS_CMD);
        }
    }

    private class PreviewAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            SkinChooser.this.showPreviewWindow();
        }

        public PreviewAction() {
            super(SkinChooser.PREVIEW_CMD);
        }
    }
}

