#include "defn.h"
#include "delays.c"
#include "line3d.c"


/*********************************/
float getval(void)
{
	 char    valbuf[15];
	 long     value;
	 int     DECIMAL = 0;
	 int     i;

	 /* Null the value buffer "valbuf" */
	 for (i = 0; i < 10; i++)
	valbuf[i] = '\0';

	 i = 0;

	 ch = getc(stream);

	 while ((ch == ' ') || (ch == ','))
	 {
		 //debugp((stderr,"%c",ch));
	ch = getc(stream);
	 }

	 while ((ch >= '0' && ch <= '9') || ch == '.' || ch == '-' || ch == '+')
	 {
	//debugp((stderr,"%c",ch));
	if (ch == '.')
	{
		 if (DECIMAL){
		//fprintf(stderr,"Error: %s\n", ERROR);
		exit(1);
		 }
		 DECIMAL = 1;
	}
	valbuf[i++] = ch;
	ch = getc(stream);
	 }
	 /* remove trailing space or comma to set-up for
		 next digit or mnemonic */
	 /* added by Gordon Jacobs so that definition of
		 SIGNED_NUMERIC in defn.h could be made more accurate.
		 Solves problem of commands like PA,PD0,0... where
		 optional comma is present.  (Tektronix scope outputs!) */
	 while ((ch == ' ') || (ch == ','))
	 {
		 //	debugp((stderr,"%c",ch));
	ch = getc(stream);
	 }

	 ungetc(ch, stream);         /* Put non numeric char back */
	 value = atof (valbuf);
	 return (value);
}

/****************************************************/
void plot(void)
{
	red=MAllocColor(0xff,0x00,0x00);
	blue=MAllocColor(0x00,0x00,0xff);
	gray=MAllocColor(0xb0,0xb0,0xb0);
	purple=MAllocColor(0xff,0x00,0xff);
	yellow=MAllocColor(0xff,0xff,0x00);
	orange=MAllocColor(0xff,0x88,0x00);

	while (SIGNED_NUMERIC)
	{
	if(rotate){
	  newreadY=(getval()*0.025/*plotter unit*/*plotscale)/tableresY;   // plotscale/100 because plotscale can be set as percentage 100% = 1 original size
	  newreadX=(getval()*0.025/*plotter Unit*/*plotscale)/tableresX;   // is original size off the drawing
	}
	if(!rotate){
	  newreadX=(getval()*0.025/*plotter unit*/*plotscale)/tableresX;   // plotscale/100 because plotscale can be set as percentage 100% = 1 original size
	  newreadY=(getval()*0.025/*plotter unit*/*plotscale)/tableresY;   // is original size off the drawing
	}

	  if(PLOTABS==1){        	// PA absolute moves;
			newX=newreadX+offsetx;
			newY=newreadY+offsety;

			relX=newX-oldX;
			relY=newY-oldY;

	  }
	  else if(PLOTABS==0){     	// PR relative moves;
			newX=oldX+newreadX;
			newY=oldY+newreadY;

			relX=newreadX;
			relY=newreadY;
	  }

	  if(bigX<newX)bigX=newX;      //remember the smallest and biggest val in drawing
	  if(bigY<newY)bigY=newY;      //just for statistics
	  if(smallX>newX)smallX=newX;  //
	  if(smallY>newY)smallY=newY;  //
	  if(smallZ>newZ)smallZ=newZ;  //
	  if(smallZ>newZ)smallZ=newZ;  //


	 if(!PENDOWN){   		//if not pendown
		stepdelay=startdelay=penupstartdelay;
		enddelay=penupenddelay;
	 }

	 if(PENDOWN){
		stepdelay=startdelay=pendownstartdelay;
		enddelay=pendownenddelay;
	 }

	 if(!step_output){  		//if no output draw a line with mgui
		if(PENDOWN)MDrawLine(drawarea,(oldX*tableresX)*screenscale,maxy-(oldY*tableresY)*screenscale,(newX*tableresX)*screenscale,maxy-(newY*tableresY)*screenscale,red); //draw a line
		if(penuplines){
			if(!PENDOWN)MDrawLine(drawarea,(oldX*tableresX)*screenscale,maxy-(oldY*tableresY)*screenscale,(newX*tableresX)*screenscale,maxy-(newY*tableresY)*screenscale,gray); //draw a line
		}
	 }
	 if(step_output){  		//if output draw a line with line3d.c
	     if (PENDOWN & actualpenstate==0){ //only perform it when pen state is different / new
		do_zaxis();
	     }
	     else if (!PENDOWN & actualpenstate==1){ //only perform it when pen state is different / new
		do_zaxis();
	     }

		line3d(oldX,oldY,newX,newY,0,0); //bresenham 3d line draw it 2 screen and plotter
	 }

	 oldX=newX;
	 oldY=newY;
	}
}




do_zaxis()
{
   if(output_type==0){    		//0=SMC800/1500 control card www.conrad.de

//microstepping with SMC800/SNC1500 Conrad card
const unsigned char motor_array[16] = {0x27,0x2E,0x2D,0x35,0x1C,0x15,0x0D,0x0E,0x03,0x0A,0x09,0x11,0x38,0x31,0x29,0x2A};
//normalstepping with SMC800/SMC1500 Conrad card
//const unsigned char motor_array[8] = {0x27,0x2D,0x1C,0x0D,0x03,0x09,0x38,0x29};
//normal sequence like in conrad smcmot.c example

	if(!PENDOWN){
	      zdelay=zaxis_startdelay;
	      while(zz<penupval/tableresZ){

		MpointerZ=MpointerZ+1;   	//mpointerx +1 or 0 or -1 depending of direction
		if (MpointerZ > 15)MpointerZ = 0;      	//the array = 16 so mpointer must be 0 to 15

		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform

		zdelay=zdelay-3;
		if(zdelay<zaxis_enddelay)zdelay=zaxis_enddelay;

		Wait_Time(zdelay);

		zz=zz+1;

		actualpenstate=0;
	      }
		gcvt(zz*tableresZ,3,temp);
		MObjectSetText(bigzinput,temp);
	}



	if(PENDOWN){
	      zdelay=zaxis_startdelay;

	      while(zz>pendown1val/tableresZ){

		MpointerZ=MpointerZ-1;   	//mpointerx +1 or 0 or -1 depending of direction
		if (MpointerZ < 0)MpointerZ = 15;

		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform

		zdelay=zdelay-3;
		if(zdelay<zaxis_enddelay)zdelay=zaxis_enddelay;

		Wait_Time(zdelay);

		zz=zz-1;

		actualpenstate=1;

	   }

		gcvt(zz*tableresZ,3,temp);
		MObjectSetText(bigzinput,temp);

	    while(zz>pendown2val/tableresZ){

		MpointerZ=MpointerZ-1;   	//mpointerx +1 or 0 or -1 depending of direction
		if (MpointerZ < 0)MpointerZ = 15;

		outp(_LPT,motor_array[MpointerZ]+128);
		Wait_Time(55/*119*/);   	// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
						// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
		outp(_LPT+2, 1);  		// strobe data ubername/perform
		outp(_LPT+2, 0);  		// strobe data ubername/perform

		Wait_Time(zaxis_drilldelay);

		zz=zz-1;

		actualpenstate=1;
	   }
		gcvt(zz*tableresZ,3,temp);
		MObjectSetText(bigzinput,temp);
	}
    }
}







