/*---------------------------------------------------------------------------
;
;    MODULE NAME:   W32SETUP.REX
;
;        $Author:   Dennis  $
;      $Revision:   1.0  $
;          $Date:   01 Jan 2001 18:35:40  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/MultiOs/PPWIZARD/w32setup.rex.pvcs  $
;
;    DESCRIPTION:   Gets renamed to SETUP.REX and is called after unpacking
;                   of the Windows self extracting EXE to start install.
;
;                   If the zip is downloaded the user must execute this
;                   command:
;
;                          regina.exe setup.rex
;----------------------------------------------------------------------------*/


/*--- If the directory is not valid then stop -------------------------------*/
trace off;
if stream("SETUP.REX", 'c', 'query exists') = '' then
do
   say 'The current directory is "' || directory() || '" which does not';
   say 'appear to be correct. You will need to change to the directory'
   say 'where you installed ppwizard and type "W32SETUP"!'
   say '';
   address system '%COMSPEC% /K ver';
   exit(255);
end;

/*--- Which operating system are we on --------------------------------------*/
parse value uname() with OpSys .
say 'Installing onto the "' || OpSys || '" operating system.'
say 'Installing into the "' || directory() || '" directory.'
say ''

/*--- Take appropriate action -----------------------------------------------*/
if OpSys = 'WINNT' then
do
   /*--- Simply let REGIT do all the work -----------------------------------*/
   say 'Processing "PPW_NT.RIT"'
   address system 'regina.exe RegIt.REX PPW_NT.RIT'
end;
else
do
   /*--- We can do some work via REGIT --------------------------------------*/
   say 'Processing "PPW_95.RIT"'
   address system 'regina.exe RegIt.REX ppw_95.RIT' /* Win95 can't load "W32UTIL.DLL" */

   /*--- The rest involves updating autoexec.bat ----------------------------*/
   call DebugPause 'Updating "AUTOEXEC.BAT" if required'
   call  UpdateWin98AutoexecBat;
end;

/*--- Generate the test html ------------------------------------------------*/
call DebugPause 'Testing PPWIZARD by generating "TRYME.HTM"'
address system 'regina.exe ppwizard.rex TRYME.IT'
call DebugPause 'Displaying the generated "TRYME.HTM"'
address system 'start tryme.htm'
call DebugPause 'Done';
exit(0);


/*===========================================================================*/
DebugPause:
/*===========================================================================*/
   say '@' || SIGL || ': ' || arg(1);
   /*address system 'pause';*/
   return;


/*===========================================================================*/
UpdateWin98AutoexecBat:
/*===========================================================================*/
   /*
   * Note Microsoft Windows 95/98 have a MAJOR bug in the command processor
   * which prevents you from determining whether a command works or not!
   */

   /*--- Initialization -----------------------------------------------------*/
   ConfigFile = "c:\autoexec.bat";
   BackupFile = "c:\autoexec.ppw";
   TmpNewFile = "c:\ea_bat.new";
   LogFile    = "c:\ppwizard.log";
   CloseRc = stream(LogFile, 'c', 'close');
   if stream(LogFile, 'c', 'query exists') <> '' then
       address system 'del ' || LogFile;
   call LogIt ""
   call LogIt "Starting at: " || date() || ', ' || time();
   call SayIt "Installing PPWIZARD onto Windows 95 or 98 machine";

   /*--- Make sure we have a backup of the original "autoexec.bat" ----------*/
   if stream(ConfigFile, 'c', 'query exists') <> '' then
   do
       /*--- There is a config file to backup, have a backup already? -------*/
       if stream(BackupFile, 'c', 'query exists') = '' then
       do
           /*--- No backup, so make one -------------------------------------*/
           call SayIt 'Creating backup of "' || ConfigFile || '" called "' || BackupFile || '"'
           address system 'copy ' || ConfigFile || ' '  || BackupFile;

           /*--- Double Check OK --------------------------------------------*/
           if  stream(ConfigFile, 'c', 'query size') <> stream(BackupFile, 'c', 'query size') then
               Die("Failed making the backup copy");
       end;
   end;

   /*--- Work out where we are ----------------------------------------------*/
   parse source . . SourceFileName;
   SlashPos = lastpos('\', SourceFileName);
   if SlashPos = 0 then
       Die("Bug in regina? Could not determine current path.");
   ThisDir    = translate(left(SourceFileName, SlashPos-1));
   NeedInPath = '"' || ThisDir || '"';

   /*--- Simple if not config file currently exists -------------------------*/
   StartReginaLine = "SET REGINA_MACROS=";
   ReginaNeeds = StartReginaLine || ThisDir;
   if stream(ConfigFile, 'c', 'query exists') = '' then
   do
       /*--- No config file exists so just create one -----------------------*/
       call SayIt 'Creating a new "' || ConfigFile || '" files as none currently exists'
       call lineout ConfigFile, "PATH=" || NeedInPath;
       call lineout ConfigFile, ReginaNeeds;
       CloseRc = stream(ConfigFile, 'c', 'close');
   end;
   else
   do
       /*--- File exists so need to update it -------------------------------*/
       call SayIt 'Scanning existing "' || ConfigFile || '" file'
       CloseRc = stream(TmpNewFile, 'c', 'close');
       if  stream(TmpNewFile, 'c', 'query exists') <> '' then
           address system 'del ' || TmpNewFile;

       /*--- Read configuration line by line --------------------------------*/
       FoundReginaLine = 'N';
       FoundPathLine   = 'N';
       MadeChanges     = 'N';
       LineNumber      = 0;
       CloseRc = stream(ConfigFile, 'c', 'close');
       do  while lines(ConfigFile) <> 0
           /*--- Read the current line --------------------------------------*/
           CurrentLine  = linein(ConfigFile);
           CurrentLineU = translate(CurrentLine);
           LineNumber   = LineNumber + 1;
           call LogIt  '   * Line #' || LineNumber || ': ' || CurrentLine;

           /*--- Process the file -------------------------------------------*/
           select
               /**************************************************/
               when pos(StartReginaLine, CurrentLineU) <> 0 then
               /**************************************************/
               do
                   /*--- Found existing regina line -------------------------*/
                   FoundReginaLine = 'Y';
                   if  CurrentLine <> ReginaNeeds then
                   do
                       CurrentLine = ReginaNeeds;
                       MadeChanges = 'Y';
                       call LogIt  '     ===> #' || LineNumber || ': ' || CurrentLine;
                   end;
               end;
               /**************************************************/
               when pos("PATH=", CurrentLineU) <> 0 | pos("PATH ", CurrentLineU) <> 0 then
               /**************************************************/
               do
                   FoundPathLine = 'Y';
                   if  pos(NeedInPath, CurrentLineU) = 0 then
                   do
                       /*--- Dir not yet in path ----------------------------*/
                       do  while right(CurrentLine, 1) = ';'
                           CurrentLine = left(CurrentLine, length(CurrentLine)-1);
                       end;
                       CurrentLine = CurrentLine || ';' || NeedInPath;
                       MadeChanges = 'Y';
                       call LogIt  '     ===> #' || LineNumber || ': ' || CurrentLine;
                   end;
               end;
               /**************************************************/
               otherwise
               /**************************************************/
               do
                   /*--- Ignore other lines ---------------------------------*/
               end;
           end;

           /*--- Output to the temporary file -------------------------------*/
           call lineout TmpNewFile, CurrentLine;
       end;
       CloseRc = stream(ConfigFile, 'c', 'close');

       /*--- Add any required lines -----------------------------------------*/
       if  FoundPathLine = 'N' then
           call AddNewLine "PATH=" || NeedInPath;
       if  FoundReginaLine = 'N' then
           call AddNewLine ReginaNeeds;
       CloseRc = stream(TmpNewFile, 'c', 'close');

       /*--- If any changes were required then update autoexec.bat ----------*/
       if  MadeChanges = 'N' then
           call SayIt '"' || ConfigFile || '" did not need to be changed'
       else
       do
           call SayIt '"' || ConfigFile || '" is being updated'
           address system 'copy ' || TmpNewFile || ' '  || ConfigFile;

           /*--- Double Check OK --------------------------------------------*/
           if  stream(ConfigFile, 'c', 'query size') <> stream(TmpNewFile, 'c', 'query size') then
               Die("Did not successfully update configuration file!");
       end;
   end;
   return(0);


/*===========================================================================*/
AddNewLine:
/*===========================================================================*/
   MadeChanges = 'Y';
   LineNumber  = LineNumber + 1;
   NewLine = "PATH=" || NeedInPath;
   call LogIt  '     ===> #' || LineNumber || ': ' || arg(1);
   call lineout TmpNewFile, arg(1);
   return;



/*===========================================================================*/
SayIt:
/*===========================================================================*/
   say        arg(1);
   call LogIt arg(1);
   return;


/*===========================================================================*/
LogIt:
/*===========================================================================*/
   call lineout LogFile, arg(1);
   CloseRc = stream(LogFile, 'c', 'close');
   return;

/*===========================================================================*/
Die:
/*===========================================================================*/
   ExitRc = SIGL;
   call Sayit ''
   call Sayit 'ERROR'
   call Sayit '~~~~~'
   call Sayit arg(1);
   exit(ExitRc);
