/*
 * Decompiled with CFR 0.152.
 */
package hsplitter.model;

import hsplitter.tools.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class JavaHelpMeta {
    private static final boolean DEBUG = true;
    public static final int STS_OK = 0;
    public static final int STS_ERR = -2;
    public static final int STS_WARN = -1;
    private static final String productNameVar = "@NAME@";
    private static final String fileNameVar = "@FILEPATH@";
    private static final String titleNameVar = "@TITLE@";
    private static final String targetNameVar = "@TARGET@";
    String[] titles = null;
    String[] filepaths = null;
    int[] levels = null;
    String mainName = null;
    String baseMapFileName = "BasicMap.jhm";
    String baseTocFileName = "BasicTOC.xml";
    String baseHSFileName = "Basic.hs";
    String baseIndexFileName = "BasicIndex.xml";
    String[] targets = null;
    String[] indents = new String[]{"", "   ", "      "};
    File adir = null;
    int qty = 0;
    String basepath = "";
    String properExt = null;

    public JavaHelpMeta(String mainName, int[] levels, String[] titles, String[] filepaths) {
        this.mainName = mainName;
        this.levels = levels;
        this.titles = titles;
        this.filepaths = filepaths;
        this.qty = levels.length;
        this.targets = new String[this.qty];
    }

    public int init(File adir, String pagesExt) {
        this.properExt = pagesExt;
        Logger.getLogger(null, false).logASpaceLine();
        Logger.getLogger(null, false).logInfo("Doing JavaHelp metadata");
        this.adir = adir;
        if (this.qty <= 0) {
            return -2;
        }
        for (int ii = 0; ii < this.qty; ++ii) {
            int ndx;
            String aname = this.filepaths[ii].toLowerCase();
            int pos = aname.lastIndexOf(47);
            if (pos < 0) {
                pos = 0;
            }
            if ((ndx = aname.lastIndexOf(46)) > pos) {
                aname = aname.substring(pos, ndx);
            }
            this.targets[ii] = aname;
        }
        int sts = this.writeFromTemplate(String.valueOf(String.valueOf(this.basepath)).concat(String.valueOf(String.valueOf(this.baseHSFileName))), String.valueOf(String.valueOf(this.mainName)).concat(".hs"));
        return sts;
    }

    public int doMapFile() {
        int sts = this.writeFromTemplate(String.valueOf(String.valueOf(this.basepath)).concat(String.valueOf(String.valueOf(this.baseMapFileName))), "Map.jhm");
        return sts;
    }

    public int doToc() {
        int sts = this.writeFromTemplate(String.valueOf(String.valueOf(this.basepath)).concat(String.valueOf(String.valueOf(this.baseTocFileName))), String.valueOf(String.valueOf(this.mainName)).concat("TOC.xml"));
        return sts;
    }

    public int doIndex() {
        int sts = this.writeFromTemplate(String.valueOf(String.valueOf(this.basepath)).concat(String.valueOf(String.valueOf(this.baseIndexFileName))), String.valueOf(String.valueOf(this.mainName)).concat("Index.xml"));
        return sts;
    }

    public int doIndex(String[] text, String[][] targets) {
        int sts = this.writeFromTemplate(String.valueOf(String.valueOf(this.basepath)).concat(String.valueOf(String.valueOf(this.baseIndexFileName))), String.valueOf(String.valueOf(this.mainName)).concat("Index.xml"));
        return sts;
    }

    public String getErrMsg() {
        return null;
    }

    /*
     * Loose catch block
     */
    private int writeFromTemplate(String templateFileName, String targetFileName) {
        block34: {
            String sep = System.getProperty("line.separator");
            InputStreamReader fr = null;
            BufferedReader br = null;
            OutputStreamWriter fw = null;
            File targetFile = new File(this.adir, targetFileName);
            targetFile.createNewFile();
            fw = new FileWriter(targetFile);
            File templateFile = new File(templateFileName);
            fr = new FileReader(templateFile);
            br = new BufferedReader(fr);
            while (br.ready()) {
                String txtline = br.readLine();
                int posProdName = txtline.indexOf(productNameVar);
                int posFileName = txtline.indexOf(fileNameVar);
                int posTitleName = txtline.indexOf(titleNameVar);
                int posTargetName = txtline.indexOf(targetNameVar);
                if (posProdName < 0 && posFileName < 0 && posTitleName < 0 && posTargetName < 0) {
                    fw.write(String.valueOf(String.valueOf(txtline)).concat(String.valueOf(String.valueOf(sep))));
                    continue;
                }
                if (posProdName > 0) {
                    String newtxtline = String.valueOf(String.valueOf(txtline.substring(0, posProdName))).concat(String.valueOf(String.valueOf(this.mainName)));
                    newtxtline = String.valueOf(String.valueOf(newtxtline)).concat(String.valueOf(String.valueOf(txtline.substring(posProdName + productNameVar.length()))));
                    fw.write(String.valueOf(String.valueOf(newtxtline)).concat(String.valueOf(String.valueOf(sep))));
                    continue;
                }
                if (posFileName <= 0 && posTitleName <= 0 && posTargetName <= 0) continue;
                String seg1 = "";
                String seg2 = "";
                String seg3 = "";
                String segend = "";
                for (int ii = 0; ii < this.qty; ++ii) {
                    if (posTargetName > 0) {
                        if (posFileName > posTargetName) {
                            seg1 = String.valueOf(String.valueOf(txtline.substring(0, posTargetName))).concat(String.valueOf(String.valueOf(this.targets[ii])));
                            seg2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(txtline.substring(posTargetName + targetNameVar.length(), posFileName)))).append(this.filepaths[ii]).append(this.properExt)));
                            seg3 = txtline.substring(posFileName + fileNameVar.length());
                            String newtxtline = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1))).append(seg2).append(seg3)));
                            fw.write(String.valueOf(String.valueOf(newtxtline)).concat(String.valueOf(String.valueOf(sep))));
                            continue;
                        }
                        if (posTitleName > 0 && posTitleName < posTargetName) {
                            String newtxtline;
                            seg1 = String.valueOf(String.valueOf(txtline.substring(0, posTitleName))).concat(String.valueOf(String.valueOf(this.titles[ii])));
                            seg2 = String.valueOf(String.valueOf(txtline.substring(posTitleName + titleNameVar.length(), posTargetName))).concat(String.valueOf(String.valueOf(this.targets[ii])));
                            seg3 = txtline.substring(posTargetName + targetNameVar.length());
                            int pos = txtline.indexOf(60);
                            int pos2 = txtline.indexOf(32, pos);
                            segend = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1.substring(0, pos + 1)))).append("/").append(seg1.substring(pos + 1, pos2)).append(">")));
                            if (ii < this.qty - 1 && ii > 0 && this.levels[ii + 1] > this.levels[ii] && this.levels[ii - 1] > this.levels[ii]) {
                                if (this.levels[ii - 1] == 2 && this.levels[ii] == 0) {
                                    fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[1]]))).append(segend).append(sep))));
                                }
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(segend).append(sep))));
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(seg1).append("\">").append(sep))));
                                seg1 = String.valueOf(String.valueOf(txtline.substring(0, posTitleName))).concat("Intro");
                                newtxtline = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1))).append(seg2).append(seg3)));
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii + 1]]))).append(newtxtline).append(sep))));
                                continue;
                            }
                            if (ii < this.qty - 1 && this.levels[ii + 1] > this.levels[ii]) {
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(seg1).append("\">").append(sep))));
                                seg1 = String.valueOf(String.valueOf(txtline.substring(0, posTitleName))).concat("Intro");
                                newtxtline = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1))).append(seg2).append(seg3)));
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii + 1]]))).append(newtxtline).append(sep))));
                                continue;
                            }
                            if (ii > 0 && this.levels[ii - 1] > this.levels[ii]) {
                                if (this.levels[ii - 1] == 2 && this.levels[ii] == 0) {
                                    fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[1]]))).append(segend).append(sep))));
                                }
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(segend).append(sep))));
                                newtxtline = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1))).append(seg2).append(seg3)));
                                fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(newtxtline).append(sep))));
                                continue;
                            }
                            newtxtline = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seg1))).append(seg2).append(seg3)));
                            fw.write(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.indents[this.levels[ii]]))).append(newtxtline).append(sep))));
                            continue;
                        }
                        System.out.println("ERR: Bad Map.jhm or xxxTOC.xml template");
                        Logger.getLogger(null, false).logErr("Bad Map.jhm or xxxTOC.xml template");
                        continue;
                    }
                    System.out.println("ERR: No @TARGET@");
                    Logger.getLogger(null, false).logErr("No @TARGET@");
                }
            }
            Object var23_26 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
                break block34;
            }
            catch (IOException iOException) {}
            break block34;
            {
                catch (Exception ee) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("Err: Read error with ").append(templateFileName).append(" ,Err= ").append(ee))));
                    Logger.getLogger(null, false).logErr(String.valueOf(String.valueOf(new StringBuffer("Read error with ").append(templateFileName).append(" ,Err= ").append(ee))));
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    int n = -2;
                    Object var23_27 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var23_28 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
    }

    static {
        DEBUG = true;
        STS_OK = 0;
        STS_ERR = -2;
        STS_WARN = -1;
        productNameVar = productNameVar;
        fileNameVar = fileNameVar;
        titleNameVar = titleNameVar;
        targetNameVar = targetNameVar;
    }
}

