/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jms.graphics.RectBorderedPanel;

public class ProgressBar
extends RectBorderedPanel {
    private static int RECT_VSPACE = 4;
    private static int RECT_HSPACE = 4;
    private static int RECT_WIDTH = 5;
    private static int MAX = 100;
    private static int MIN;
    private int currentValue;
    private int numberOfBars;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public ProgressBar(int current) {
        this.currentValue = current;
        this.setValue(current);
    }

    public void reInit(int current) {
        this.currentValue = current;
        this.setValue(current);
    }

    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension d = this.getSize();
        g.setColor(Color.lightGray);
        g.fillRect(1, 1, d.width - 3, d.height - 3);
        int x = 0;
        g.setColor(new Color(0, 0, 102));
        int i = 0;
        while (i < this.numberOfBars) {
            x = RECT_HSPACE + i * (RECT_HSPACE + RECT_WIDTH);
            g.fillRect(x, RECT_VSPACE, RECT_WIDTH, d.height - (2 * RECT_VSPACE + 1));
            ++i;
        }
    }

    public int getValue() {
        return this.currentValue;
    }

    public void setValue(int current_value) {
        if (current_value > MAX) {
            this.reInit(MAX);
        } else {
            this.currentValue = current_value;
        }
        Dimension d = this.getSize();
        if (d.width <= 0) {
            this.numberOfBars = 0;
            return;
        }
        int max_bars = d.width / (RECT_HSPACE + RECT_WIDTH);
        this.numberOfBars = max_bars != 0 ? this.currentValue / ((MAX - MIN) / max_bars) : 0;
        this.paint(this.getGraphics());
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 27);
    }
}

