package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;


public class S01_Set
{
	public static void main(String[] args){

		// We delete the sample file here, so we know which objects we can expect.
		new java.io.File("samples.yap").delete();


		ObjectContainer db = Db4o.openFile("samples.yap");
		// opens or creates the database file "samples.yap"


		Individual alice = new Individual();
		alice.firstName = "Alice";
		alice.name = "Wonderland";
		// Creation of an object


		db.set(alice);
		// one simple call stores an object into the db4o database


		// We need company for Alice, otherwise she gets bored.
		Individual peter = new Individual();
		peter.firstName = "Peter";
		peter.name = "Pan";
		db.set(peter);


		Logger.log("*** S01 'Alice Wonderland' and 'Peter Pan' were stored to samples.yap.");

		db.close();
		// Make sure to call close(), since some data is only flushed
		// back to the database file with this call.

	}
}
