package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S10_Equality
{
	public static void main(String[] args)
	{
		try{
			ObjectContainer db = Db4o.openFile("samples.yap");

			Logger.log("*** S10 Retrieving Individual 'Alice' and her Address.");

			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";

			Individual alice = (Individual)db.get(templateAlice).next();
			Logger.log(db, alice);
			// Object alice contains alice and her Address


			// We now retrieve the Address again:
			Address templateAddress = new Address();
			templateAddress.city = "Oz";
			Address alicesAddress = (Address)db.get(templateAddress).next();


			Logger.log("Testing identity of the two instances of Address:");
			Logger.log(alice.addresses[0] == alicesAddress);
			// The log output shows, that alice.addresses[0] and alicesAddress
			// are the same object.

			// db4o keeps one reference to every persistent object,
			// to make this possible


			db.close();

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
