package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S11_Update_Per_Object
{
	public static void main(String[] args)
	{
		try{
			Logger.log("*** S11 Update Per Object");
			Individual templateAlice = new Individual();
			templateAlice.firstName = "Alice";
			templateAlice.addresses = new Address[0];
			ObjectContainer db = Db4o.openFile("samples.yap");
			Individual alice = (Individual)db.get(templateAlice).next();
		
		
			alice.addresses[0].street = "Rabbit Way 1";
			db.set(alice);
			// This call did NOT update the Address in the database.
			// Every Persistent object has to be updated with 
			// an explicit call to set() individually
		
			// Only new members are added automatically upon a call to set().

		
			db.close();
			Logger.log("Alice Adress unchanged:");
			S07_Query_By_Example.main(null);  // We can use sample 7 to log Alice.
		
		
		
			// Now the right way:
			db = Db4o.openFile("samples.yap");
			alice = (Individual)db.get(templateAlice).next();
			alice.addresses[0].street = "Rabbit Way 1";
		
		
			db.set(alice.addresses[0]);
			// set() is called for the object that really was updated.
		
		
			db.close();
			Logger.log("After the call to set() with alice.addresses[0]:");
			S07_Query_By_Example.main(null);  // Again sample 7 to log Alice.
		}catch(Exception e){
			AllSamples.inARow();
		}

	}
}
