package com.db4o.sql;

import com.db4o.lib.*;

class SqlInsert extends SqlStatement
{
	private Collection i_values;
	
	public SqlInsert(){
		i_values = new Collection();
	}
	
	void addField(String a_field, String a_value){
		super.addField(a_field);
		i_values.add(a_value);
	}
	
	void addField(String a_field, long a_value){
		super.addField(a_field);
		i_values.add(new Long(a_value).toString());
	}
	
	protected String createStatement(){
		if (i_fields.size() > 0){
			Iterator i = i_fields.iterator();
			String fields = (String)i.next();
			Iterator j = i_values.iterator();
			String values = (String)j.next();
			while(i.hasNext()){
				fields = fields + ", " + (String)i.next();
				values = values + ", " + (String)j.next();
			}
			return "insert into " + i_table + " (" + fields + ") values (" + values + ")";
		}
		return null;
	}
	
}
