package com.db4o.test;

import com.db4o.*;

/**
 * note the special configuration for this class
 * in Regression.openContainer()
 */
public class DeepUpdate implements RTestable
{
	public ObjectSimplePublic d1;
	public DeepHelper d2;


	public DeepUpdate(){
		d1 = new ObjectSimplePublic();
		d2 = new DeepHelper();
	}

	public String compare(ObjectContainer con, Object obj, int ver, String errors){
		return Compare.compare(con, set(newInstance(), ver), obj,"",errors, null);
	}

	public boolean equals(Object obj){
		if(obj == null){
			return false;
		}
		if(! (obj instanceof DeepUpdate) ){
			return false;
		}
		DeepUpdate with = (DeepUpdate) obj;
		if(with.d1 != null && d1 != null){
			if(! d1.equals(with.d1)){
				return false;
			}
		}

		if(with.d2 != null && d2 != null){
			if(! d2.d1.equals(with.d2.d1)){
				return false;
			}
		}

		return true;
	}

	public Object newInstance(){
		return new DeepUpdate();
	}


	public Object set(Object obj, int ver){
		((DeepUpdate)obj).set(ver);
		return obj;
	}

	public void set(int ver){
		if(ver == 1){
			d1.name = "OneONEOneONEOneONEOneONEOneONEOneONE";
		}else{
			d1.name = "TwoTWOTwoTWOTwoTWOTwoTWOTwoTWO";
		}
		d2.set(ver);
	}

	public boolean jdk2(){
		return false;
	}

}
