/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.util.Vector;

class Gubshlistener
extends Thread {
    private DataInputStream instream;
    private Vector clients;
    private GubshellGUI gui;

    void gainClient(String clientName, InetAddress host, int portNbr) {
        if (clientName == null || host == null || portNbr < 1 || portNbr > 65535) {
            return;
        }
        Testclient client = new Testclient(clientName, host, portNbr);
        this.clients.add(client);
        this.gui.clientMenu.add(clientName);
        this.gui.clientMenu.invalidate();
        this.gui.validate();
    }

    void loseClient(String clientName, InetAddress host, int portNbr) {
        int length = this.clients.size();
        int i = 0;
        while (i < length) {
            Testclient client = (Testclient)this.clients.get(i);
            if (client.portNbr == portNbr && client.clientName.equals(clientName) && client.host.equals(host)) {
                this.clients.removeElementAt(i);
                this.gui.clientMenu.remove(i);
                return;
            }
            ++i;
        }
    }

    public void run() {
        while (true) {
            try {
                boolean newClient = this.instream.readBoolean();
                int stringLength = this.instream.readInt();
                if (stringLength == 0) break;
                byte[] stringBuffer = new byte[stringLength];
                this.instream.readFully(stringBuffer);
                String clientName = new String(stringBuffer);
                stringLength = this.instream.readInt();
                if (stringLength == 0) break;
                stringBuffer = new byte[stringLength];
                this.instream.readFully(stringBuffer);
                String addressName = new String(stringBuffer);
                InetAddress clientHost = InetAddress.getByName(addressName);
                int clientPortNbr = this.instream.readInt();
                if (newClient) {
                    this.gainClient(clientName, clientHost, clientPortNbr);
                    continue;
                }
                this.loseClient(clientName, clientHost, clientPortNbr);
            }
            catch (IOException x1) {
                if (x1 instanceof EOFException || x1 instanceof SocketException || x1 instanceof ProtocolException) {
                    System.out.println("Gubd stopped; quitting.");
                    System.exit(0);
                }
                System.out.println("IOException in 'listener' thread of Gubshell: " + x1.getMessage());
                x1.printStackTrace();
                System.exit(-1);
            }
        }
    }

    Gubshlistener(DataInputStream instream, Vector clients, GubshellGUI gui) {
        super("gubsh_listener");
        this.instream = instream;
        this.clients = clients;
        this.gui = gui;
    }
}

