/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import jdbees.ActionButton;
import jdbees.JBeesAboutDlg;
import jdbees.JBeesAddOption;
import jdbees.JBeesAudio;
import jdbees.JBeesCheckUpdate;
import jdbees.JBeesClock;
import jdbees.JBeesClockEvent;
import jdbees.JBeesClockListener;
import jdbees.JBeesConfInfo;
import jdbees.JBeesDownloadedFileInfo;
import jdbees.JBeesHelpDlg;
import jdbees.JBeesInit;
import jdbees.JBeesJTable;
import jdbees.JBeesPreferencesDlg;
import jdbees.JBeesQueueInfo;
import jdbees.JBeesResumeFileInfo;
import jdbees.JBeesRunningInfo;
import jdbees.JBeesScheduleDlg;
import jdbees.JBeesScheduleInfo;
import jdbees.JBeesTeam;
import jdbees.JBeesTeamStatus;
import jdbees.JBeesTeamStatusEvent;
import jdbees.JBeesTeamStatusListener;
import jdbees.JBeesTimerTask;
import jdbees.JBeesTree;
import jdbees.JBeesUIAction;
import jdbees.JBeesUtils;
import jdbees.ftp.JBeesFtpTeam;
import jdbees.ftpbatch.model.JBeesFTPBatchModel;
import jdbees.ftpbatch.model.JBeesFTPFileChosed;
import jdbees.ftpbatch.view.JBeesFTPBatchDlg;
import jdbees.http.JBeesHttpTeam;

public class JBeesMainFrame
extends JFrame
implements TreeSelectionListener,
JBeesTeamStatusListener,
JBeesClockListener {
    private boolean debug = false;
    private Thread ckuThread = null;
    private final int INRUN = 0;
    private final int INQUEUE = 1;
    private final int INRESUME = 2;
    private final int INDOWNLOADED = 3;
    private final int INSCHEDULE = 4;
    private int whatLeaf = 0;
    private boolean inExiting = false;
    private Action exitAction;
    private Action scheduleAction;
    private Action ftpBatchAction;
    private Action httpBatchAction;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private Action selectAllAction;
    private Action deSelectAllAction;
    private Action startAction;
    private Action stopAction;
    private Action startallAction;
    private Action checkUpdateAction;
    private Action preferencesAction;
    private Action aboutAction;
    private Action helpAction;
    private Action againAction;
    private ActionButton startButton;
    private ActionButton deleteButton;
    private ActionButton stopButton;
    private ActionButton windowButton;
    private ActionButton motifButton;
    private ActionButton metalButton;
    private ActionButton scheduleButton;
    private ActionButton addButton;
    private ActionButton ftpBatchButton;
    JPanel workPanel;
    JTable runningTable;
    JTable queueTable;
    JTable resumeTable;
    JTable downloadedTable;
    JTable scheduleTable;
    private Vector runningVector = new Vector();
    private Vector queueVector;
    private Vector resumeVector;
    private Vector downloadedVector;
    private Vector scheduleVector;
    private JBeesConfInfo jbconf;
    private HashSet hsset;
    static final String runStr = "Running";
    static final String inqStr = "In Queue";
    static final String resStr = "Resume Queue";
    static final String dldStr = "Downloaded Files";
    static final String scheduleStr = "Schedule Queue";
    static final int maxRow = 10;
    private Icon menuIcon;
    private Icon addIcon;
    private Icon aboutIcon;
    private Icon delIcon;
    private Icon downloadIcon;
    private Icon startIcon;
    private Icon stopIcon;
    private Icon resumeIcon;
    private Icon runningIcon;
    private Icon unixIcon;
    private Icon windowIcon;
    private Icon metalIcon;
    private Icon editIcon;
    private Icon exitIcon;
    private Icon startallIcon;
    private Icon queueIcon;
    private Icon preferencesIcon;
    private Icon helpIcon;
    private Icon againIcon;
    private Icon scheduleIcon;
    private Icon musicIcon;
    private Icon scheduleTableIcon;
    private Icon ftpbatchIcon;
    private Icon selectallIcon;
    private Icon deselectallIcon;
    private Icon updateIcon;
    private JPopupMenu jpopmenu;
    private JBeesClock jbclock;
    JBeesAudio jba;
    Timer scheduleTimer;
    Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();

    public JBeesMainFrame() {
        this.setTitle("JAVA Dancing Bees");
        this.loadImage();
        this.hsset = new HashSet();
        this.addWindowListener(new 1());
        Image ig = JBeesUtils.getImage("bee1r.gif", this);
        ((Frame)this).setIconImage(ig);
        this.jba = new JBeesAudio();
        this.initComponents();
        this.initJBees();
        this.jbclock = new JBeesClock();
        this.jbclock.addJBeesClockListener(this);
        this.scheduleTimer = new Timer();
        this.initScheduleTask();
    }

    private void initScheduleTask() {
        if (this.scheduleVector.size() == 0) {
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance();
        int i = 0;
        while (i < this.scheduleVector.size()) {
            JBeesScheduleInfo jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(i);
            Date date = null;
            try {
                date = df.parse(jbsi.getDate());
            }
            catch (ParseException parseException) {}
            JBeesTimerTask jtt = new JBeesTimerTask(jbsi.getURL(), this);
            jbsi.setTimerTask(jtt);
            this.scheduleTimer.schedule((TimerTask)jtt, date);
            ++i;
        }
    }

    private void initJBees() {
        JBeesInit jbinit = new JBeesInit();
        this.jbconf = jbinit.getConfInfo();
        this.queueVector = jbinit.getQueueInfo();
        this.resumeVector = jbinit.getResumeInfo();
        this.downloadedVector = jbinit.getDownloadedInfo();
        this.scheduleVector = jbinit.getScheduleInfo();
        if (this.queueVector != null) {
            this.fillQueueTable();
        } else {
            this.queueVector = new Vector();
        }
        if (this.resumeVector != null) {
            this.fillResumeTable();
        } else {
            this.resumeVector = new Vector();
        }
        if (this.downloadedVector != null) {
            this.fillDownloadedTable();
        } else {
            this.downloadedVector = new Vector();
        }
        if (this.scheduleVector != null) {
            this.fillScheduleTable();
        } else {
            this.scheduleVector = new Vector();
        }
    }

    synchronized void doScheduleWork(String url) {
        int index = this.findURLinSchedule(url);
        if (index == -1) {
            return;
        }
        this.scheduleTable.setRowSelectionInterval(index, index);
        JBeesUtils.deleteTableRow(this.scheduleTable, 10);
        JBeesScheduleInfo jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(index);
        this.scheduleVector.removeElementAt(index);
        JBeesQueueInfo jbqi = new JBeesQueueInfo();
        jbqi.setURL(jbsi.getURL());
        jbqi.setLocalFileName(jbsi.getLocalFileName());
        jbqi.setUser(jbsi.getUser());
        jbqi.setPasswd(jbsi.getPasswd());
        this.queueVector.addElement(jbqi);
        Object[] o = new Object[3];
        o[0] = this.queueIcon;
        o[2] = jbqi.getURL();
        o[1] = jbqi.getLocalFileName();
        JBeesUtils.fillTableRow(this.queueTable, o, 10);
    }

    private int findURLinSchedule(String url) {
        int i = 0;
        while (i < this.scheduleVector.size()) {
            JBeesScheduleInfo jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(i);
            if (url.equalsIgnoreCase(jbsi.getURL())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void fillScheduleTable() {
        int i = 0;
        while (i < this.scheduleVector.size()) {
            Object[] col = new Object[4];
            col[0] = this.scheduleTableIcon;
            JBeesScheduleInfo jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(i);
            col[1] = jbsi.getLocalFileName();
            col[2] = jbsi.getDate();
            col[3] = jbsi.getURL();
            this.hsset.add(jbsi.getURL().toLowerCase());
            JBeesUtils.fillTableRow(this.scheduleTable, col, 10);
            ++i;
        }
    }

    private void fillQueueTable() {
        int i = 0;
        while (i < this.queueVector.size()) {
            Object[] col = new Object[3];
            col[0] = this.queueIcon;
            JBeesQueueInfo jbqi = (JBeesQueueInfo)this.queueVector.elementAt(i);
            JBeesResumeFileInfo jbrf = jbqi.getResumeInfo();
            if (jbrf != null) {
                col[1] = jbrf.getLocalFileName();
                col[2] = jbrf.getOrgURL();
                this.hsset.add(jbrf.getOrgURL().toLowerCase());
            } else {
                col[1] = jbqi.getLocalFileName();
                col[2] = jbqi.getURL();
                this.hsset.add(jbqi.getURL().toLowerCase());
            }
            JBeesUtils.fillTableRow(this.queueTable, col, 10);
            ++i;
        }
    }

    private void fillResumeTable() {
        int i = 0;
        while (i < this.resumeVector.size()) {
            Object[] col = new Object[5];
            col[0] = this.resumeIcon;
            JBeesResumeFileInfo jbrf = (JBeesResumeFileInfo)this.resumeVector.elementAt(i);
            col[1] = jbrf.getLocalFileName();
            col[2] = new Long(jbrf.getRemoteFileLength());
            col[3] = "" + (int)(jbrf.getPercentage() * 100.0) + "%";
            col[4] = jbrf.getOrgURL();
            this.hsset.add(jbrf.getOrgURL().toLowerCase());
            JBeesUtils.fillTableRow(this.resumeTable, col, 10);
            ++i;
        }
    }

    private void fillDownloadedTable() {
        int i = 0;
        while (i < this.downloadedVector.size()) {
            Object[] col = new Object[4];
            col[0] = this.downloadIcon;
            JBeesDownloadedFileInfo jbdf = (JBeesDownloadedFileInfo)this.downloadedVector.elementAt(i);
            col[1] = jbdf.getLocalFileName();
            col[2] = new Long(jbdf.getFileLength());
            col[3] = jbdf.getURL();
            this.hsset.add(jbdf.getURL().toLowerCase());
            JBeesUtils.fillTableRow(this.downloadedTable, col, 10);
            ++i;
        }
    }

    private void loadImage() {
        this.menuIcon = new ImageIcon(JBeesUtils.getImage("bee1r.gif", this));
        this.queueIcon = new ImageIcon(JBeesUtils.getImage("queue.gif", this));
        this.preferencesIcon = new ImageIcon(JBeesUtils.getImage("preferences.gif", this));
        this.startallIcon = new ImageIcon(JBeesUtils.getImage("startall.gif", this));
        this.editIcon = new ImageIcon(JBeesUtils.getImage("edit.gif", this));
        this.exitIcon = new ImageIcon(JBeesUtils.getImage("exit.gif", this));
        this.metalIcon = new ImageIcon(JBeesUtils.getImage("metal.gif", this));
        this.aboutIcon = new ImageIcon(JBeesUtils.getImage("about.gif", this));
        this.startIcon = new ImageIcon(JBeesUtils.getImage("start.gif", this));
        this.helpIcon = new ImageIcon(JBeesUtils.getImage("help.gif", this));
        this.stopIcon = new ImageIcon(JBeesUtils.getImage("stop.gif", this));
        this.addIcon = new ImageIcon(JBeesUtils.getImage("add.gif", this));
        this.delIcon = new ImageIcon(JBeesUtils.getImage("del.gif", this));
        this.resumeIcon = new ImageIcon(JBeesUtils.getImage("resume.gif", this));
        this.downloadIcon = new ImageIcon(JBeesUtils.getImage("download.gif", this));
        this.runningIcon = new ImageIcon(JBeesUtils.getImage("running.gif", this));
        this.unixIcon = new ImageIcon(JBeesUtils.getImage("unix.gif", this));
        this.windowIcon = new ImageIcon(JBeesUtils.getImage("window.gif", this));
        this.againIcon = new ImageIcon(JBeesUtils.getImage("again.gif", this));
        this.scheduleIcon = new ImageIcon(JBeesUtils.getImage("schedule.gif", this));
        this.scheduleTableIcon = new ImageIcon(JBeesUtils.getImage("scheduletable.gif", this));
        this.musicIcon = new ImageIcon(JBeesUtils.getImage("music.gif", this));
        this.ftpbatchIcon = new ImageIcon(JBeesUtils.getImage("ftpbatch.gif", this));
        this.selectallIcon = new ImageIcon(JBeesUtils.getImage("selectall.gif", this));
        this.deselectallIcon = new ImageIcon(JBeesUtils.getImage("deselectall.gif", this));
        this.updateIcon = new ImageIcon(JBeesUtils.getImage("update.gif", this));
    }

    private void initComponents() {
        JMenuBar mb = new JMenuBar();
        this.initAction();
        this.addMenu(mb);
        this.setJMenuBar(mb);
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        JToolBar jtb = new JToolBar();
        this.addToolButtons(jtb);
        con.add((Component)jtb, "North");
        JSplitPane jsp = new JSplitPane();
        this.addJspTree(jsp);
        this.addJspTable(jsp);
        con.add((Component)jsp, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.add(new JLabel(this.menuIcon));
        con.add((Component)statusPanel, "South");
        this.jpopmenu = new JPopupMenu();
        this.addPopItem();
        this.runningTable.addMouseListener(new 2());
        this.resumeTable.addMouseListener(new 3());
        this.queueTable.addMouseListener(new 4());
        this.downloadedTable.addMouseListener(new 5());
        this.scheduleTable.addMouseListener(new 6());
    }

    private void initAction() {
        this.exitAction = new JBeesUIAction("Exit", this.exitIcon, this);
        this.addAction = new JBeesUIAction("Add", this.addIcon, this);
        this.ftpBatchAction = new JBeesUIAction("FTP batch", this.ftpbatchIcon, this);
        this.deleteAction = new JBeesUIAction("Delete", this.delIcon, this);
        this.deleteAction.setEnabled(false);
        this.editAction = new JBeesUIAction("Edit", this.editIcon, this);
        this.editAction.setEnabled(false);
        this.startAction = new JBeesUIAction("Start", this.startIcon, this);
        this.startAction.setEnabled(false);
        this.stopAction = new JBeesUIAction("Stop", this.stopIcon, this);
        this.stopAction.setEnabled(false);
        this.startallAction = new JBeesUIAction("Start all", this.startallIcon, this);
        this.startallAction.setEnabled(false);
        this.againAction = new JBeesUIAction("Download again", this.againIcon, this);
        this.againAction.setEnabled(false);
        this.preferencesAction = new JBeesUIAction("Preferences", this.preferencesIcon, this);
        this.aboutAction = new JBeesUIAction("About", this.aboutIcon, this);
        this.helpAction = new JBeesUIAction("Help", this.helpIcon, this);
        this.scheduleAction = new JBeesUIAction("Schedule", this.scheduleIcon, this);
        this.checkUpdateAction = new JBeesUIAction("Check update", this.updateIcon, this);
        this.checkUpdateAction.setEnabled(false);
        this.selectAllAction = new JBeesUIAction("Select all", this.selectallIcon, this);
        this.deSelectAllAction = new JBeesUIAction("Deselect all", this.deselectallIcon, this);
        this.deSelectAllAction.setEnabled(false);
        this.selectAllAction.setEnabled(false);
    }

    private void addMenu(JMenuBar mb) {
        JBeesUtils.buildMenuDetail("File", new Action[]{this.ftpBatchAction, this.scheduleAction, null, this.exitAction}, mb);
        JBeesUtils.buildMenuDetail("Edit", new Action[]{this.selectAllAction, this.deSelectAllAction, null, this.addAction, this.deleteAction, this.editAction}, mb);
        JBeesUtils.buildMenuDetail("Download", new Action[]{this.startAction, this.stopAction, this.startallAction, null, this.againAction, this.checkUpdateAction}, mb);
        JMenu menu = JBeesUtils.buildMenuDetail("Options", new Action[]{this.preferencesAction}, mb);
        JMenuItem jcm = new JMenuItem("Music");
        menu.add(jcm);
        jcm.addActionListener(new 7(jcm));
        JBeesUtils.buildMenuDetail("Help", new Action[]{this.helpAction, this.aboutAction}, mb);
    }

    private void addPopItem() {
        this.jpopmenu.add(this.addAction);
        this.jpopmenu.add(this.editAction);
        this.jpopmenu.add(this.deleteAction);
        this.jpopmenu.addSeparator();
        this.jpopmenu.add(this.ftpBatchAction);
        this.jpopmenu.add(this.scheduleAction);
        this.jpopmenu.addSeparator();
        this.jpopmenu.add(this.startAction);
        this.jpopmenu.add(this.stopAction);
        this.jpopmenu.add(this.startallAction);
        this.jpopmenu.addSeparator();
        this.jpopmenu.add(this.againAction);
        this.jpopmenu.add(this.checkUpdateAction);
    }

    private void addToolButtons(JToolBar jtb) {
        this.addButton = new ActionButton(this.addAction);
        jtb.add(this.addButton);
        this.deleteButton = new ActionButton(this.deleteAction);
        jtb.add(this.deleteButton);
        jtb.addSeparator();
        this.startButton = new ActionButton(this.startAction);
        jtb.add(this.startButton);
        this.stopButton = new ActionButton(this.stopAction);
        jtb.add(this.stopButton);
        this.scheduleButton = new ActionButton(this.scheduleAction);
        jtb.add(this.scheduleButton);
        this.scheduleAction.setEnabled(false);
        this.scheduleButton.setEnabled(false);
        jtb.addSeparator();
        this.ftpBatchButton = new ActionButton(this.ftpBatchAction);
        jtb.add(this.ftpBatchButton);
        jtb.addSeparator();
        this.windowButton = new ActionButton(new JBeesUIAction("Windows", this.windowIcon, this));
        jtb.add(this.windowButton);
        this.metalButton = new ActionButton(new JBeesUIAction("Metal", this.metalIcon, this));
        jtb.add(this.metalButton);
        this.motifButton = new ActionButton(new JBeesUIAction("Motif", this.unixIcon, this));
        jtb.add(this.motifButton);
        jtb.addSeparator();
        jtb.add(new ActionButton(this.exitAction));
        this.metalButton.setEnabled(false);
    }

    private void addJspTree(JSplitPane jsp) {
        JScrollPane jscp = new JScrollPane();
        JTree tree = new JBeesTree().getJTree();
        tree.addTreeSelectionListener(this);
        jscp.setViewportView(tree);
        jsp.setLeftComponent(jscp);
    }

    private void addJspTable(JSplitPane jsp) {
        this.workPanel = new JPanel();
        this.workPanel.setLayout(new CardLayout());
        JScrollPane jscp = new JScrollPane();
        this.runningTable = new JBeesJTable(this);
        this.runningTable.setModel(new 8(new String[]{"Status", "Local File", "File Length", "Percentage", "Rate", "Time Elapsed", "Time Left", "Bees Num", "URL"}, 10));
        jscp.setViewportView(this.runningTable);
        jscp.setHorizontalScrollBarPolicy(32);
        this.runningTable.setAutoResizeMode(0);
        this.workPanel.add((Component)jscp, runStr);
        jscp = new JScrollPane();
        this.queueTable = new JBeesJTable(this);
        this.queueTable.setModel(new 9(new String[]{"Status", "Local File", "URL"}, 10));
        jscp.setViewportView(this.queueTable);
        this.workPanel.add((Component)jscp, inqStr);
        jscp = new JScrollPane();
        this.resumeTable = new JBeesJTable(this);
        this.resumeTable.setModel(new 10(new String[]{"Status", "Local File", "File Length", "Percentage", "URL"}, 10));
        jscp.setViewportView(this.resumeTable);
        this.workPanel.add((Component)jscp, resStr);
        jscp = new JScrollPane();
        this.downloadedTable = new JBeesJTable(this);
        this.downloadedTable.setModel(new 11(new String[]{"Status", "Local File", "File Length", "URL"}, 10));
        jscp.setViewportView(this.downloadedTable);
        this.workPanel.add((Component)jscp, dldStr);
        jscp = new JScrollPane();
        this.scheduleTable = new JBeesJTable(this);
        this.scheduleTable.setModel(new 12(new String[]{"Status", "Local File", "Schedule Time", "URL"}, 10));
        jscp.setViewportView(this.scheduleTable);
        this.workPanel.add((Component)jscp, scheduleStr);
        jsp.setRightComponent(this.workPanel);
    }

    void doAction(ActionEvent evt) {
        String comStr = evt.getActionCommand();
        if (comStr.equals("Exit")) {
            this.exitForm();
        } else if (comStr.equals("Metal")) {
            this.windowButton.setEnabled(true);
            this.motifButton.setEnabled(true);
            this.metalButton.setEnabled(false);
            JBeesUtils.adjustLookandFeel("javax.swing.plaf.metal.MetalLookAndFeel", this);
        } else if (comStr.equals("Motif")) {
            this.windowButton.setEnabled(true);
            this.motifButton.setEnabled(false);
            this.metalButton.setEnabled(true);
            JBeesUtils.adjustLookandFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel", this);
        } else if (comStr.equals("Windows")) {
            this.windowButton.setEnabled(false);
            this.motifButton.setEnabled(true);
            this.metalButton.setEnabled(true);
            JBeesUtils.adjustLookandFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", this);
        } else if (comStr.equals("Add")) {
            this.doAdd(null);
        } else if (comStr.equals("Delete")) {
            this.doDelete();
        } else if (comStr.equals("Edit")) {
            this.doEdit();
        } else if (comStr.equals("Start")) {
            this.doStart();
        } else if (comStr.equals("Start all")) {
            this.doStartAll();
        } else if (comStr.equals("Stop")) {
            this.doStop();
        } else if (comStr.equals("Download again")) {
            this.doDownloadAgain();
        } else if (comStr.equals("About")) {
            this.doAbout();
        } else if (comStr.equals("Preferences")) {
            this.doPreferences();
        } else if (comStr.equals("Schedule")) {
            this.doSchedule(null, null);
        } else if (comStr.equals("Help")) {
            this.doHelp();
        } else if (comStr.equals("Check update")) {
            this.doCheckUpdate();
        } else if (comStr.equals("Select all")) {
            this.doSelectAll();
        } else if (comStr.equals("Deselect all")) {
            this.doDeselectAll();
        } else if (comStr.equals("HTTP batch")) {
            this.doHTTPBatch();
        } else if (comStr.equals("FTP batch")) {
            this.doFTPBatch();
        } else {
            return;
        }
    }

    private void doHTTPBatch() {
    }

    private void doFTPBatch() {
        JBeesFTPBatchModel model = new JBeesFTPBatchModel();
        ((Component)new JBeesFTPBatchDlg(this, this.jbconf, model)).setVisible(true);
        if (model.getRetOption() == 1) {
            JBeesFTPFileChosed jbftc = model.getChosed();
            if (jbftc == null) {
                return;
            }
            String user = jbftc.getUser();
            String passwd = jbftc.getPasswd();
            Object[] urls = jbftc.getURLs();
            if (urls == null) {
                return;
            }
            int i = 0;
            while (i < urls.length) {
                String localfile = jbftc.getLocalFile((String)urls[i]);
                JBeesQueueInfo jbqinfo = new JBeesQueueInfo((String)urls[i], localfile, user, passwd);
                this.addJob(jbqinfo);
                ++i;
            }
        }
    }

    private void doSelectAll() {
        switch (this.whatLeaf) {
            case 0: {
                this.runningTable.setRowSelectionInterval(0, this.runningVector.size() - 1);
                this.chgRunAction();
                break;
            }
            case 1: {
                this.queueTable.setRowSelectionInterval(0, this.queueVector.size() - 1);
                this.chgInqAction();
                break;
            }
            case 2: {
                this.resumeTable.setRowSelectionInterval(0, this.resumeVector.size() - 1);
                this.chgResAction();
                break;
            }
            case 4: {
                this.scheduleTable.setRowSelectionInterval(0, this.scheduleVector.size() - 1);
                this.chgScheduleAction();
                break;
            }
            case 3: {
                this.downloadedTable.setRowSelectionInterval(0, this.downloadedVector.size() - 1);
                this.chgDldAction();
            }
        }
        this.selectAllAction.setEnabled(false);
        this.deSelectAllAction.setEnabled(true);
    }

    private void doDeselectAll() {
        switch (this.whatLeaf) {
            case 0: {
                this.runningTable.clearSelection();
                this.chgRunAction();
                break;
            }
            case 1: {
                this.queueTable.clearSelection();
                this.chgInqAction();
                break;
            }
            case 2: {
                this.resumeTable.clearSelection();
                this.chgResAction();
                break;
            }
            case 4: {
                this.scheduleTable.clearSelection();
                this.chgScheduleAction();
                break;
            }
            case 3: {
                this.downloadedTable.clearSelection();
                this.chgDldAction();
            }
        }
        this.selectAllAction.setEnabled(true);
        this.deSelectAllAction.setEnabled(false);
    }

    private void doCheckUpdate() {
        int[] selectedIndice = this.downloadedTable.getSelectedRows();
        this.downloadedTable.clearSelection();
        this.checkUpdateAction.setEnabled(false);
        this.againAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        Vector v = new Vector();
        int i = 0;
        while (i < selectedIndice.length) {
            v.add(this.downloadedVector.elementAt(selectedIndice[i]));
            ++i;
        }
        this.ckuThread = new Thread(new JBeesCheckUpdate(v, this.jbconf));
        this.ckuThread.start();
    }

    private void doSchedule(String url, JBeesScheduleInfo jbs) {
        JBeesScheduleDlg jbsd;
        if (jbs != null) {
            jbsd = new JBeesScheduleDlg(this, "Edit a schedule job", jbs);
        } else {
            jbs = new JBeesScheduleInfo();
            jbsd = url == null ? new JBeesScheduleDlg(this, "Schedule a job", jbs) : new JBeesScheduleDlg(this, "Schedule a job", jbs, url);
        }
        jbsd.showDlg();
        if (jbs.getURL() != null) {
            JBeesMainFrame jBeesMainFrame = this;
            synchronized (jBeesMainFrame) {
                this.hsset.add(jbs.getURL().toLowerCase().trim());
                JBeesTimerTask jbtt = new JBeesTimerTask(jbs.getURL(), this);
                jbs.setTimerTask(jbtt);
                this.scheduleVector.add(jbs);
                Object[] col = new Object[]{this.scheduleTableIcon, jbs.getLocalFileName(), jbs.getDate(), jbs.getURL()};
                JBeesUtils.fillTableRow(this.scheduleTable, col, 10);
                DateFormat df = DateFormat.getDateTimeInstance();
                Date date = null;
                try {
                    date = df.parse(jbs.getDate());
                }
                catch (Exception exception) {}
                this.scheduleTimer.schedule((TimerTask)jbtt, date);
                if (this.whatLeaf == 4) {
                    this.selectAllAction.setEnabled(true);
                    this.deSelectAllAction.setEnabled(false);
                }
            }
        }
    }

    private void doDownloadAgain() {
        if (this.downloadedTable.getSelectedRowCount() > 0) {
            this.againAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.checkUpdateAction.setEnabled(false);
            int[] index = JBeesUtils.deleteTableRow(this.downloadedTable, 10);
            JBeesMainFrame jBeesMainFrame = this;
            synchronized (jBeesMainFrame) {
                int i = index.length - 1;
                while (i >= 0) {
                    JBeesDownloadedFileInfo jbdfinfo = (JBeesDownloadedFileInfo)this.downloadedVector.elementAt(index[i]);
                    JBeesQueueInfo jbqinfo = new JBeesQueueInfo();
                    jbqinfo.setURL(jbdfinfo.getURL());
                    jbqinfo.setLocalFileName(jbdfinfo.getLocalFileName());
                    jbqinfo.setUser(jbdfinfo.getUser());
                    jbqinfo.setPasswd(jbdfinfo.getPasswd());
                    this.queueVector.addElement(jbqinfo);
                    try {
                        File f = new File(jbdfinfo.getLocalFileName());
                        f.delete();
                    }
                    catch (Exception exception) {}
                    Object[] o = new Object[]{this.queueIcon, jbqinfo.getLocalFileName(), jbqinfo.getURL()};
                    JBeesUtils.fillTableRow(this.queueTable, o, 10);
                    --i;
                }
            }
        }
    }

    private void doHelp() {
        new JBeesHelpDlg();
    }

    private void doPreferences() {
        JBeesPreferencesDlg jdpdlg = new JBeesPreferencesDlg(this, true, this.jbconf);
        ((Component)jdpdlg).setVisible(true);
    }

    private void doAbout() {
        new JBeesAboutDlg((Frame)this, true).show();
    }

    private synchronized void doStop() {
        this.stopAction.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        int[] index = JBeesUtils.deleteTableRow(this.runningTable, 10);
        int i = index.length - 1;
        while (i >= 0) {
            JBeesRunningInfo jbrinfo = (JBeesRunningInfo)this.runningVector.elementAt(index[i]);
            JBeesTeam jbt = jbrinfo.getJBeesTeam();
            jbt.stopDownload();
            this.runningVector.removeElementAt(index[i]);
            JBeesResumeFileInfo jbrfi = jbt.getResumeFileInfo();
            if (jbt.isSuccess()) {
                JBeesDownloadedFileInfo jbdfinfo = new JBeesDownloadedFileInfo();
                jbdfinfo.setURL(jbrfi.getOrgURL());
                jbdfinfo.setFileLength(jbrfi.getRemoteFileLength());
                jbdfinfo.setLocalFileName(jbrfi.getLocalFileName());
                jbdfinfo.setUser(jbrfi.getUser());
                jbdfinfo.setPasswd(jbrfi.getPasswd());
                this.downloadedVector.addElement(jbdfinfo);
                Object[] o = new Object[]{this.downloadIcon, jbdfinfo.getLocalFileName(), new Long(jbdfinfo.getFileLength()), jbdfinfo.getURL()};
                JBeesUtils.fillTableRow(this.downloadedTable, o, 10);
            } else {
                this.resumeVector.addElement(jbrfi);
                Object[] o = new Object[]{this.resumeIcon, jbrfi.getLocalFileName(), new Long(jbrfi.getRemoteFileLength()), "" + (int)(jbrfi.getPercentage() * 100.0) + "%", jbrfi.getOrgURL()};
                JBeesUtils.fillTableRow(this.resumeTable, o, 10);
            }
            jbt = null;
            --i;
        }
        if (this.runningVector.size() == 0) {
            this.selectAllAction.setEnabled(false);
            this.deSelectAllAction.setEnabled(false);
        }
    }

    private void doStartAll() {
        int size = this.resumeVector.size();
        this.resumeTable.setRowSelectionInterval(0, size - 1);
        this.doStart();
    }

    private synchronized void doStart() {
        int[] index = JBeesUtils.deleteTableRow(this.resumeTable, 10);
        int i = index.length - 1;
        while (i >= 0) {
            JBeesResumeFileInfo jbrfi = (JBeesResumeFileInfo)this.resumeVector.elementAt(index[i]);
            JBeesQueueInfo jbqi = new JBeesQueueInfo(jbrfi);
            this.queueVector.addElement(jbqi);
            this.resumeVector.removeElementAt(index[i]);
            Object[] o = new Object[]{this.queueIcon, jbrfi.getLocalFileName(), jbrfi.getOrgURL()};
            JBeesUtils.fillTableRow(this.queueTable, o, 10);
            --i;
        }
        this.startAction.setEnabled(false);
        this.startButton.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        if (this.resumeVector.size() == 0) {
            this.startallAction.setEnabled(false);
            this.selectAllAction.setEnabled(false);
        }
        this.deSelectAllAction.setEnabled(false);
    }

    private void doEditSchedule() {
        JBeesScheduleInfo jbsi;
        this.editAction.setEnabled(false);
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            int[] index = JBeesUtils.deleteTableRow(this.scheduleTable, 10);
            jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(index[0]);
            this.scheduleVector.removeElementAt(index[0]);
            this.hsset.remove(jbsi.getURL().trim().toLowerCase());
            jbsi.getTimerTask().cancel();
        }
        JBeesScheduleDlg jbsdlg = new JBeesScheduleDlg(this, "Edit schedule", jbsi);
        jbsdlg.showDlg();
        JBeesMainFrame jBeesMainFrame2 = this;
        synchronized (jBeesMainFrame2) {
            this.hsset.add(jbsi.getURL().trim().toLowerCase());
            JBeesTimerTask jbtt = new JBeesTimerTask(jbsi.getURL(), this);
            jbsi.setTimerTask(jbtt);
            this.scheduleVector.add(jbsi);
            Object[] col = new Object[]{this.scheduleTableIcon, jbsi.getLocalFileName(), jbsi.getDate(), jbsi.getURL()};
            JBeesUtils.fillTableRow(this.scheduleTable, col, 10);
            DateFormat df = DateFormat.getDateTimeInstance();
            Date date = null;
            try {
                date = df.parse(jbsi.getDate());
            }
            catch (Exception exception) {}
            this.scheduleTimer.schedule((TimerTask)jbtt, date);
        }
    }

    private void doEdit() {
        JBeesQueueInfo jbqinfo;
        if (this.whatLeaf == 4) {
            this.doEditSchedule();
            return;
        }
        this.editAction.setEnabled(false);
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            int[] index = JBeesUtils.deleteTableRow(this.queueTable, 10);
            jbqinfo = (JBeesQueueInfo)this.queueVector.elementAt(index[0]);
            this.queueVector.removeElementAt(index[0]);
        }
        if (jbqinfo.getResumeInfo() != null) {
            this.hsset.remove(jbqinfo.getResumeInfo().getOrgURL().toLowerCase());
            JOptionPane.showMessageDialog(this, "Can't edit resume info", "Error", 0);
        } else {
            this.hsset.remove(jbqinfo.getURL().toLowerCase());
            JBeesAddOption jbaop = new JBeesAddOption(this, jbqinfo);
            jbaop.showAddDlg();
        }
        JBeesMainFrame jBeesMainFrame2 = this;
        synchronized (jBeesMainFrame2) {
            this.queueVector.add(jbqinfo);
            Object[] o = new Object[3];
            o[0] = this.queueIcon;
            if (jbqinfo.getResumeInfo() == null) {
                o[2] = jbqinfo.getURL();
                this.hsset.add(jbqinfo.getURL().toLowerCase());
                o[1] = jbqinfo.getLocalFileName();
            } else {
                o[2] = jbqinfo.getResumeInfo().getOrgURL();
                this.hsset.add(jbqinfo.getResumeInfo().getOrgURL().toLowerCase());
                o[1] = jbqinfo.getResumeInfo().getLocalFileName();
            }
            JBeesUtils.fillTableRow(this.queueTable, o, 10);
        }
    }

    public void doAdd(String url) {
        if (this.whatLeaf == 4) {
            this.doSchedule(url, null);
            return;
        }
        JBeesAddOption jbaop = url == null ? new JBeesAddOption(this) : new JBeesAddOption(this, url);
        jbaop.showAddDlg();
        if (jbaop.getWhatPushed() == 0) {
            JBeesQueueInfo jqinfo = jbaop.getJBeesQueueInfo();
            this.addJob(jqinfo);
        }
    }

    private void addJob(JBeesQueueInfo jqinfo) {
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            this.queueVector.add(jqinfo);
            Object[] o = new Object[3];
            o[0] = this.queueIcon;
            o[2] = jqinfo.getURL();
            this.hsset.add(jqinfo.getURL().trim().toLowerCase());
            o[1] = jqinfo.getLocalFileName();
            JBeesUtils.fillTableRow(this.queueTable, o, 10);
        }
        if (this.whatLeaf == 0) {
            this.selectAllAction.setEnabled(true);
            this.deSelectAllAction.setEnabled(false);
        }
    }

    private void doDelete() {
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.startAction.setEnabled(false);
        this.startButton.setEnabled(false);
        switch (this.whatLeaf) {
            case 0: {
                this.doDelrun();
                break;
            }
            case 1: {
                this.doDelcomm(this.queueVector, this.queueTable);
                break;
            }
            case 2: {
                this.doDelcomm(this.resumeVector, this.resumeTable);
                break;
            }
            case 3: {
                this.doDelcomm(this.downloadedVector, this.downloadedTable);
                break;
            }
            case 4: {
                this.doDelschedule();
            }
        }
    }

    private synchronized void doDelschedule() {
        int[] delIndice = JBeesUtils.deleteTableRow(this.scheduleTable, 10);
        int i = delIndice.length - 1;
        while (i >= 0) {
            JBeesScheduleInfo jbsi = (JBeesScheduleInfo)this.scheduleVector.elementAt(delIndice[i]);
            this.hsset.remove(jbsi.getURL().toLowerCase());
            jbsi.getTimerTask().cancel();
            this.scheduleVector.removeElementAt(delIndice[i]);
            --i;
        }
    }

    private void doDelrun() {
        this.stopAction.setEnabled(false);
        this.stopButton.setEnabled(false);
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            int[] delIndice = JBeesUtils.deleteTableRow(this.runningTable, 10);
            int i = delIndice.length - 1;
            while (i >= 0) {
                JBeesRunningInfo jbrinfo = (JBeesRunningInfo)this.runningVector.elementAt(delIndice[i]);
                this.hsset.remove(jbrinfo.getURL().toLowerCase());
                jbrinfo.getJBeesTeam().stopDownload();
                this.runningVector.removeElementAt(delIndice[i]);
                --i;
            }
        }
        if (this.runningVector.size() > 0) {
            this.selectAllAction.setEnabled(true);
        } else {
            this.selectAllAction.setEnabled(false);
        }
        this.deSelectAllAction.setEnabled(false);
    }

    private void doDelcomm(Vector v, JTable table) {
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            int[] delIndice = JBeesUtils.deleteTableRow(table, 10);
            int i = delIndice.length - 1;
            while (i >= 0) {
                if (this.whatLeaf == 1) {
                    JBeesQueueInfo qinfo = (JBeesQueueInfo)v.elementAt(delIndice[i]);
                    if (qinfo.getResumeInfo() != null) {
                        this.hsset.remove(qinfo.getResumeInfo().getOrgURL().toLowerCase());
                    } else {
                        this.hsset.remove(qinfo.getURL().toLowerCase());
                    }
                } else if (this.whatLeaf == 2) {
                    JBeesResumeFileInfo jrf = (JBeesResumeFileInfo)v.elementAt(delIndice[i]);
                    this.hsset.remove(jrf.getOrgURL().toLowerCase());
                } else {
                    JBeesDownloadedFileInfo jbd = (JBeesDownloadedFileInfo)v.elementAt(delIndice[i]);
                    this.hsset.remove(jbd.getURL().toLowerCase());
                }
                v.removeElementAt(delIndice[i]);
                if (v.size() > 0) {
                    this.selectAllAction.setEnabled(true);
                } else {
                    this.selectAllAction.setEnabled(false);
                }
                this.deSelectAllAction.setEnabled(false);
                --i;
            }
        }
        if (this.whatLeaf == 2 && this.resumeVector.size() == 0) {
            this.startallAction.setEnabled(false);
        }
        this.againAction.setEnabled(false);
    }

    private void exitForm() {
        this.inExiting = true;
        this.scheduleTimer.cancel();
        this.jbclock.interrupt();
        if (this.ckuThread != null && this.ckuThread.isAlive()) {
            this.ckuThread.interrupt();
            this.ckuThread = null;
        }
        if (this.runningVector.size() > 0) {
            this.runningTable.setRowSelectionInterval(0, this.runningVector.size() - 1);
            this.doStop();
        }
        JBeesInit jbinit = new JBeesInit();
        jbinit.setConfInfo(this.jbconf);
        jbinit.setQueueInfo(this.queueVector);
        jbinit.setResumeInfo(this.resumeVector);
        jbinit.setDownloadedInfo(this.downloadedVector);
        jbinit.setScheduleInfo(this.scheduleVector);
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public void valueChanged(TreeSelectionEvent e) {
        JTree tree = (JTree)e.getSource();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            String str = (String)nodeInfo;
            CardLayout card = (CardLayout)this.workPanel.getLayout();
            card.show(this.workPanel, str);
            if (str.equals(runStr)) {
                this.whatLeaf = 0;
                this.runningTable.clearSelection();
                this.chgRunAction();
            } else if (str.equals(inqStr)) {
                this.whatLeaf = 1;
                this.queueTable.clearSelection();
                this.chgInqAction();
            } else if (str.equals(resStr)) {
                this.whatLeaf = 2;
                this.resumeTable.clearSelection();
                this.chgResAction();
            } else if (str.equals(scheduleStr)) {
                this.whatLeaf = 4;
                this.scheduleTable.clearSelection();
                this.chgScheduleAction();
            } else {
                this.whatLeaf = 3;
                this.downloadedTable.clearSelection();
                this.chgDldAction();
            }
        }
    }

    private void setAllFalse() {
        this.addAction.setEnabled(false);
        this.addButton.setEnabled(false);
        this.scheduleAction.setEnabled(false);
        this.scheduleButton.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.editAction.setEnabled(false);
        this.startAction.setEnabled(false);
        this.startButton.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.startallAction.setEnabled(false);
        this.againAction.setEnabled(false);
        this.checkUpdateAction.setEnabled(false);
        this.selectAllAction.setEnabled(false);
        this.deSelectAllAction.setEnabled(false);
    }

    private void chgInqAction() {
        int i;
        this.setAllFalse();
        this.addAction.setEnabled(true);
        this.addButton.setEnabled(true);
        if (this.queueVector.size() > 0) {
            this.selectAllAction.setEnabled(true);
        }
        if ((i = this.queueTable.getSelectedRowCount()) > 0) {
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
            if (i == 1) {
                this.editAction.setEnabled(true);
            }
        }
    }

    private void chgRunAction() {
        this.setAllFalse();
        this.addAction.setEnabled(true);
        this.addButton.setEnabled(true);
        if (this.runningVector.size() > this.runningTable.getSelectedRowCount()) {
            this.selectAllAction.setEnabled(true);
        }
        if (this.runningTable.getSelectedRowCount() > 0) {
            this.stopAction.setEnabled(true);
            this.stopButton.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void chgResAction() {
        this.setAllFalse();
        this.addAction.setEnabled(true);
        this.addButton.setEnabled(true);
        if (this.resumeVector.size() > 0) {
            this.startallAction.setEnabled(true);
            this.selectAllAction.setEnabled(true);
        }
        if (this.resumeTable.getSelectedRowCount() > 0) {
            this.startAction.setEnabled(true);
            this.startButton.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void chgScheduleAction() {
        this.setAllFalse();
        this.scheduleAction.setEnabled(true);
        this.scheduleButton.setEnabled(true);
        if (this.scheduleVector.size() > 0) {
            this.selectAllAction.setEnabled(true);
        }
        if (this.scheduleTable.getSelectedRowCount() > 0) {
            this.editAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void chgDldAction() {
        this.setAllFalse();
        this.addAction.setEnabled(true);
        this.addButton.setEnabled(true);
        if (this.downloadedVector.size() > 0) {
            this.selectAllAction.setEnabled(true);
        }
        if (this.downloadedTable.getSelectedRowCount() > 0) {
            this.deleteAction.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.againAction.setEnabled(true);
            this.checkUpdateAction.setEnabled(true);
        }
    }

    public synchronized void JBeesTeamStatusChanged(JBeesTeamStatusEvent jbtse) {
        JBeesTeam jbt = (JBeesTeam)jbtse.getSource();
        if (jbt.getStopped()) {
            return;
        }
        JBeesDownloadedFileInfo jbdinfo = null;
        JBeesResumeFileInfo jbrinfo = null;
        JBeesTeamStatus jbts = jbtse.getJBeesTeamStatus();
        int index = this.getRunningVectorIndex(jbts);
        if (index == -1) {
            return;
        }
        if (jbt.isFinished()) {
            if (jbt.isSuccess()) {
                jbdinfo = new JBeesDownloadedFileInfo();
                jbdinfo.setURL(jbts.getOrgURL());
                jbdinfo.setFileLength(jbts.getRemoteFileLength());
                jbdinfo.setLocalFileName(jbts.getLocalFileName());
                jbdinfo.setUser(jbt.getResumeFileInfo().getUser());
                jbdinfo.setPasswd(jbt.getResumeFileInfo().getPasswd());
                jbdinfo.setLastModifiedDate(jbt.getLastModifiedDate());
                this.downloadedVector.addElement(jbdinfo);
                Object[] o = new Object[]{this.downloadIcon, jbdinfo.getLocalFileName(), new Long(jbdinfo.getFileLength()), jbdinfo.getURL()};
                JBeesUtils.fillTableRow(this.downloadedTable, o, 10);
                if (this.whatLeaf == 3) {
                    this.selectAllAction.setEnabled(true);
                    this.deSelectAllAction.setEnabled(false);
                }
            } else {
                jbrinfo = jbt.getResumeFileInfo();
                this.resumeVector.addElement(jbrinfo);
                Object[] o = new Object[]{this.resumeIcon, jbrinfo.getLocalFileName(), new Long(jbrinfo.getRemoteFileLength()), "" + (int)(jbrinfo.getPercentage() * 100.0) + "%", jbrinfo.getOrgURL()};
                JBeesUtils.fillTableRow(this.resumeTable, o, 10);
                if (this.whatLeaf == 2) {
                    this.selectAllAction.setEnabled(true);
                    this.deSelectAllAction.setEnabled(false);
                }
            }
            this.runningVector.removeElementAt(index);
            this.runningTable.setRowSelectionInterval(index, index);
            JBeesUtils.deleteTableRow(this.runningTable, 10);
        } else {
            Object[] o = new Object[9];
            o[0] = this.runningIcon;
            o[1] = jbts.getLocalFileName();
            o[2] = new Long(jbts.getRemoteFileLength());
            o[3] = jbts.getPercentage();
            long rate = jbts.getRate();
            o[4] = "" + (rate <= 1024L ? "" + rate : rate / 1024L + "KB");
            o[5] = jbts.getUsedTimeStr();
            o[6] = jbts.getRemainTimeStr();
            o[7] = new Integer(jbts.getBeesNum());
            o[8] = jbts.getOrgURL();
            JBeesUtils.setTableRow(this.runningTable, o, index);
        }
        if (this.whatLeaf == 0) {
            if (this.runningVector.size() > this.runningTable.getSelectedRowCount()) {
                this.selectAllAction.setEnabled(true);
            } else {
                this.selectAllAction.setEnabled(false);
                this.deSelectAllAction.setEnabled(true);
            }
        }
    }

    private int getRunningVectorIndex(JBeesTeamStatus jbts) {
        int i = 0;
        while (i < this.runningVector.size()) {
            JBeesRunningInfo jbri = (JBeesRunningInfo)this.runningVector.elementAt(i);
            if (jbri.getURL().equals(jbts.getOrgURL())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clockChanged(JBeesClockEvent evt) {
        if (this.runningVector.size() == this.jbconf.getJobsNum()) {
            return;
        }
        if (this.queueVector.size() == 0) {
            return;
        }
        int demandJobs = this.jbconf.getJobsNum() - this.runningVector.size();
        int minJobs = 0;
        JBeesQueueInfo[] jbq = null;
        JBeesMainFrame jBeesMainFrame = this;
        synchronized (jBeesMainFrame) {
            minJobs = Math.min(demandJobs, this.queueVector.size());
            jbq = new JBeesQueueInfo[minJobs];
            int i = minJobs - 1;
            while (i >= 0) {
                jbq[i] = (JBeesQueueInfo)this.queueVector.elementAt(i);
                this.queueVector.removeElementAt(i);
                --i;
            }
            this.queueTable.setRowSelectionInterval(0, minJobs - 1);
            JBeesUtils.deleteTableRow(this.queueTable, 10);
            if (this.whatLeaf == 1) {
                this.chgInqAction();
            }
            String protocol = null;
            int i2 = 0;
            while (i2 < minJobs) {
                String url = null;
                JBeesTeam jbt = null;
                JBeesResumeFileInfo jrfi = null;
                String llfile = null;
                jrfi = jbq[i2].getResumeInfo();
                if (jrfi != null) {
                    url = jrfi.getOrgURL();
                    llfile = jrfi.getLocalFileName();
                    protocol = JBeesUtils.getProtocol(url).trim().toLowerCase();
                } else {
                    url = jbq[i2].getURL();
                    llfile = jbq[i2].getLocalFileName();
                    protocol = JBeesUtils.getProtocol(url).trim().toLowerCase();
                }
                try {
                    jbt = jrfi != null ? (protocol.equals("http") ? new JBeesHttpTeam(jrfi, this.jbconf) : new JBeesFtpTeam(jrfi, this.jbconf)) : (protocol.equals("http") ? (jbq[i2].getUser() == null ? new JBeesHttpTeam(new URL(jbq[i2].getURL()), jbq[i2].getLocalFileName(), this.jbconf) : new JBeesHttpTeam(new URL(jbq[i2].getURL()), jbq[i2].getLocalFileName(), this.jbconf, jbq[i2].getUser(), jbq[i2].getPasswd())) : (jbq[i2].getUser() == null ? new JBeesFtpTeam(new URL(jbq[i2].getURL()), jbq[i2].getLocalFileName(), this.jbconf) : new JBeesFtpTeam(new URL(jbq[i2].getURL()), jbq[i2].getLocalFileName(), this.jbconf, jbq[i2].getUser(), jbq[i2].getPasswd())));
                    JBeesRunningInfo jrun = new JBeesRunningInfo(url, jbt);
                    this.runningVector.addElement(jrun);
                    Object[] o = new Object[]{this.runningIcon, llfile, new Long(0L), null, null, null, null, new Integer(0), url};
                    JBeesUtils.fillTableRow(this.runningTable, o, 10);
                    jbt.addJBeesTeamStatusListener(this);
                    new Thread(jbt).start();
                }
                catch (Exception e) {
                    this.hsset.remove(url.trim().toLowerCase());
                    JOptionPane.showMessageDialog(null, "Bad job, deleted " + e.getMessage(), "Error", 0);
                }
                ++i2;
            }
            if (this.whatLeaf == 0) {
                this.chgRunAction();
            }
        }
    }

    public boolean urlExist(String s) {
        return this.hsset.contains(s);
    }

    static /* synthetic */ void access$3(JBeesMainFrame accsParam$0, JPopupMenu accParam$1) {
        accsParam$0.jpopmenu = accParam$1;
    }

    static /* synthetic */ void access$9(JBeesMainFrame accsParam$0, Icon accParam$1) {
        accsParam$0.musicIcon = accParam$1;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            JBeesMainFrame.this.exitForm();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mouseReleased(MouseEvent evt) {
            JBeesUtils.tableSelected(JBeesMainFrame.this.runningTable);
            JBeesMainFrame.this.chgRunAction();
            if (evt.isPopupTrigger()) {
                JBeesMainFrame.this.jpopmenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAdapter {
        public void mouseReleased(MouseEvent evt) {
            JBeesUtils.tableSelected(JBeesMainFrame.this.resumeTable);
            JBeesMainFrame.this.chgResAction();
            if (evt.isPopupTrigger()) {
                JBeesMainFrame.this.jpopmenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends MouseAdapter {
        public void mouseReleased(MouseEvent evt) {
            JBeesUtils.tableSelected(JBeesMainFrame.this.queueTable);
            JBeesMainFrame.this.chgInqAction();
            if (evt.isPopupTrigger()) {
                JBeesMainFrame.this.jpopmenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAdapter {
        public void mouseReleased(MouseEvent evt) {
            JBeesUtils.tableSelected(JBeesMainFrame.this.downloadedTable);
            JBeesMainFrame.this.chgDldAction();
            if (evt.isPopupTrigger()) {
                JBeesMainFrame.this.jpopmenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends MouseAdapter {
        public void mouseReleased(MouseEvent evt) {
            JBeesUtils.tableSelected(JBeesMainFrame.this.scheduleTable);
            JBeesMainFrame.this.chgScheduleAction();
            if (evt.isPopupTrigger()) {
                JBeesMainFrame.this.jpopmenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        private final /* synthetic */ JMenuItem val$jcm;

        public void actionPerformed(ActionEvent evt) {
            if (this.val$jcm.getIcon() == null) {
                this.val$jcm.setIcon(JBeesMainFrame.this.musicIcon);
                JBeesMainFrame.this.jba.loop();
            } else {
                this.val$jcm.setIcon(null);
                JBeesMainFrame.this.jba.stop();
            }
        }

        /* synthetic */ 7(JMenuItem val$jcm) {
            this.val$jcm = val$jcm;
        }
    }

    private final class 8
    extends DefaultTableModel {
        Class[] types;
        boolean[] editable;

        public Class getColumnClass(int columnIndex) {
            try {
                Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return this.types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.editable[columnIndex];
        }

        /* synthetic */ 8(Object[] p$1, int p$2) {
            super(p$1, p$2);
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8;
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz7 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz5 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.types = new Class[]{clazz9, clazz8, clazz7, clazz6, clazz5, clazz4, clazz3, clazz2, clazz};
            this.editable = new boolean[]{false, false, false, false, false, false, false, false, false};
        }
    }

    private final class 9
    extends DefaultTableModel {
        Class[] types;
        boolean[] editable;

        public Class getColumnClass(int columnIndex) {
            try {
                Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return this.types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.editable[columnIndex];
        }

        /* synthetic */ 9(Object[] p$1, int p$2) {
            super(p$1, p$2);
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.types = new Class[]{clazz3, clazz2, clazz};
            this.editable = new boolean[]{false, false, false};
        }
    }

    private final class 10
    extends DefaultTableModel {
        Class[] types;
        boolean[] editable;

        public Class getColumnClass(int columnIndex) {
            try {
                Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return this.types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.editable[columnIndex];
        }

        /* synthetic */ 10(Object[] p$1, int p$2) {
            super(p$1, p$2);
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.types = new Class[]{clazz5, clazz4, clazz3, clazz2, clazz};
            this.editable = new boolean[]{false, false, false, false, false};
        }
    }

    private final class 11
    extends DefaultTableModel {
        Class[] types;
        boolean[] editable;

        public Class getColumnClass(int columnIndex) {
            try {
                Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return this.types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.editable[columnIndex];
        }

        /* synthetic */ 11(Object[] p$1, int p$2) {
            super(p$1, p$2);
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.types = new Class[]{clazz4, clazz3, clazz2, clazz};
            this.editable = new boolean[]{false, false, false, false};
        }
    }

    private final class 12
    extends DefaultTableModel {
        Class[] types;
        boolean[] editable;

        public Class getColumnClass(int columnIndex) {
            try {
                Class<?> clazz = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                Class<?> clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            return this.types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.editable[columnIndex];
        }

        /* synthetic */ 12(Object[] p$1, int p$2) {
            super(p$1, p$2);
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("javax.swing.ImageIcon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.types = new Class[]{clazz4, clazz3, clazz2, clazz};
            this.editable = new boolean[]{false, false, false, false};
        }
    }
}

