
package nFunk.JEP.postfixMathCommand;

import java.lang.Math;
import java.util.*;
import nFunk.JEP.*;

public class Logical extends PostfixMathCommand implements PostfixMathCommandI
{
	int id;
	
	public Logical(int id_in)
	{
		id = id_in;
		numberOfParameters = 2;
	}
	
	public void run(Stack inStack)
		throws ParseException 
	{
		checkStack(inStack);// check the stack
		double y = ((Double)inStack.pop()).doubleValue();
		double x = ((Double)inStack.pop()).doubleValue();
		int r;
		
		switch (id)
		{
			case 0:
				r = ((x!=0d) && (y!=0d)) ? 1 : 0;
				break;
			case 1:
				r = ((x!=0d) || (y!=0d)) ? 1 : 0;
				break;
			default:
				r = 0;
		}
		inStack.push(new Double(r));//push the result on the inStack
		return;
	}
}