/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import com.jniwrapper.win32.ui.controls.SelectFolderField;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

/**
 * @author Serge Piletsky
 */
class FileSystemWatcherSample extends LazyPanel
        implements ActionListener, FileSystemEventListener, PropertyChangeListener
{
    static final String[] ACTION_NAMES = new String[] {"added", "removed", "modified", "renamed"};
    static final String MESSAGE_TEMPLATE = "File ''{0}'' was {1}";

    static final String SHORT_DATE_FORMAT = "HH:mm:ss";
    static final String LONG_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";

    private Vector _events;
    private JLabel lblAdvisoryText;
    private JLabel lblSelectedFolderCaption;
    private SelectFolderField _selectFolderField;
    private JCheckBox chkWatchSubtree;
    private JCheckBox chkChangeFileName;
    private JCheckBox chkChangeDirName;
    private JCheckBox chkChangeAttributes;
    private JCheckBox chkChangeSize;
    private JCheckBox chkChangeLastWrite;
    private JList lstEvents;
    private JLabel lblEvents;
    private FileSystemWatcher _fileSystemWatcher;
    private JButton btnStart;
    private JButton btnStop;

    public FileSystemWatcherSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new JLabel("This sample demonstrates FileSystemWatcher class features.");
        lblSelectedFolderCaption = new JLabel("Watching Folder:");
        chkWatchSubtree = new JCheckBox("Watch Subtree");
        chkChangeFileName = new JCheckBox("Watch File Name Change", true);
        chkChangeDirName = new JCheckBox("Watch Dir Name Change", true);
        chkChangeAttributes = new JCheckBox("Watch Attributes Change", true);
        chkChangeSize = new JCheckBox("Watch Size Change", true);
        chkChangeLastWrite = new JCheckBox("Watch Last Write Change", true);
        _selectFolderField = new SelectFolderField();
        _selectFolderField.addPropertyChangeListener(SelectFolderField.PROPERTY_FOLDER, this);
        _events = new Vector();
        lblEvents = new JLabel("File System Events:");
        lstEvents = new JList(_events);
        btnStart = new JButton("Start");
        btnStart.setEnabled(false);
        btnStart.addActionListener(this);
        btnStop = new JButton("Stop");
        btnStop.setEnabled(false);
        btnStop.addActionListener(this);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(lblSelectedFolderCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(_selectFolderField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        add(chkWatchSubtree, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 10, 0, 0), 0, 0));

        add(chkChangeFileName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 5, 0, 10), 0, 0));

        add(chkChangeDirName, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 10, 0, 0), 0, 0));

        add(chkChangeAttributes, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 5, 0, 10), 0, 0));

        add(chkChangeSize, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 10, 0, 0), 0, 0));

        add(chkChangeLastWrite, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(3, 5, 0, 10), 0, 0));

        add(lblEvents, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 10), 0, 0));

        JScrollPane eventPane = new JScrollPane(lstEvents);
        Dimension preferredSize = new Dimension(200, 100);
        eventPane.setPreferredSize(preferredSize);
        eventPane.setMinimumSize(preferredSize);

        add(eventPane, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 10, 10, 10), 0, 0));

        JPanel buttonsPanel = new JPanel();

        buttonsPanel.add(btnStart);
        buttonsPanel.add(btnStop);

        add(buttonsPanel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0
                , GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 10, 0, 10), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getSource().equals(btnStart))
        {
            startWatching();
        }
        else if (e.getSource().equals(btnStop))
        {
            stopWatching();
        }
    }

    private void startWatching()
    {
        _events.clear();
        _events.add("Started at " + getDateTime(true));
        lstEvents.updateUI();
        _fileSystemWatcher = new FileSystemWatcher(_selectFolderField.getFolder(), chkWatchSubtree.isSelected());
        _fileSystemWatcher.addFileSystemListener(this);
        FileSystemWatcher.WatcherOptions options = _fileSystemWatcher.getOptions();
        options.setNotifyChangeAttributes(chkChangeAttributes.isSelected());
        options.setNotifyChangeDirName(chkChangeDirName.isSelected());
        options.setNotifyChangeFileName(chkChangeFileName.isSelected());
        options.setNotifyChangeSize(chkChangeSize.isSelected());
        options.setNotifyLastModified(chkChangeLastWrite.isSelected());
        btnStart.setEnabled(false);
        btnStop.setEnabled(true);
        try
        {
            _fileSystemWatcher.start();
        }
        catch (FileSystemException e1)
        {
            e1.printStackTrace();
        }
    }

    private void stopWatching()
    {
        _events.add("Stopped at " + getDateTime(true));
        lstEvents.updateUI();
        btnStart.setEnabled(true);
        btnStop.setEnabled(false);
        try
        {
            _fileSystemWatcher.stop();
        }
        catch (FileSystemException e1)
        {
            e1.printStackTrace();
        }
    }

    public void deactivate()
    {
        if (_fileSystemWatcher != null && _fileSystemWatcher.isWatching())
        {
            stopWatching();
        }
    }

    public void handle(FileSystemEvent event)
    {
        String actionName = ACTION_NAMES[event.getAction() - 1];
        String message = MessageFormat.format(MESSAGE_TEMPLATE, new Object[]{event.getFileInfo(), actionName});
        if (event.getAction() == FileSystemEvent.FILE_RENAMED)
            message += " from '" + event.getOldFileInfo() + "'";
        message += " at " + getDateTime(false);
        _events.add(message);
        lstEvents.updateUI();
    }

    String getDateTime(boolean longFormat)
    {
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat?LONG_DATE_FORMAT:SHORT_DATE_FORMAT);
        return dateFormat.format(new Date());
    }

    public void propertyChange(PropertyChangeEvent evt)
    {
        btnStart.setEnabled(true);
    }
}
