/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import java.awt.*;
import java.lang.reflect.Constructor;

/**
 * @author Serge Piletsky
 */
class MenuTreeModel extends DefaultTreeModel
{
    private Window _parent;

    public MenuTreeModel(Window parent)
    {
        super(new DefaultMutableTreeNode(new AboutPanel()));
        _parent = parent;
        initModel();
    }

    private void initModel()
    {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)getRoot();

        DefaultMutableTreeNode dialogs = new DefaultMutableTreeNode("Dialogs");
        insertNodeInto(dialogs, root, 0);
        {
            DefaultMutableTreeNode color = new SampleInstanceHolder(ChooseColorSample.class, "Choose Color");
            insertNodeInto(color, dialogs, 0);
            DefaultMutableTreeNode openSaveFile = new SampleInstanceHolder(OpenSaveFileSample.class, "Open/Save File");
            insertNodeInto(openSaveFile, dialogs, 1);
            DefaultMutableTreeNode folder = new SampleInstanceHolder(ChooseFolderSample.class, "Choose Folder");
            insertNodeInto(folder, dialogs, 2);
        }

        DefaultMutableTreeNode window = new DefaultMutableTreeNode("Window");
        insertNodeInto(window, root, 1);
        {
            DefaultMutableTreeNode decorator = new SampleInstanceHolder(WindowDecoratorSample.class, "WindowDecorator");
            insertNodeInto(decorator, window, 0);
            DefaultMutableTreeNode customShapeWindow = new SampleInstanceHolder(CustomShapeWindowSample.class, "Custom Shape Window");
            insertNodeInto(customShapeWindow, window, 1);
            DefaultMutableTreeNode nativeWindow = new SampleInstanceHolder(NativeWindowSample.class, "Native Window");
            insertNodeInto(nativeWindow, window, 2);
        }

        DefaultMutableTreeNode registry = new DefaultMutableTreeNode("Registry");
        insertNodeInto(registry, root, 2);
        {
            DefaultMutableTreeNode registryKey = new SampleInstanceHolder(RegistryKeySample.class, "Registry Key");
            insertNodeInto(registryKey, registry, 0);
        }

        DefaultMutableTreeNode shell = new DefaultMutableTreeNode("Shell");
        insertNodeInto(shell, root, 3);
        {
            DefaultMutableTreeNode trayIcon = new SampleInstanceHolder(TrayIconSample.class, "Tray Icon");
            insertNodeInto(trayIcon, shell, 0);
            DefaultMutableTreeNode shellFolder = new SampleInstanceHolder(ShellFolderSample.class, "Shell Folders");
            insertNodeInto(shellFolder, shell, 1);
            DefaultMutableTreeNode systemColor = new SampleInstanceHolder(SystemColorsSample.class, "System Colors");
            insertNodeInto(systemColor, shell, 2);
        }

        DefaultMutableTreeNode io = new DefaultMutableTreeNode("IO");
        insertNodeInto(io, root, 4);
        {
            DefaultMutableTreeNode fileSystemWatcher = new SampleInstanceHolder(FileSystemWatcherSample.class, "File Sytem Watcher");
            insertNodeInto(fileSystemWatcher, io, 0);
        }

        DefaultMutableTreeNode system = new DefaultMutableTreeNode("System");
        insertNodeInto(system, root, 5);
        {
            DefaultMutableTreeNode processorInfo = new SampleInstanceHolder(ProcessorInfoSample.class, "Processor Info");
            insertNodeInto(processorInfo, system, 0);
        }
        nodeStructureChanged(root);
    }

    class SampleInstanceHolder extends DefaultMutableTreeNode
    {
        private Class _instanceClass;
        private Object _instance;
        private String _name;

        public SampleInstanceHolder(Class instanceClass, String name)
        {
            _instanceClass = instanceClass;
            _name = name;
        }

        public Object getUserObject()
        {
            if (_instance == null)
            {
                try
                {
                    Constructor constructor = _instanceClass.getConstructor(new Class[]{Window.class});
                    _instance = constructor.newInstance(new Object[]{_parent});
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
            return _instance;
        }

        public String toString()
        {
            return _name;
        }
    }
}
