/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Pointer;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.ui.User32;

/**
 * Cursor class provide method to obtain cursor position.
 *
 * @author Serge Piletsky
 */
public class Cursor extends GdiObject
{
    static final String FUNCTION_GET_CURSOR_POS = "GetCursorPos";

    public Cursor()
    {
        super();
    }

    public Cursor(long value)
    {
        super(value);
    }

    public static Point getCursorPosition()
    {
        Point result = new Point();
        final Function function = User32.getInstance().getFunction(FUNCTION_GET_CURSOR_POS);
        function.invoke(null, new Pointer(result));
        return result;
    }

    /**
     * CursorPositionCode class represents enumeration of mouse position codes
     */
    public static class CursorPositionCode extends EnumItem
    {
        public static final CursorPositionCode ERROR  = new CursorPositionCode(-2);
        public static final CursorPositionCode TRANSPARENT = new CursorPositionCode(-1);
        public static final CursorPositionCode NOWHERE = new CursorPositionCode(0);
        public static final CursorPositionCode CLIENT = new CursorPositionCode(1);
        public static final CursorPositionCode CAPTION = new CursorPositionCode(2);
        public static final CursorPositionCode SYSMENU = new CursorPositionCode(3);
        public static final CursorPositionCode GROWBOX = new CursorPositionCode(4);
        public static final CursorPositionCode SIZE = GROWBOX;
        public static final CursorPositionCode MENU = new CursorPositionCode(5);
        public static final CursorPositionCode HSCROLL = new CursorPositionCode(6);
        public static final CursorPositionCode VSCROLL = new CursorPositionCode(7);
        public static final CursorPositionCode MINBUTTON = new CursorPositionCode(8);
        public static final CursorPositionCode MAXBUTTON = new CursorPositionCode(9);
        public static final CursorPositionCode LEFT = new CursorPositionCode(10);
        public static final CursorPositionCode RIGHT = new CursorPositionCode(11);
        public static final CursorPositionCode TOP = new CursorPositionCode(12);
        public static final CursorPositionCode TOPLEFT = new CursorPositionCode(13);
        public static final CursorPositionCode TOPRIGHT = new CursorPositionCode(14);
        public static final CursorPositionCode BOTTOM = new CursorPositionCode(15);
        public static final CursorPositionCode BOTTOMLEFT = new CursorPositionCode(16);
        public static final CursorPositionCode BOTTOMRIGHT = new CursorPositionCode(17);
        public static final CursorPositionCode BORDER = new CursorPositionCode(18);
        public static final CursorPositionCode REDUCE = MINBUTTON;
        public static final CursorPositionCode ZOOM = MAXBUTTON;
        public static final CursorPositionCode SIZEFIRST = LEFT;
        public static final CursorPositionCode SIZELAST = BOTTOMRIGHT;
        public static final CursorPositionCode OBJECT = new CursorPositionCode(19);
        public static final CursorPositionCode CLOSE = new CursorPositionCode(20);
        public static final CursorPositionCode HELP = new CursorPositionCode(21);

        private CursorPositionCode(int value)
        {
            super(value);
        }
    }
}
