/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;

/**
 * Provides functionality for Windows mutex handling.
 *
 * @author Alexander Evsukov
 */
public class Mutex extends Handle
{
    private static final FunctionName FUNCTION_CREATE_MUTEX = new FunctionName("CreateMutex");
    private static final FunctionName FUNCTION_OPEN_MUTEX = new FunctionName("OpenMutex");

    private Mutex()
    {
    }

    public boolean exists()
    {
        return !isNull();
    }

    public static Mutex openMutex(int desiredAccess, boolean inheritHandle, String mutexName)
    {
        final Function openMutex = Kernel32.get(FUNCTION_OPEN_MUTEX);
        final Mutex mutexHandle = new Mutex();
        openMutex.invoke(mutexHandle,
                new UInt32(desiredAccess),
                new Bool(inheritHandle),
                Kernel32.getInstance().stringParam(mutexName));
        return mutexHandle;
    }

    public static Mutex createMutex(Parameter mutexAttributes, boolean initialOwner, String mutexName)
    {
        final Function createMutex = Kernel32.get(FUNCTION_CREATE_MUTEX);
        final Mutex mutexHandle = new Mutex();
        createMutex.invoke(mutexHandle,
                mutexAttributes,
                new Bool(initialOwner),
                Kernel32.getInstance().stringParam(mutexName));
        return mutexHandle;
    }

    public static Mutex createMutex(boolean initialOwner, String mutexName)
    {
        return createMutex(new Handle(), initialOwner, mutexName);
    }
}
