/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.win32.ui.*;

import java.awt.*;

/**
 *
 * @author Serge Piletsky
 */
class DialogHelper
{
    public static void invokeDialog(final Window owner,
                                    final Function function,
                                    final Parameter returnValue,
                                    final Parameter[] parameters)
    {
        final Wnd windowHandle = new Wnd(WindowTools.getWindowHandle(owner));
        WindowProc windowProc = new WindowProc(windowHandle);
        windowProc.addMessageListener(new WindowMessageListener()
        {
            public boolean canHandle(WindowMessage message, boolean beforeWindowProc)
            {
                // just force repaint owner
                if (!beforeWindowProc && message.getMsg() == Msg.WM_PAINT)
                {
                    owner.paint(owner.getGraphics());
                }
                return false;
            }

            public int handle(WindowMessage message)
            {
                return 0;
            }
        });
        windowProc.substitute();
        try
        {
            Thread dialogThread = new Thread(new Runnable()
            {
                public void run()
                {
                    function.invoke(returnValue, parameters);
                }
            });
            dialogThread.start();
            do
            {
                try
                {
                    Thread.sleep(200);
                }
                catch (InterruptedException e)
                {
                    e.printStackTrace();
                }
            }
            while(dialogThread.isAlive());
        }
        finally
        {
            windowProc.restoreNative();
        }
    }
}
