/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.TagsView.CanvasMTagsView;
import cern.lhcias.csgui.Utils.MyUtils;
import cern.lhcias.csgui.rtdb.Tag;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class BarGraphView
extends CanvasMTagsView {
    int nb_of_ticks = 10;
    int x_origin = 40;
    int y_origin = 5;
    int x_border = 60;
    int y_border = 25;
    boolean gridOn = false;
    Font legendFont;
    Color backgroundColor;

    public BarGraphView() {
        this.TYPE = "BarGraphView";
        this.legendFont = new Font("Helvetica", 0, 10);
        this.backgroundColor = new Color(51, 51, 102);
    }

    void TagListHasChanged() {
        this.repaint();
    }

    int getIndex(int n, int n2) {
        int n3 = this.TagstoView.size();
        if (n3 < 1) {
            return -1;
        }
        int n4 = (this.getBounds().width - this.x_border) / n3;
        int n5 = (n - this.x_origin) / n4;
        if (n5 >= this.TagstoView.size()) {
            return -1;
        }
        return n5;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (n < this.x_origin) {
            this.gridOn = !this.gridOn;
            this.repaint();
            return false;
        }
        int n3 = this.getIndex(n, n2);
        if (n3 > -1) {
            this.fireTagClickedEvent((String)this.TagstoView.elementAt(n3));
        }
        return false;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width - this.x_border;
        int n2 = rectangle.height - this.y_border;
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(this.x_origin, this.y_origin, n, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(this.x_origin, this.y_origin, this.x_origin, this.y_origin + n2);
        graphics.drawLine(this.x_origin, this.y_origin + n2, this.x_origin + n, this.y_origin + n2);
        double[] dArray = this.getLimits();
        this.drawVerticalTicks(graphics, this.x_origin, this.y_origin, n, n2, this.nb_of_ticks, dArray[0], dArray[1], 3, this.gridOn, Color.black, Color.white);
        graphics.setFont(this.legendFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = this.TagstoView.size();
        int n4 = n / n3 - 5;
        Vector vector = this.getTags();
        int n5 = 0;
        while (n5 < n3) {
            int n6 = this.x_origin + 4 + n5 * (n / n3);
            graphics.setColor(Color.black);
            graphics.drawString((String)this.TagstoView.elementAt(n5), n6, this.y_origin + n2 + fontMetrics.getMaxAscent());
            this.paint_single_bar((Tag)vector.elementAt(n5), graphics, n6, this.y_origin, n4, n2, dArray[0], dArray[1], MyUtils.get_indexed_color(n5));
            ++n5;
        }
    }

    private void paint_single_bar(Tag tag, Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color) {
        double d3 = new Double(n4);
        graphics.setColor(color);
        boolean bl = tag.getAcquisitionError();
        double d4 = tag.doubleValue();
        if (tag.isValid()) {
            double d5 = (d4 - d) * d3 / (d2 - d);
            if (d5 > d3) {
                d5 = d3;
            }
            if (d5 < 0.0) {
                d5 = 0.0;
            }
            int n5 = new Double(d5).intValue();
            if (d2 * d < 0.0) {
                double d6 = d4 * d3 / (d2 - d);
                int n6 = new Double(d6).intValue();
                if (n6 >= 0) {
                    if (bl) {
                        graphics.drawRect(n, n2 + n4 - n5, n3, n6);
                        return;
                    }
                    graphics.fillRect(n, n2 + n4 - n5, n3, n6);
                    return;
                }
                int n7 = new Double((0.0 - d) * d3 / (d2 - d)).intValue();
                if (bl) {
                    graphics.drawRect(n, n2 + n4 - n7, n3, -n6);
                    return;
                }
                graphics.fillRect(n, n2 + n4 - n7, n3, -n6);
                return;
            }
            if (d2 <= 0.0) {
                double d7 = d4 * d3 / (d2 - d);
                int n8 = new Double(d7).intValue();
                if (bl) {
                    graphics.drawRect(n, n2, n3, -n8);
                    return;
                }
                graphics.fillRect(n, n2, n3, -n8);
                return;
            }
            if (bl) {
                graphics.drawRect(n, n2 + n4 - n5, n3, n5);
                return;
            }
            graphics.fillRect(n, n2 + n4 - n5, n3, n5);
        }
    }
}

