/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.CheckboxGroupConverter;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCGroupBox;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCItemSelectable;
import jclass.util.JCVector;

public class JCCheckboxGroup
extends JCGroupBox
implements JCItemSelectable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected JCVector boxes = new JCVector();
    protected JCCheckbox current;
    int orientation = 1;
    boolean radio_behavior = true;
    protected JCVector itemListeners = new JCVector(0);
    private static final String base = "checkboxgroup";
    private static int nameCounter;

    public JCCheckboxGroup() {
        this(null, null);
    }

    public JCCheckboxGroup(Object object) {
        this(null, null);
        if (object != null) {
            this.setTitle(object);
        }
    }

    public JCCheckboxGroup(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(new GridLayout(0, 1));
        this.setInsets(new Insets(5, 5, 5, 5));
        if (this.getClass().getName().equals("jclass.bwt.JCCheckboxGroup")) {
            this.getParameters(applet);
        }
    }

    protected void getParameters() {
        super.getParameters();
        CheckboxGroupConverter.getParams(this);
    }

    public Component add(JCCheckbox jCCheckbox) {
        this.manage(jCCheckbox);
        return super.add(jCCheckbox);
    }

    public Component add(String string, JCCheckbox jCCheckbox) {
        this.manage(jCCheckbox);
        return super.add(string, jCCheckbox);
    }

    public Component add(JCCheckbox jCCheckbox, int n) {
        this.manage(jCCheckbox);
        return super.add((Component)jCCheckbox, n);
    }

    public void add(JCCheckbox jCCheckbox, Object object) {
        this.manage(jCCheckbox);
        super.add((Component)jCCheckbox, object);
    }

    public void add(JCCheckbox jCCheckbox, Object object, int n) {
        this.manage(jCCheckbox);
        super.add(jCCheckbox, object, n);
    }

    public void manage(JCCheckbox jCCheckbox) {
        if (jCCheckbox == null) {
            return;
        }
        if (jCCheckbox.group != null) {
            jCCheckbox.group.boxes.removeElement(jCCheckbox);
        }
        jCCheckbox.group = this;
        this.boxes.add(jCCheckbox);
        int n = 0;
        while (n < this.itemListeners.size()) {
            jCCheckbox.addItemListener((JCItemListener)this.itemListeners.elementAt(n));
            ++n;
        }
    }

    public int numCheckboxes() {
        return this.boxes.size();
    }

    public JCCheckbox getCheckbox(int n) {
        if (n >= 0 && n < this.boxes.size()) {
            return (JCCheckbox)this.boxes.elementAt(n);
        }
        return null;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        if (n == 1) {
            this.setLayout(new GridLayout(0, 1));
        } else if (n == 0) {
            this.setLayout(new GridLayout(1, 0));
        } else {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        if (this.getParent() != null) {
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().validate();
            this.repaint();
        }
    }

    public JCCheckbox getCurrent() {
        return this.current;
    }

    public int[] getSelectedIndexes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.boxes.size()) {
            if (this.getCheckbox((int)n2).state != 0) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.boxes.size()) {
            if (this.getCheckbox((int)n3).state != 0) {
                nArray[n4++] = n3;
            }
            ++n3;
        }
        return nArray;
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.getCheckbox((int)nArray[n]).label;
            ++n;
        }
        return objectArray;
    }

    public void setCurrent(JCCheckbox jCCheckbox) {
        JCCheckbox jCCheckbox2;
        JCCheckboxGroup jCCheckboxGroup = this;
        synchronized (jCCheckboxGroup) {
            block9: {
                block8: {
                    if (!this.radio_behavior) break block8;
                    if (jCCheckbox == null || jCCheckbox.group == this) break block9;
                }
                Object var4_3 = null;
                return;
            }
            jCCheckbox2 = this.current;
            this.current = jCCheckbox;
        }
        if (jCCheckbox2 != null && jCCheckbox2 != jCCheckbox) {
            jCCheckbox2.setState(0);
        }
        if (jCCheckbox != null && jCCheckbox2 != jCCheckbox && jCCheckbox.state != 1) {
            jCCheckbox.state = 1;
            jCCheckbox.repaint();
        }
    }

    public boolean getRadioBehavior() {
        return this.radio_behavior;
    }

    public void setRadioBehavior(boolean bl) {
        this.radio_behavior = bl;
        int n = 0;
        while (n < this.boxes.size()) {
            if (!this.getCheckbox((int)n).indicator_set) {
                this.getCheckbox(n).setIndicator(bl ? 2 : 3);
            }
            ++n;
        }
        if (this.radio_behavior) {
            int n2 = 0;
            while (n2 < this.boxes.size()) {
                JCCheckbox jCCheckbox = (JCCheckbox)this.boxes.elementAt(n2);
                if (this.current == jCCheckbox) {
                    jCCheckbox.setState(1);
                } else if (this.current == null && n2 == 0) {
                    this.current = jCCheckbox;
                    jCCheckbox.setState(1);
                } else {
                    jCCheckbox.setState(0);
                }
                ++n2;
            }
            this.repaint();
        }
    }

    public int getValue() {
        if (this.current != null) {
            return this.current.getUserDataInt();
        }
        return -999;
    }

    public boolean setValue(int n) {
        int n2 = 0;
        while (n2 < this.boxes.size()) {
            if (((JCCheckbox)this.boxes.elementAt(n2)).getUserDataInt() == n) {
                this.setCurrent(this.getCheckbox(n2));
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.add(jCItemListener);
        int n = 0;
        while (n < this.boxes.size()) {
            this.getCheckbox(n).addItemListener(jCItemListener);
            ++n;
        }
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        int n = 0;
        while (n < this.boxes.size()) {
            this.getCheckbox(n).removeItemListener(jCItemListener);
            ++n;
        }
        this.itemListeners.removeElement(jCItemListener);
    }

    public int[] getSelected() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.boxes.size()) {
            if (this.getCheckbox((int)n2).state == 1) {
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[n];
        n2 = 0;
        n = 0;
        while (n2 < this.boxes.size()) {
            if (this.getCheckbox((int)n2).state == 1) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        return nArray;
    }

    public void setValue(int[] nArray, int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 >= 0 && n2 < this.boxes.size()) {
            this.setCurrent((JCCheckbox)this.boxes.elementAt(n2));
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.radio_behavior) {
            JCCheckbox jCCheckbox = this.current;
            this.setRadioBehavior(true);
            if (this.current == null) {
                this.setCurrent(this.getCheckbox(0));
                return;
            }
            if (jCCheckbox != this.current && jCCheckbox != null) {
                this.setCurrent(jCCheckbox);
            }
        }
    }
}

