/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.webmacro.engine.Block;
import org.webmacro.engine.Condition;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.SizedStringWriter;
import org.webmacro.util.java2.HashMap;

final class IfDirective
implements Macro {
    private static final boolean _debug = false;
    private final Condition myCondition;
    private final Macro myIfBlock;
    private final Macro myElseBlock;

    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        Object object = null;
        if (parseTool.ttype != -3 && !parseTool.sval.equals("if")) {
            parseTool.pushBack();
            return null;
        }
        parseTool.nextToken();
        parseTool.parseWhitespace();
        if (parseTool.ttype != 40) {
            throw new ParseException(parseTool, "expected a /(/ in IfDirective, got:" + (char)parseTool.ttype);
        }
        Condition condition = Condition.parseCond(parseTool);
        parseTool.parseWhitespace();
        if (parseTool.ttype != 123) {
            throw new ParseException(parseTool, "expected an if Block, got:" + (char)parseTool.ttype);
        }
        Object object2 = Block.parse(parseTool);
        parseTool.parseSpaces();
        parseTool.parseEOL();
        if (parseTool.parseChar('#')) {
            if (parseTool.sval.equals("else")) {
                parseTool.nextToken();
                parseTool.parseWhitespace();
                if (parseTool.ttype != 123) {
                    throw new ParseException(parseTool, "expected a else Block, got:" + (char)parseTool.ttype);
                }
                object = Block.parse(parseTool);
                parseTool.parseSpaces();
                parseTool.parseEOL();
            } else {
                parseTool.pushBack();
            }
        }
        return new IfDirective(condition, object2, object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) throws InvalidContextException {
        try {
            SizedStringWriter sizedStringWriter = new SizedStringWriter(512);
            this.write(sizedStringWriter, object);
            return sizedStringWriter.toString();
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.error("If: evaluate got IO exception on write to StringWriter");
            return "";
        }
    }

    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        if (this.myCondition.test(object)) {
            if (this.myIfBlock != null) {
                this.myIfBlock.write(writer, object);
            } else {
                Engine.log.warning("If: Block for an #if directive was null");
            }
        } else if (this.myElseBlock != null) {
            this.myElseBlock.write(writer, object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        System.out.println("Testing IncludeDirective:");
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        HashMap hashMap = new HashMap();
        hashMap.put("name", "some content");
        hashMap.put("false", Boolean.FALSE);
        hashMap.put("true", Boolean.TRUE);
        String[] stringArray2 = new String[]{"justIf"};
        System.out.println("- - - - - - - - - - - - - - - - -");
        int n = 0;
        while (n < stringArray2.length) {
            File file = new File("examples", stringArray2[n] + ".wm");
            File file2 = new File("examples", stringArray2[n] + ".html");
            System.out.println("TESTING input file: " + file);
            try {
                ParseTool parseTool = new ParseTool(file);
                parseTool.nextToken();
                parseTool.nextToken();
                Block block = (Block)Block.parse(parseTool);
                if (block == null) {
                    System.out.println("FAILED--null returned from parse().");
                } else {
                    FileWriter fileWriter = new FileWriter(file2);
                    block.write(fileWriter, hashMap);
                    ((Writer)fileWriter).close();
                }
            }
            catch (Exception exception) {
                System.out.println("FAILED--threw exception:");
                exception.printStackTrace();
                System.out.println();
            }
            System.out.println("- - - - - - - - - - - - - - - - -");
            ++n;
        }
        System.out.println();
        System.out.println("Done.");
    }

    IfDirective(Condition condition, Object object, Object object2) {
        this.myCondition = condition;
        this.myIfBlock = (Macro)object;
        this.myElseBlock = (Macro)object2;
    }
}

