/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import org.webmacro.engine.Block;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Term;
import org.webmacro.util.InvalidContextException;
import org.webmacro.util.Log;
import org.webmacro.util.SizedStringWriter;
import org.webmacro.util.java2.HashMap;

class IncludeDirective
implements Macro {
    private final Object fileName;
    private final boolean parse;

    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        boolean bl;
        if (parseTool.ttype != -3) {
            return null;
        }
        if (parseTool.sval.equals("include")) {
            bl = false;
        } else if (parseTool.sval.equals("parse")) {
            bl = true;
        } else {
            return null;
        }
        parseTool.nextToken();
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "Parsing include, expected spaces after keyword, but got:" + (char)parseTool.ttype + " (spaces should separate directive from filename)");
        }
        Object object = Term.parse(parseTool);
        if (object == null) {
            throw new ParseException(parseTool, "Parsing include directive, expected filename term" + " but what followed was not a term....");
        }
        parseTool.parseSpaces();
        if (parseTool.ttype != 10 && parseTool.ttype != -1) {
            throw new ParseException(parseTool, "Parsing include directive. Got junk after directive:" + (char)parseTool.ttype + " (nothing should follow on the same line)");
        }
        return new IncludeDirective(object, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object evaluate(Object object) throws InvalidContextException {
        try {
            SizedStringWriter sizedStringWriter = new SizedStringWriter(512);
            this.write(sizedStringWriter, object);
            return sizedStringWriter.toString();
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.warning("Include: evaluate got IO exception on write to StringWriter");
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void write(Writer writer, Object object) throws InvalidContextException, IOException {
        if (this.fileName == null) {
            Engine.log.error("Include: attempt to write with null filename");
            return;
        }
        String string = this.fileName instanceof Macro ? ((Macro)this.fileName).evaluate(object).toString() : this.fileName.toString();
        try {
            FileReader fileReader = new FileReader(string);
            if (this.parse) {
                ParseTool parseTool = new ParseTool(string, fileReader);
                try {
                    parseTool.nextToken();
                    Block block = (Block)Block.parse(parseTool);
                    block.write(writer, object);
                    return;
                }
                catch (InvalidContextException invalidContextException) {
                    String string2 = "Block.parse did not return a Block!";
                    Engine.log.exception(invalidContextException);
                    Engine.log.error("Include: " + string2);
                    writer.write("<!--\nERROR: " + string2 + " \n-->");
                    return;
                }
            }
            char[] cArray = new char[2048];
            while (true) {
                int n;
                if ((n = fileReader.read(cArray)) <= 0) {
                    return;
                }
                writer.write(cArray, 0, n);
            }
        }
        catch (ParseException parseException) {
            Engine.log.exception(parseException);
            String string3 = "Include: file " + this.fileName + " did not parse!";
            Engine.log.warning(string3);
            writer.write("<!--\nWARNING: " + string3 + " \n-->");
            return;
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            String string4 = "Include: Error reading file " + string;
            Engine.log.warning(string4);
            writer.write("<!--\nWARNING: " + string4 + " \n-->");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        System.out.println("Testing IncludeDirective:");
        Log.setLevel(Log.DEBUG);
        Log.traceExceptions(true);
        HashMap hashMap = new HashMap();
        hashMap.put("file", "include.txt");
        hashMap.put("fsfile", "examples/include.txt");
        hashMap.put("hello", "contents of hello variable");
        String[] stringArray2 = new String[]{"include \"examples/include.txt\"", "parse \"examples/$file\"", "parse $fsfile", "include examples/ttword"};
        System.out.println("- - - - - - - - - - - - - - - - -");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("TESTING: " + stringArray2[n] + " :");
            try {
                ParseTool parseTool = new ParseTool("string", new StringReader(stringArray2[n]));
                parseTool.nextToken();
                IncludeDirective includeDirective = (IncludeDirective)IncludeDirective.parse(parseTool);
                if (includeDirective == null) {
                    System.out.println("FAILED--null returned from parse().");
                } else {
                    String string = includeDirective.evaluate(hashMap).toString();
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                System.out.println("FAILED--threw exception:");
                exception.printStackTrace();
                System.out.println();
            }
            System.out.println("- - - - - - - - - - - - - - - - -");
            ++n;
        }
        System.out.println();
        System.out.println("Done.");
    }

    IncludeDirective(Object object, boolean bl) {
        this.fileName = object;
        this.parse = bl;
    }
}

