/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.webmacro.broker.Config;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceRevokedException;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.resource.User;
import org.webmacro.resource.UserException;
import org.webmacro.resource.UserImpl;
import org.webmacro.util.InitException;
import org.webmacro.util.InvalidArgumentException;
import org.webmacro.util.Log;

public class UserProvider
implements ResourceProvider {
    public static final String TYPE = "user";
    static final boolean debug_ = false;
    static final Log log_ = new Log("user", "User and User Databsae Events");
    private static final String[] types_;
    private File _userdb;
    private Hashtable _users = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(ResourceBroker resourceBroker) throws InitException {
        String string;
        try {
            string = (String)resourceBroker.getValue("config", "UserFile");
        }
        catch (Exception exception) {
            log_.exception(exception);
            throw new InitException("Could not find my config info");
        }
        try {
            this._userdb = new File(string);
            if (this._userdb.exists()) return;
            this._users = new Hashtable();
            this.save();
            return;
        }
        catch (Exception exception) {
            log_.exception(exception);
            throw new InitException("Could not read my user file: " + string);
        }
    }

    public final int resourceThreads() {
        return 0;
    }

    public final int resourceExpireTime() {
        return 60000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void resourceRequest(RequestResourceEvent requestResourceEvent) {
        try {
            requestResourceEvent.set(this.get(requestResourceEvent.getName()));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void resourceCreate(CreateResourceEvent createResourceEvent) throws ResourceUnavailableException {
        try {
            User user;
            if (this._users == null) {
                try {
                    this.load();
                }
                catch (Exception exception) {
                    log_.exception(exception);
                    log_.error("Could not load user database:" + this);
                }
            }
            if ((user = (User)this._users.get(createResourceEvent.getName())) != null) {
                throw new UserException("User already exists: " + user);
            }
            String string = createResourceEvent.getName();
            String string2 = createResourceEvent.getArgument() != null ? createResourceEvent.getArgument().toString() : null;
            user = new UserImpl(string, string2);
            this._users.put(string, user);
            createResourceEvent.set(user);
            return;
        }
        catch (UserException userException) {
            throw new ResourceUnavailableException("User already exists");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            return;
        }
        catch (ResourceRevokedException resourceRevokedException) {
            try {
                this.remove(createResourceEvent.getName());
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized boolean resourceSave(ResourceEvent resourceEvent) {
        try {
            if (this._users.get(resourceEvent.getName()) != null) {
                this._users.put(resourceEvent.getName(), resourceEvent.getValue());
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final synchronized boolean resourceDelete(ResourceEvent resourceEvent) {
        return this.remove(resourceEvent.getName()) != null;
    }

    public final synchronized String[] getTypes() {
        return types_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void destroy() {
        try {
            this.save();
            return;
        }
        catch (Exception exception) {
            log_.exception(exception);
            log_.error("Unable to save user database");
        }
    }

    public final String toString() {
        return this._userdb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final User get(String string) {
        if (this._users != null) return (User)this._users.get(string);
        try {
            this.load();
            return (User)this._users.get(string);
        }
        catch (Exception exception) {
            log_.exception(exception);
            log_.error("Could not load user database:" + this);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Enumeration elements() {
        try {
            if (this._users != null) return this._users.elements();
            this.load();
            return this._users.elements();
        }
        catch (Exception exception) {
            log_.exception(exception);
            log_.error("Could not load user database:" + this);
        }
        return this._users.elements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final User remove(String string) {
        if (this._users == null) {
            try {
                this.load();
            }
            catch (Exception exception) {
                log_.exception(exception);
                log_.error("remove could not load user database:" + this);
            }
        }
        User user = (User)this._users.remove(string);
        try {
            this.save();
            return user;
        }
        catch (Exception exception) {
            log_.exception(exception);
            log_.error("Could not save user database:" + this);
        }
        return user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void save() {
        if (this._users == null) {
            return;
        }
        File file = null;
        try {
            file = new File(this._userdb.getName() + "-tmp" + Config.getUniqueString());
            FileOutputStream fileOutputStream = new FileOutputStream(file.getName(), false);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Hashtable hashtable = this._users;
            synchronized (hashtable) {
                objectOutputStream.writeObject(this._users);
            }
            objectOutputStream.close();
            file.renameTo(this._userdb);
            return;
        }
        catch (IOException iOException) {
            log_.exception(iOException);
            log_.error("Unable to save UserProvider, removing tempfile");
            if (file == null) return;
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void load() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this._userdb);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        try {
            Hashtable hashtable;
            this._users = hashtable = (Hashtable)objectInputStream.readObject();
            if (this._users == null) {
                log_.warning("Could not read user database");
            }
        }
        catch (Exception exception) {
            throw new IOException(fileInputStream + " has an invalid format.");
        }
        objectInputStream.close();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] var0) {
        block13: {
            System.out.println("Type commands of the format:");
            System.out.println("   add user password");
            System.out.println("   check user password");
            System.out.println("   remove user");
            System.out.println("   list");
            Log.setLevel(Log.ALL);
            Log.traceExceptions(true);
            try {
                var1_1 = new ResourceBroker();
                var1_1.join(new Config());
                var2_3 = new UserProvider();
                var1_1.join(var2_3);
                var6_4 = new BufferedReader(new InputStreamReader(System.in));
lbl14:
                // 2 sources

                block4: while (true) {
                    if ((var3_5 = var6_4.readLine()) == null) {
                        System.out.println("Shutting down....");
                        var1_1.shutdown();
                        System.out.println("--Done--");
                        return;
                    }
                    var4_6 = new StringTokenizer(var3_5);
                    var5_7 = new Vector<String>();
                    while (true) {
                        if (!var4_6.hasMoreTokens()) {
                            var7_8 = new String[var5_7.size()];
                            var5_7.copyInto(var7_8);
                            if (var7_8.length >= 1) break;
                            System.out.println("Commands: add, check, remove, list");
                            continue block4;
                        }
                        var5_7.addElement(var4_6.nextToken());
                    }
                    try {
                        block14: {
                            if (var7_8[0].equals("add")) {
                                var8_9 = var7_8[1];
                                var9_11 = var7_8[2];
                                var10_12 = var1_1.create("user", (String)var8_9);
                                var11_13 = (User)var10_12.getValue();
                                var11_13.setPassword((String)var9_11);
                                System.out.println((String)var8_9 + " added");
                                break block13;
                            }
                            if (var7_8[0].equals("check")) {
                                var8_9 = var7_8[1];
                                var9_11 = var7_8[2];
                                var10_12 = (User)var1_1.getValue("user", (String)var8_9);
                                System.out.println((String)var8_9 + " authenticated: " + var10_12.authenticate((String)var9_11));
                                break block13;
                            }
                            if (var7_8[0].equals("remove")) {
                                var8_9 = var1_1.get("user");
                                var9_11 = var7_8[1];
                                var8_9.remove((String)var9_11);
                                System.out.println((String)var9_11 + " removed");
                                break block13;
                            }
                            if (!var7_8[0].equals("list")) break block14;
                            var8_9 = var2_3.elements();
                            if (true) ** GOTO lbl73
                        }
                        if (var7_8[0].equals("show")) {
                            var8_9 = var7_8[1];
                            var9_11 = (User)var1_1.getValue("user", (String)var8_9);
                            System.out.println(var9_11);
                            break block13;
                        }
                        System.out.println("I don't understand " + (String)var7_8[0]);
                    }
                    catch (Exception var8_10) {
                        var8_10.printStackTrace();
                    }
                    break block13;
                    break;
                }
            }
            catch (Exception var1_2) {
                var1_2.printStackTrace();
            }
            return;
            do {
                System.out.println(var8_9.nextElement());
lbl73:
                // 2 sources

            } while (var8_9.hasMoreElements());
        }
        Thread.sleep(500L);
        ** while (true)
    }

    static {
        Log.setLevel(Log.DEBUG);
        types_ = new String[]{TYPE};
    }
}

