/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputListener;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.Interface.OutputListener;
import X10Gimli.System.Packet.ConnectionPacket;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueNumber;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;

public class UDPGateway
extends InputOutputGateway
implements Runnable,
InputListener,
OutputListener {
    private DatagramSocket dsInput;
    private DatagramSocket dsOutput;
    private DatagramPacket dpInput;
    private Vector outputAddresses;
    private int inputPort;

    public UDPGateway() {
        this.sSource = "UDP";
        this.outputAddresses = new Vector();
    }

    public boolean initialize(Value portname) {
        if (portname instanceof ValueNumber) {
            int portreceive = portname.getNumber();
            try {
                this.dsInput = new DatagramSocket(portreceive, InetAddress.getLocalHost());
                this.dsOutput = new DatagramSocket();
                this.dpInput = new DatagramPacket(new byte[1024], 1024);
            }
            catch (Exception e) {
                Debug.printCallStack("Exception in UDP initialization.", e);
                Debug.log(1, "\"Failed to activated UDP gateway.\"");
                boolean bl = false;
                return bl;
            }
            this.inputPort = portreceive;
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Successfully activated UDP gateway on port ").append(portname.getNumber()).append(".\""))));
            return true;
        }
        Debug.error(100, "\"Numerical port value required to activate UDP.\"");
        return false;
    }

    public void connect(InetAddress i, int port) {
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Connecting to ").append(i.getHostAddress()).append(":").append(port).append("...\""))));
        ConnectionPacket c = new ConnectionPacket(new ValueIdent("LISTEN_REQUEST"), new ValueNumber(this.inputPort));
        AddressPort address = new AddressPort(this, i, port);
        this.addOutputAddress(address);
        DatagramPacket p = new DatagramPacket(c.getBytes(), c.getBytes().length, address.addr, address.port);
        try {
            this.dsOutput.send(p);
        }
        catch (Exception e) {
            Debug.printCallStack("Exception in UDP connect.", e);
        }
    }

    public void outputConnect(InetAddress i, int port) {
        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Adding non-connected send destination of ").append(i.getHostAddress()).append(":").append(port).append("...\""))));
        AddressPort address = new AddressPort(this, i, port);
        this.addOutputAddress(address);
    }

    private static String localAddress() {
        try {
            String string = InetAddress.getLocalHost().getHostAddress();
            return string;
        }
        catch (Exception e) {
            Debug.printCallStack("Exception getting local host name.", e);
            return null;
        }
    }

    private int getPort() {
        return this.dsInput.getLocalPort();
    }

    private InetAddress getAddress() {
        return this.dsInput.getLocalAddress();
    }

    private AddressPort getAddressPort() {
        return new AddressPort(this, this.getAddress(), this.getPort());
    }

    private synchronized void addOutputAddress(InetAddress addr, int port) {
        this.addOutputAddress(new AddressPort(this, addr, port));
    }

    private AddressPort findOutputAddress(AddressPort a) {
        for (int i = 0; i < this.outputAddresses.size(); ++i) {
            AddressPort b = (AddressPort)this.outputAddresses.elementAt(i);
            if (!b.addr.getHostAddress().equals(a.addr.getHostAddress()) || b.port != a.port) continue;
            return b;
        }
        return null;
    }

    private synchronized void addOutputAddress(AddressPort a) {
        if (this.findOutputAddress(a) != null) {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Connection to ").append(a.addr.getHostAddress()).append(":").append(a.port).append(" already exists.\""))));
            return;
        }
        if (!this.outputAddresses.contains(a)) {
            this.outputAddresses.addElement(a);
        }
    }

    private void verifyConnections() {
        int cnt = this.outputAddresses.size();
        for (int i = 0; i < cnt; ++i) {
            AddressPort address = (AddressPort)this.outputAddresses.elementAt(i);
            ConnectionPacket packet = new ConnectionPacket(new ValueIdent("STATUS_REQUEST"), new ValueNumber(this.inputPort));
            DatagramPacket p = new DatagramPacket(packet.getBytes(), packet.getBytes().length, address.addr, address.port);
            if (!address.verifyConfirm) {
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Timeout waiting for response.  Dropping connection to ").append(address.addr.getHostAddress()).append(":").append(address.port).append("...\""))));
                this.outputAddresses.removeElement(address);
                ConnectionPacket newpacket = new ConnectionPacket(new ValueIdent("DISCONNECT"), null);
                this.inputReceived(newpacket);
                continue;
            }
            address.verifyConfirm = false;
            try {
                this.dsOutput.send(p);
            }
            catch (Exception e) {
                Debug.printCallStack("Exception verifying connections.", e);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                Debug.printCallStack("Exception sleeping while verifying connections.", e);
            }
        }
    }

    public void run() {
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"UDP listener thread started.\"");
                while (true) {
                    try {
                        while (true) {
                            UDPGateway.this.dpInput = new DatagramPacket(new byte[1024], 1024);
                            UDPGateway.this.dsInput.receive(UDPGateway.this.dpInput);
                            Packet pack = new Packet(UDPGateway.this.dpInput.getData()).getPacketType();
                            if (pack instanceof ConnectionPacket) {
                                ConnectionPacket packet = (ConnectionPacket)pack;
                                try {
                                    AddressPort a;
                                    if (packet.getCommand().getValueString().equals("LISTEN_REQUEST")) {
                                        Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Adding UDP destination at ").append(UDPGateway.this.dpInput.getAddress().getHostAddress()).append(":").append(packet.getExtra().getNumber()).append("...\""))));
                                        UDPGateway.this.addOutputAddress(new AddressPort(UDPGateway.this, UDPGateway.this.dpInput.getAddress(), packet.getExtra().getNumber()));
                                        continue;
                                    }
                                    if (packet.getCommand().getValueString().equals("KEEPALIVE_REQUEST")) {
                                        a = UDPGateway.this.findOutputAddress(new AddressPort(UDPGateway.this, UDPGateway.this.dpInput.getAddress(), packet.getExtra().getNumber()));
                                        if (a != null) {
                                            a.verifyConfirm = true;
                                            continue;
                                        }
                                        UDPGateway.this.addOutputAddress(new AddressPort(UDPGateway.this, UDPGateway.this.dpInput.getAddress(), packet.getExtra().getNumber()));
                                        continue;
                                    }
                                    if (packet.getCommand().getValueString().equals("STATUS_REQUEST")) {
                                        ConnectionPacket c = new ConnectionPacket(new ValueIdent("STATUS_RESPONSE"), new ValueNumber(UDPGateway.this.inputPort));
                                        c.packData();
                                        AddressPort address = new AddressPort(UDPGateway.this, UDPGateway.this.dpInput.getAddress(), packet.getExtra().getNumber());
                                        DatagramPacket p = new DatagramPacket(c.getBytes(), c.getBytes().length, address.addr, address.port);
                                        try {
                                            UDPGateway.this.dsOutput.send(p);
                                        }
                                        catch (Exception e) {
                                            Debug.printCallStack("Exception sending UDP response packet.", e);
                                        }
                                        continue;
                                    }
                                    if (!packet.getCommand().getValueString().equals("STATUS_RESPONSE") || (a = UDPGateway.this.findOutputAddress(new AddressPort(UDPGateway.this, UDPGateway.this.dpInput.getAddress(), packet.getExtra().getNumber()))) == null) continue;
                                    a.verifyConfirm = true;
                                }
                                catch (Exception e) {
                                    Debug.printCallStack("Exception in UDP.", e);
                                }
                                continue;
                            }
                            UDPGateway.this.inputReceived(pack);
                        }
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Exception in UDP.", e);
                        continue;
                    }
                    break;
                }
            }
        });
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, "\"UDP keep-alive thread started.\"");
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Exception in UDP keep-alive thread.", e);
                    }
                    UDPGateway.this.verifyConnections();
                }
            }
        });
        t1.start();
        t2.start();
    }

    public void sendPacket(Packet packet) {
        packet.packData();
        if (packet.getType().equals("CONNECTION") && packet.getValue("COMMAND").getValueString().equals("DISCONNECT")) {
            if (packet.getValue("EXTRA") != null) {
                String address = packet.getValue("EXTRA").getValueString();
                for (int i = 0; i < this.outputAddresses.size(); ++i) {
                    if (!this.outputAddresses.elementAt(i).toString().equals(address)) continue;
                    AddressPort addr = (AddressPort)this.outputAddresses.elementAt(i);
                    this.outputAddresses.removeElementAt(i);
                    ConnectionPacket newpacket = new ConnectionPacket(new ValueIdent("DISCONNECT"), null);
                    this.inputReceived(newpacket);
                    return;
                }
            } else {
                this.outputAddresses = new Vector();
                ConnectionPacket newpacket = new ConnectionPacket(new ValueIdent("DISCONNECT"), null);
                this.inputReceived(newpacket);
            }
            return;
        }
        int cnt = this.outputAddresses.size();
        for (int i = 0; i < cnt; ++i) {
            AddressPort address = (AddressPort)this.outputAddresses.elementAt(i);
            DatagramPacket p = new DatagramPacket(packet.getBytes(), packet.getBytes().length, address.addr, address.port);
            try {
                this.dsOutput.send(p);
                continue;
            }
            catch (Exception e) {
                Debug.printCallStack("Exception sending UDP packet.", e);
            }
        }
    }

    public void receivePacket(Packet packet) {
        this.transmitPacket(packet);
    }

    public boolean isDestination(Packet p) {
        return true;
    }

    public class AddressPort {
        InetAddress addr;
        int port;
        boolean verifyConfirm = true;

        public AddressPort(UDPGateway this$0, InetAddress i, int p) {
            this.addr = i;
            this.port = p;
        }

        public String toString() {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.addr.getHostAddress()))).append(":").append(this.port)));
        }
    }
}

