/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface;

import X10Gimli.Debug;
import X10Gimli.Interface.BasicGateway;
import X10Gimli.Interface.InputListener;
import X10Gimli.System.Packet.Packet;
import X10Gimli.X10.X10Queue;
import java.util.Vector;

public abstract class InputGateway
extends BasicGateway {
    private Vector inputListeners = new Vector();
    protected X10Queue iQueue = new X10Queue(10);

    public synchronized void addInputListener(InputListener l) {
        if (!this.inputListeners.contains(l)) {
            this.inputListeners.addElement(l);
        }
    }

    public synchronized void removeInputListener(InputListener l) {
        if (this.inputListeners != null) {
            this.inputListeners.removeElement(l);
        }
    }

    protected void inputReceived(Packet p) {
        this.iQueue.put(p);
    }

    private void firePacket(Packet packet) {
        if (this.isDestination(packet)) {
            Vector v = null;
            InputGateway inputGateway = this;
            synchronized (inputGateway) {
                if (this.inputListeners != null) {
                    v = (Vector)this.inputListeners.clone();
                }
            }
            if (v != null) {
                int cnt = v.size();
                for (int i = 0; i < cnt; ++i) {
                    InputListener client = (InputListener)v.elementAt(i);
                    client.receivePacket(packet);
                }
            }
        }
    }

    protected void startQueueThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"").append(InputGateway.this.getName()).append(" queue handler thread started.\""))));
                while (InputGateway.this.iQueue == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        Debug.printCallStack("Interrupted sleep in input queue handler thread.", e);
                    }
                }
                while (true) {
                    Packet p = (Packet)InputGateway.this.iQueue.get();
                    InputGateway.this.firePacket(p);
                }
            }
        });
        t.start();
    }
}

