/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System.Packet;

import X10Gimli.Debug;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueBoolean;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueTime;
import X10Gimli.Value.ValueX10;
import java.util.ArrayList;
import java.util.Calendar;

public class Packet {
    public static final byte FLAG_RETURN = 1;
    private static final byte TYPE_BOOLEAN = 1;
    private static final byte TYPE_COMMAND = 2;
    private static final byte TYPE_DATE = 3;
    private static final byte TYPE_DAY = 4;
    private static final byte TYPE_IDENT = 5;
    private static final byte TYPE_MONTH = 6;
    private static final byte TYPE_NUMBER = 7;
    private static final byte TYPE_STRING = 8;
    private static final byte TYPE_TIME = 9;
    private static final byte TYPE_X10 = 10;
    private static int iCount;
    private byte[] bData;
    private ArrayList vTags;
    private ArrayList vValues;
    private byte bFlags;
    private int iReserved;
    private int iID;
    private short sLength;
    private String sType = "";
    private String sSource = "";
    private String sDest = "";
    private boolean bPacked = false;
    private boolean bUnpacked = false;
    private StringBuffer sbuf = new StringBuffer(50);

    public Packet() {
        this.vTags = new ArrayList();
        this.vValues = new ArrayList();
        this.bPacked = false;
        this.bUnpacked = true;
    }

    public Packet(ArrayList tags, ArrayList values) {
        this.bUnpacked = true;
        this.bPacked = false;
        this.setTags(tags);
        this.setValues(values);
    }

    public Packet(byte[] data) {
        this.setBytes(data);
    }

    public synchronized void setFlags(byte flags) {
        if (this.bUnpacked) {
            this.bFlags = flags;
        }
        if (this.bPacked) {
            this.setByte(9, flags);
        }
    }

    public synchronized void setReserved(int reserved) {
        if (this.bUnpacked) {
            this.iReserved = reserved;
        }
        if (this.bPacked) {
            this.setInt(10, reserved);
        }
    }

    public synchronized void setID(int id) {
        if (this.bUnpacked) {
            this.iID = id;
        }
        if (this.bPacked) {
            this.setInt(14, id);
        }
    }

    private void setLength(short length) {
        if (this.bUnpacked) {
            this.sLength = length;
        }
    }

    public synchronized void setType(String type) {
        if (type != null) {
            if (this.bUnpacked) {
                this.sType = type.intern();
            }
            if (this.bPacked) {
                this.setString(20, 20, type);
            }
        }
    }

    public synchronized void setSource(String source) {
        if (source != null) {
            if (this.bUnpacked) {
                this.sSource = source.intern();
            }
            if (this.bPacked) {
                this.setString(40, 20, source);
            }
        }
    }

    public synchronized void setDest(String dest) {
        if (dest != null) {
            if (this.bUnpacked) {
                this.sDest = dest.intern();
            }
            if (this.bPacked) {
                this.setString(60, 20, dest);
            }
        }
    }

    public synchronized byte getFlags() {
        this.unpackData();
        return this.bFlags;
    }

    public synchronized int getReserved() {
        this.unpackData();
        return this.iReserved;
    }

    public synchronized int getID() {
        this.unpackData();
        return this.iID;
    }

    public synchronized short getLength() {
        this.unpackData();
        return this.sLength;
    }

    public synchronized String getType() {
        this.unpackData();
        return this.sType;
    }

    public synchronized String getSource() {
        this.unpackData();
        return this.sSource;
    }

    public synchronized String getDest() {
        this.unpackData();
        return this.sDest;
    }

    public synchronized void addSegment(String tag, Value value) {
        if (tag != null && value != null) {
            this.unpackData();
            this.bPacked = false;
            tag = tag.toUpperCase().intern();
            this.vTags.add(tag);
            this.vValues.add(value);
        }
    }

    public synchronized void setSegment(String tag, Value value) {
        if (tag != null && value != null) {
            this.unpackData();
            this.bPacked = false;
            int idx = this.findValue(tag);
            if (idx != -1) {
                this.vValues.set(idx, value);
            } else {
                this.addSegment(tag, value);
            }
        }
    }

    public synchronized void setTags(ArrayList tags) {
        this.unpackData();
        this.vTags = tags;
        this.bPacked = false;
    }

    public synchronized void setValues(ArrayList values) {
        this.unpackData();
        this.vValues = values;
        this.bPacked = false;
    }

    public synchronized void setBytes(byte[] data) {
        this.bData = data;
        this.bPacked = true;
        this.bUnpacked = false;
        short size = this.getSize();
        this.bData = new byte[size];
        System.arraycopy(data, 0, this.bData, 0, size);
    }

    public synchronized ArrayList getTags() {
        this.unpackData();
        return this.vTags;
    }

    public synchronized ArrayList getValues() {
        this.unpackData();
        return this.vValues;
    }

    public synchronized byte[] getBytes() {
        this.packData();
        return this.bData;
    }

    public synchronized Value getValue(int i) {
        this.unpackData();
        return (Value)this.vValues.get(i);
    }

    public synchronized int findValue(String tag) {
        this.unpackData();
        if (tag != null) {
            tag = tag.toUpperCase();
        }
        if (this.vTags != null && this.vValues != null) {
            for (int i = 0; i < this.vTags.size(); ++i) {
                if (!((String)this.vTags.get(i)).equals(tag)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized Value getValue(String tag) {
        int idx = this.findValue(tag);
        if (idx != -1) {
            return (Value)this.vValues.get(idx);
        }
        return null;
    }

    private int calcLength() {
        this.unpackData();
        int length = 81;
        if (this.vValues != null && this.vTags != null) {
            int i;
            length += this.vTags.size();
            for (i = 0; i < this.vTags.size(); ++i) {
                length += ((String)this.vTags.get(i)).length() + 1;
            }
            for (i = 0; i < this.vValues.size(); ++i) {
                Object o = this.vValues.get(i);
                if (o instanceof ValueBoolean) {
                    ++length;
                }
                if (o instanceof ValueCommand) {
                    ++length;
                }
                if (o instanceof ValueDate) {
                    length += 4;
                }
                if (o instanceof ValueDay) {
                    ++length;
                }
                if (o instanceof ValueIdent) {
                    length += ((ValueIdent)o).getValueString().length() + 1;
                }
                if (o instanceof ValueMonth) {
                    ++length;
                }
                if (o instanceof ValueNumber) {
                    length += 4;
                }
                if (o instanceof ValueString) {
                    length += ((ValueString)o).getValueString().length() + 1;
                }
                if (o instanceof ValueTime) {
                    length += 3;
                }
                if (!(o instanceof ValueX10)) continue;
                length += 2;
            }
        }
        return length;
    }

    private void setHeader() {
        this.bData[0] = 88;
        this.bData[1] = 49;
        this.bData[2] = 48;
        this.bData[3] = 71;
        this.bData[4] = 73;
        this.bData[5] = 77;
        this.bData[6] = 76;
        this.bData[7] = 73;
        this.bData[8] = 1;
    }

    private boolean getHeader() {
        if (this.bData[0] != 88) {
            return false;
        }
        if (this.bData[1] != 49) {
            return false;
        }
        if (this.bData[2] != 48) {
            return false;
        }
        if (this.bData[3] != 71) {
            return false;
        }
        if (this.bData[4] != 73) {
            return false;
        }
        if (this.bData[5] != 77) {
            return false;
        }
        if (this.bData[6] != 76) {
            return false;
        }
        if (this.bData[7] != 73) {
            return false;
        }
        return this.bData[8] == 1;
    }

    private int packSegment(int i, String tag, Value segment) {
        try {
            if (tag != null) {
                tag = tag.toUpperCase();
            }
            this.setString(i + 1, tag.length() + 1, tag);
            if (segment instanceof ValueBoolean) {
                this.setByte(i, (byte)1);
                this.setByte(i + 1 + tag.length() + 1, (byte)(segment.getBoolean() ? 1 : 0));
                int n = i + 1 + tag.length() + 1 + 1;
                return n;
            }
            if (segment instanceof ValueCommand) {
                this.setByte(i, (byte)2);
                this.setByte(i + 1 + tag.length() + 1, (byte)segment.getCommand());
                int n = i + 1 + tag.length() + 1 + 1;
                return n;
            }
            if (segment instanceof ValueDate) {
                this.setByte(i, (byte)3);
                Calendar c = segment.getDate();
                this.setByte(i + 1 + tag.length() + 1, (byte)c.get(5));
                this.setByte(i + 1 + tag.length() + 1 + 1, (byte)c.get(2));
                this.setShort(i + 1 + tag.length() + 1 + 2, (short)c.get(1));
                int n = i + 1 + tag.length() + 1 + 4;
                return n;
            }
            if (segment instanceof ValueDay) {
                this.setByte(i, (byte)4);
                this.setByte(i + 1 + tag.length() + 1, (byte)segment.getDay());
                int c = i + 1 + tag.length() + 1 + 1;
                return c;
            }
            if (segment instanceof ValueIdent) {
                this.setByte(i, (byte)5);
                this.setString(i + 1 + tag.length() + 1, segment.getValueString().length() + 1, segment.getValueString());
                int c = i + 1 + tag.length() + 1 + segment.getValueString().length() + 1;
                return c;
            }
            if (segment instanceof ValueMonth) {
                this.setByte(i, (byte)6);
                this.setByte(i + 1 + tag.length() + 1, (byte)segment.getMonth());
                int c = i + 1 + tag.length() + 1 + 1;
                return c;
            }
            if (segment instanceof ValueNumber) {
                this.setByte(i, (byte)7);
                this.setInt(i + 1 + tag.length() + 1, segment.getNumber());
                int c = i + 1 + tag.length() + 1 + 4;
                return c;
            }
            if (segment instanceof ValueString) {
                this.setByte(i, (byte)8);
                this.setString(i + 1 + tag.length() + 1, segment.getValueString().length() + 1, segment.getValueString());
                int c = i + 1 + tag.length() + 1 + segment.getValueString().length() + 1;
                return c;
            }
            if (segment instanceof ValueTime) {
                this.setByte(i, (byte)9);
                Calendar c = segment.getTime();
                this.setByte(i + 1 + tag.length() + 1, (byte)c.get(11));
                this.setByte(i + 1 + tag.length() + 1 + 1, (byte)c.get(12));
                this.setByte(i + 1 + tag.length() + 1 + 2, (byte)c.get(13));
                int n = i + 1 + tag.length() + 1 + 3;
                return n;
            }
            if (segment instanceof ValueX10) {
                this.setByte(i, (byte)10);
                this.setChar(i + 1 + tag.length() + 1, segment.getHouseCode());
                this.setByte(i + 1 + tag.length() + 1 + 1, (byte)segment.getDeviceCode());
                int c = i + 1 + tag.length() + 1 + 2;
                return c;
            }
        }
        catch (Exception e) {
            Debug.printCallStack("Problem packing segment of packet.", e);
        }
        return 0;
    }

    private int unpackSegment(int i) {
        try {
            byte type = this.getByte(i);
            String tag = this.getString(i + 1);
            Value val = null;
            int length = 1 + tag.length() + 1;
            switch (type) {
                case 1: {
                    if (this.getByte(i + length) == 0) {
                        val = new ValueBoolean(false);
                    }
                    if (this.getByte(i + length) == 1) {
                        val = new ValueBoolean(true);
                    }
                    ++length;
                    break;
                }
                case 2: {
                    val = new ValueCommand(this.getByte(i + length));
                    ++length;
                    break;
                }
                case 3: {
                    Calendar d = Calendar.getInstance();
                    d.set(5, this.getByte(i + length));
                    d.set(2, this.getByte(i + length + 1));
                    d.set(1, this.getShort(i + length + 2));
                    val = new ValueDate(d);
                    length += 4;
                    break;
                }
                case 4: {
                    val = new ValueDay(this.getByte(i + length));
                    ++length;
                    break;
                }
                case 5: {
                    val = new ValueIdent(this.getString(i + length));
                    length += val.getValueString().length() + 1;
                    break;
                }
                case 6: {
                    val = new ValueMonth(this.getByte(i + length));
                    ++length;
                    break;
                }
                case 7: {
                    val = new ValueNumber(this.getInt(i + length));
                    length += 4;
                    break;
                }
                case 8: {
                    val = new ValueString(this.getString(i + length));
                    length += val.getValueString().length() + 1;
                    break;
                }
                case 9: {
                    Calendar t = Calendar.getInstance();
                    t.set(11, this.getByte(i + length));
                    t.set(12, this.getByte(i + length + 1));
                    t.set(13, this.getByte(i + length + 2));
                    val = new ValueTime(t);
                    length += 3;
                    break;
                }
                case 10: {
                    val = new ValueX10(this.getChar(i + length), this.getByte(i + length + 1));
                    length += 2;
                    break;
                }
            }
            this.vTags.add(tag);
            this.vValues.add(val);
            int n = i + length;
            return n;
        }
        catch (Exception e) {
            Debug.printCallStack("Problem unpacking segment of packet.", e);
            return i;
        }
    }

    private void setByte(int i, byte b) {
        this.bData[i] = b;
    }

    private void setChar(int i, char c) {
        this.bData[i] = (byte)c;
    }

    private void setShort(int i, short s) {
        this.bData[i] = (byte)(s >>> 8 & 0xFF);
        this.bData[i + 1] = (byte)(s & 0xFF);
    }

    private void setInt(int i, int s) {
        this.bData[i] = (byte)(s >>> 24 & 0xFF);
        this.bData[i + 1] = (byte)(s >>> 16 & 0xFF);
        this.bData[i + 2] = (byte)(s >>> 8 & 0xFF);
        this.bData[i + 3] = (byte)(s & 0xFF);
    }

    private void setString(int i, int l, String s) {
        int length = 0;
        if (s != null) {
            length = s.length();
            if (length > l) {
                System.arraycopy(s.getBytes(), 0, this.bData, i, l - 1);
                this.setChar(i + l - 1, '\u0000');
            } else {
                System.arraycopy(s.getBytes(), 0, this.bData, i, length);
                this.setChar(i + length, '\u0000');
            }
        }
    }

    private byte getByte(int i) {
        return this.bData[i];
    }

    private char getChar(int i) {
        return (char)(this.bData[i] & 0xFF);
    }

    private short getShort(int i) {
        return (short)((this.bData[i] & 0xFF) << 8 | this.bData[i + 1] & 0xFF);
    }

    private int getInt(int i) {
        return (this.bData[i] & 0xFF) << 24 | (this.bData[i + 1] & 0xFF) << 16 | (this.bData[i + 2] & 0xFF) << 8 | this.bData[i + 3] & 0xFF;
    }

    private String getString(int i) {
        this.sbuf.setLength(0);
        int j = 0;
        while (this.getChar(i + j) != '\u0000') {
            char c = this.getChar(j + i);
            if (c != '\u0000') {
                this.sbuf.append(c);
            }
            ++j;
        }
        return this.sbuf.toString().intern();
    }

    public synchronized void packData() {
        if (this.bUnpacked && !this.bPacked) {
            if (this.iID == 0) {
                this.setID(iCount);
                ++iCount;
            }
            this.setLength((short)this.calcLength());
            this.bData = new byte[this.sLength];
            this.setHeader();
            this.setByte(9, this.bFlags);
            this.setInt(10, this.iReserved);
            this.setInt(14, this.iID);
            this.setShort(18, this.sLength);
            this.setString(20, 20, this.sType);
            this.setString(40, 20, this.sSource);
            this.setString(60, 20, this.sDest);
            if (this.vValues != null && this.vTags != null) {
                int size = this.vValues.size();
                if (size != this.vTags.size()) {
                    Debug.error("Packet has unequal number of tags and values.");
                    if (this.vTags.size() < size) {
                        size = this.vTags.size();
                    }
                }
                this.setByte(80, (byte)size);
                int offset = 81;
                for (int i = 0; i < size; ++i) {
                    offset = this.packSegment(offset, (String)this.vTags.get(i), (Value)this.vValues.get(i));
                }
            }
            this.bPacked = true;
        }
        if (!this.bPacked) {
            Debug.error("Packet is in invalid state.  It cannot be packed.");
        }
    }

    public synchronized void unpackData() {
        if (this.bPacked && !this.bUnpacked) {
            if (this.getHeader()) {
                this.bFlags = this.getByte(9);
                this.iReserved = this.getInt(10);
                this.iID = this.getInt(14);
                this.sType = this.getString(20).intern();
                this.sSource = this.getString(40).intern();
                this.sDest = this.getString(60).intern();
                this.vTags = new ArrayList();
                this.vValues = new ArrayList();
                int segs = this.getByte(80);
                int offset = 81;
                for (int i = 0; i < segs; ++i) {
                    offset = this.unpackSegment(offset);
                }
            }
            this.bUnpacked = true;
        }
        if (!this.bUnpacked) {
            Debug.error("Packet is in invalid state.  It cannot be unpacked.");
        }
    }

    public static Class findPacketType(String type) {
        if (type != null && type.length() > 0) {
            type = type.toLowerCase();
            String valclass = String.valueOf(String.valueOf(new StringBuffer("X10Gimli.System.Packet.").append(type.substring(0, 1).toUpperCase()).append(type.substring(1, type.length())).append("Packet")));
            try {
                Class<?> clazz = Class.forName(valclass);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception e) {
                Debug.printCallStack("Exception creating packet object.", e);
            }
            catch (NoClassDefFoundError e) {
                Debug.error("An error occurred loading the necessary classes for the packet.");
            }
        }
        return null;
    }

    public static boolean existsPacketType(String type) {
        return Packet.findPacketType(type) != null;
    }

    public synchronized Packet getPacketType() {
        this.packData();
        if (this.bPacked) {
            String type = this.getString(20);
            Class c = Packet.findPacketType(type);
            if (c != null) {
                try {
                    Packet p = (Packet)c.newInstance();
                    p.setBytes(this.getBytes());
                    p.unpackData();
                    Packet packet = p;
                    return packet;
                }
                catch (Exception e) {
                    Debug.printCallStack("Exception creating packet object.", e);
                }
            }
            this.unpackData();
        }
        return this;
    }

    public synchronized short getSize() {
        if (this.bData == null) {
            return (short)this.calcLength();
        }
        return this.getShort(18);
    }

    public synchronized String toString() {
        String outstring = "";
        try {
            int i;
            if (this.bUnpacked) {
                outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("PACKET ").append(this.getType()).append("[").append(this.getLength()).append("]").append("(").append(this.getFlags()).append(", ").append(this.getReserved()).append(", ").append(this.getID()).append(", ").append(this.getSource()).append(", ").append(this.getDest()).append(") : "))))));
                if (this.vTags != null && this.vTags.size() > 0) {
                    outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.vTags.get(0).toString())).concat(":"))));
                    outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(this.vValues.get(0).toString())));
                    for (i = 1; i < this.vTags.size(); ++i) {
                        outstring = String.valueOf(String.valueOf(outstring)).concat(", ");
                        outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.vTags.get(i).toString())).concat(":"))));
                        outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(this.vValues.get(i).toString())));
                    }
                }
            }
            if (this.bPacked) {
                if (this.bData != null && outstring.length() > 0) {
                    outstring = String.valueOf(String.valueOf(outstring)).concat("\r\n  ");
                }
                for (i = 0; i < this.bData.length; ++i) {
                    outstring = String.valueOf(String.valueOf(outstring)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.hexByte(this.bData[i]))).concat(" "))));
                    if ((i + 1) % 16 != 0) continue;
                    outstring = String.valueOf(String.valueOf(outstring)).concat("\r\n  ");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(outstring);
        }
        return outstring;
    }

    static {
        FLAG_RETURN = 1;
        TYPE_BOOLEAN = 1;
        TYPE_COMMAND = (byte)2;
        TYPE_DATE = (byte)3;
        TYPE_DAY = (byte)4;
        TYPE_IDENT = (byte)5;
        TYPE_MONTH = (byte)6;
        TYPE_NUMBER = (byte)7;
        TYPE_STRING = (byte)8;
        TYPE_TIME = (byte)9;
        TYPE_X10 = (byte)10;
        iCount = 0;
    }
}

