/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javazoom.jl.converter.Converter;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;
import photoorganizer.PhotoOrganizer;
import photoorganizer.Resources;
import photoorganizer.UiUpdater;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AdvancedImage;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.formats.SampleJpeg;
import photoorganizer.ird.IrdReceiver;
import photoorganizer.media.PlaybackRequest;
import photoorganizer.renderer.MediaPlayerPanel;
import photoorganizer.renderer.OptionsFrame;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.StatusBar;
import photoorganizer.renderer.TwoPanesView;
import rogatkin.BaseController;
import rogatkin.Program;
import rogatkin.Serializer;

public class Controller
extends BaseController
implements ActionListener {
    public static final Integer COMP_IMAGEPANEL = new Integer(1);
    public static final Integer COMP_DIRTREE = new Integer(2);
    public static final Integer COMP_THUMBPANEL = new Integer(3);
    public static final Integer COMP_FORMATS = new Integer(4);
    public static final Integer COMP_COLLECTION = new Integer(5);
    public static final Integer COMP_THUMBCOLLCTPANEL = new Integer(6);
    public static final Integer COMP_IMAGECOLLCTPANEL = new Integer(7);
    public static final Integer COMP_ALBUMPANEL = new Integer(8);
    public static final Integer COMP_STATUSBAR = new Integer(9);
    public static final Integer COMP_IMAGEALBUMPANEL = new Integer(10);
    public static final Integer COMP_ALBUMTHUMBPANEL = new Integer(11);
    public static final Integer COMP_WEBALBUMPANEL = new Integer(12);
    public static final Integer DESCR_TABLEVIEWS = new Integer(14);
    public static final Integer COMP_REMOTERECEIVER = new Integer(15);
    public static final Integer COMP_RIPPERPANEL = new Integer(16);
    public static final int BTN_MSK_OK = 1;
    public static final int BTN_MSK_APLY = 2;
    public static final int BTN_MSK_CANCEL = 4;
    public static final int BTN_MSK_HELP = 8;
    public static final int BTN_MSK_CLOSE = 16;
    public SampleJpeg sampleJpeg = new SampleJpeg();
    public MediaPlayerPanel mediaPlayer;
    private Image mainicon;
    private String transformtargetdir;
    private OptionsFrame options;
    private HTMLFilter filter = new HTMLFilter();
    private UiUpdater uiupdater = new UiUpdater();
    private static AdvancedImage advancedimage;

    public Controller(PhotoOrganizer photoOrganizer) {
        super((Program)photoOrganizer);
        this.mainicon = BaseController.getResourceIcon((String)"photoorganizer.jpg").getImage();
        if (BaseController.java2 && System.getProperty("USE_JAI") != null) {
            try {
                advancedimage = (AdvancedImage)Class.forName("photoorganizer.jai.AdvancedImageImpl").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println(noClassDefFoundError);
            }
            catch (InstantiationException instantiationException) {
                System.err.println(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(illegalAccessException);
            }
        }
        this.serializer.load();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Options...")) {
            if (this.options == null) {
                this.options = new OptionsFrame(this);
            } else {
                this.options.setVisible(true);
            }
        } else if (string.equals("About...")) {
            JOptionPane.showMessageDialog(this.getMainFrame(), "<html><i>MediaChest\nversion 1.1.74\nCopyright \u00a9 1999-2001 Dmitriy Rogatkin\n<html><b>For my wife Olga\nJava " + System.getProperty("java.version") + (BaseController.java2 ? " spec " + System.getProperty("java.specification.name") : "") + '\n' + "JVM " + System.getProperty("java.vendor") + " OS " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n' + (BaseController.java2 ? "Available " + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "MB, free " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "MB\n" : "") + Locale.getDefault().getDisplayName() + (advancedimage != null ? "\nJava Advanced Imaging" : ""), "About...", -1, BaseController.getResourceIcon((String)"logo.jpg"));
        } else if (string.equals("Contents...")) {
            this.showUrl("doc/MediaChest.htm");
        } else if (string.equals("View HTML")) {
            String string2 = (String)this.serializer.getProperty((Object)"WebPublishOptions", (Object)"WebRoot");
            if (string2 == null || string2.length() == 0) {
                string2 = this.serializer.getHomeDirectory();
            }
            Object[] objectArray = new Object[]{"Open", "Cancel", "Browse"};
            JOptionPane jOptionPane = new JOptionPane("Specify complete URL of created page", 3, 2, null, objectArray, objectArray[0]);
            jOptionPane.setWantsInput(true);
            jOptionPane.setInitialSelectionValue("http://" + this.serializer.getProperty((Object)"WebPublishOptions", (Object)"HostName") + '/' + PhotoCollectionPanel.LastHtmlName);
            jOptionPane.selectInitialValue();
            JDialog jDialog = jOptionPane.createDialog(this.getMainFrame(), "URL selection");
            jDialog.show();
            String string3 = (String)jOptionPane.getValue();
            if (string3 == JOptionPane.UNINITIALIZED_VALUE || objectArray[0].equals(string3)) {
                this.showUrl((String)jOptionPane.getInputValue());
            } else if (!objectArray[1].equals(string3) && string3 != null) {
                JFileChooser jFileChooser = new JFileChooser(string2);
                jFileChooser.addChoosableFileFilter(this.filter);
                jFileChooser.setFileFilter(this.filter);
                jFileChooser.setDialogTitle("Choose HTML template file");
                if (jFileChooser.showOpenDialog(this.getMainFrame()) == 0) {
                    this.showUrl(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        } else if (string.equals("Exit")) {
            this.close();
            this.getMainFrame().dispose();
            System.exit(0);
        }
    }

    public synchronized void print(File[] fileArray) {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this.getMainFrame(), "Printing...", new Properties());
        final StatusBar statusBar = (StatusBar)this.component(COMP_STATUSBAR);
        statusBar.displayInfo("Printing");
        if (fileArray != null) {
            statusBar.setProgress(fileArray.length * 2);
        }
        final Graphics graphics = printJob.getGraphics();
        graphics.setColor(Color.white);
        final Dimension dimension = printJob.getPageDimension();
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            File file;
            boolean bl;
            graphics.setClip(0, n * dimension.height, dimension.width, dimension.height);
            graphics.drawRect(0, 20, dimension.width - 10, dimension.height - 20 - 10);
            Image image = new BasicJpeg(fileArray[n]).getImage();
            boolean bl2 = bl = n == fileArray.length - 1;
            if (image == null || !graphics.drawImage(image, 0, 0, new ImageObserver(file = fileArray[n], bl, printJob){
                private final /* synthetic */ File val$file;
                private final /* synthetic */ boolean val$lastimage;
                private final /* synthetic */ PrintJob val$pj;
                {
                    this.val$file = file;
                    this.val$lastimage = bl;
                    this.val$pj = printJob;
                }

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    if (n3 == n5 / 2 && n5 != 0) {
                        statusBar.tickProgress();
                    }
                    if ((n & 0x60) == 0) {
                        return true;
                    }
                    graphics.drawImage(image, 0, 15, dimension.width - 30, (dimension.width - 30) * n5 / n4, null);
                    image.flush();
                    graphics.drawString(this.val$file.getAbsolutePath(), 15, (dimension.width - 30) * n5 / n4 + 30);
                    statusBar.tickProgress();
                    if (this.val$lastimage) {
                        graphics.dispose();
                        this.val$pj.end();
                        statusBar.clearInfo();
                        statusBar.clearProgress();
                    }
                    return false;
                }
            })) {
                // empty if block
            }
            ++n;
        }
    }

    public UiUpdater getUiUpdater() {
        return this.uiupdater;
    }

    public Image getMainIcon() {
        return this.mainicon;
    }

    public boolean selectTab(String string) {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getMainFrame().getContentPane().getComponent(0);
        int n = jTabbedPane.indexOfTab(string);
        if (n >= 0) {
            jTabbedPane.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public String getHomeDirectory() {
        String string = System.getProperty(this.main.getName() + ".home", ".");
        if (!(string.endsWith("/") && string.endsWith("\\") && string.endsWith(":"))) {
            string = string + File.separatorChar;
        }
        return string;
    }

    public void updateCaption(String string) {
        if (string == null) {
            string = "";
        }
        this.getMainFrame().setTitle(string);
    }

    public static AdvancedImage getAdvancedImage() {
        return advancedimage;
    }

    public int adjustMenuY(int n, int n2) {
        if (n > this.screen_height - n2) {
            return this.screen_height - n2;
        }
        return n;
    }

    public FileFilter getHtmlFilter() {
        return this.filter;
    }

    public void close() {
        this.save();
        this.main.save();
        this.serializer.save();
    }

    public static JPanel createButtonPanel(ActionListener actionListener, boolean bl) {
        return Controller.createButtonPanel(actionListener, 7 + (bl ? 8 : 0), 2);
    }

    public static JPanel createButtonPanel(ActionListener actionListener, int n, int n2) {
        JButton jButton;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n2));
        if ((n & 1) != 0) {
            jButton = new JButton("OK");
            jPanel.add(jButton);
            jButton.setDefaultCapable(true);
            jButton.addActionListener(actionListener);
        }
        if ((n & 2) != 0) {
            jButton = new JButton("<html><i>Apply");
            jPanel.add(jButton);
            jButton.addActionListener(actionListener);
        }
        if ((n & 0x10) != 0) {
            jButton = new JButton("Close");
            jPanel.add(jButton);
            jButton.addActionListener(actionListener);
        }
        if ((n & 4) != 0) {
            jButton = new JButton("Cancel");
            jPanel.add(jButton);
            jButton.addActionListener(actionListener);
        }
        if ((n & 8) != 0) {
            jButton = new JButton("Help");
            jPanel.add(jButton);
            jButton.addActionListener(actionListener);
        }
        return jPanel;
    }

    public static JMenu createTransformMenu(ActionListener actionListener) {
        JMenu jMenu = new JMenu("Transformation");
        JMenuItem jMenuItem = new JMenuItem("None");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Rotate 90");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Rotate 180");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Rotate 270");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Horizontal flip");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Vertical flip");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Transpose");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("Transverse");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Annotation");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenu;
    }

    public static int convertCmdToTrnasformOp(String string) {
        int n = -1;
        if (string.equals("Rotate 90")) {
            n = 5;
        } else if (string.equals("Rotate 180")) {
            n = 6;
        } else if (string.equals("Rotate 270")) {
            n = 7;
        } else if (string.equals("Horizontal flip")) {
            n = 1;
        } else if (string.equals("Vertical flip")) {
            n = 2;
        } else if (string.equals("Transpose")) {
            n = 3;
        } else if (string.equals("Transverse")) {
            n = 4;
        } else if (string.equals("None")) {
            n = 0;
        } else if (string.equals("Annotation")) {
            n = 8;
        }
        return n;
    }

    public static boolean isJdk1_4() {
        return BaseController.jdk1_4;
    }

    public void saveTableColumns(JTable jTable, String string, String string2) {
        Serializer serializer = this.getSerializer();
        Integer[] integerArray = new Integer[jTable.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            try {
                integerArray[n] = new Integer(jTable.getColumn(jTable.getColumnName(n)).getWidth());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                integerArray[n] = Resources.I_NO;
            }
            ++n;
        }
        serializer.setProperty((Object)string, (Object)string2, (Object)integerArray);
    }

    public void loadTableColumns(JTable jTable, String string, String string2) {
        Serializer serializer = this.getSerializer();
        Object[] objectArray = (Object[])serializer.getProperty((Object)string, (Object)string2);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            jTable.getColumn(jTable.getColumnName(n)).setWidth((Integer)objectArray[n]);
            jTable.getColumn(jTable.getColumnName(n)).setPreferredWidth((Integer)objectArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaPlayerPanel playMedia(AbstractFormat abstractFormat, int n) throws IOException {
        Serializer serializer = this.getSerializer();
        if (Serializer.getInt((Object)serializer.getProperty((Object)"MediaOptions", (Object)"ReusePlayer"), (int)1) == 1) {
            JFrame jFrame = null;
            Controller controller = this;
            synchronized (controller) {
                if (this.mediaPlayer == null) {
                    jFrame = new JFrame();
                    this.mediaPlayer = new MediaPlayerPanel(true);
                    jFrame.setContentPane(this.mediaPlayer);
                    jFrame.pack();
                    jFrame.setIconImage(this.getMainIcon());
                    jFrame.addWindowListener(this.mediaPlayer.getWindowListener());
                } else {
                    jFrame = (JFrame)this.mediaPlayer.getTopLevelAncestor();
                }
            }
            jFrame.setVisible(true);
            this.mediaPlayer.replay(abstractFormat, n);
            if (this.component(COMP_REMOTERECEIVER) != null) {
                ((IrdReceiver)this.component(COMP_REMOTERECEIVER)).setOnTop(this.mediaPlayer);
            }
            return this.mediaPlayer;
        }
        JFrame jFrame = new JFrame("Now is playing " + abstractFormat.toString());
        jFrame.setDefaultCloseOperation(0);
        MediaPlayerPanel mediaPlayerPanel = new MediaPlayerPanel(abstractFormat, jFrame, n);
        jFrame.setContentPane(mediaPlayerPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setIconImage(this.getMainIcon());
        if (this.component(COMP_REMOTERECEIVER) != null) {
            ((IrdReceiver)this.component(COMP_REMOTERECEIVER)).setOnTop(mediaPlayerPanel);
        }
        return mediaPlayerPanel;
    }

    public void playMediaList(final PlaybackRequest playbackRequest) {
        new Thread(new Runnable(){

            public void run() {
                playbackRequest.player = null;
                Controller.this.playMediaList(playbackRequest.playbackList, playbackRequest);
            }
        }, "MediaListPlayer").start();
    }

    public void playMediaList(Object[] objectArray, PlaybackRequest playbackRequest) {
        if (playbackRequest.player != null && playbackRequest.player.isClosed()) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            block15: {
                AbstractFormat abstractFormat;
                File file;
                block14: {
                    block13: {
                        file = null;
                        abstractFormat = null;
                        if (!(objectArray[n] instanceof File)) break block13;
                        file = (File)objectArray[n];
                        break block14;
                    }
                    if (!(objectArray[n] instanceof AbstractFormat)) break block15;
                    abstractFormat = (AbstractFormat)objectArray[n];
                }
                if (file != null && file.isDirectory() && playbackRequest.recursive) {
                    this.playMediaList(file.listFiles(), playbackRequest);
                } else {
                    if (abstractFormat == null && file != null) {
                        abstractFormat = MediaFormatFactory.createMediaFormat(file);
                    }
                    if (abstractFormat != null && abstractFormat.isValid() && abstractFormat instanceof MP3 && (playbackRequest.matcher == null || playbackRequest.matcher.match(abstractFormat))) {
                        try {
                            playbackRequest.player = this.playMedia(abstractFormat, playbackRequest.introFrames);
                            playbackRequest.player.waitForCompletion();
                            System.err.println("Closed " + playbackRequest.player.isClosed());
                            if (playbackRequest.player.isClosed()) break;
                            if (playbackRequest.pauseBetween > 999) {
                                try {
                                    Thread.sleep(playbackRequest.pauseBetween);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        catch (IOException iOException) {
                            System.err.println("Problem " + iOException + " for " + abstractFormat);
                        }
                    }
                }
            }
            ++n;
        }
    }

    public static void convertToWav(AbstractFormat abstractFormat, String string, StatusBar statusBar) throws JavaLayerException {
        Controller.convertToWav(abstractFormat, string, new Converter(), statusBar);
    }

    public static void convertToWav(AbstractFormat abstractFormat, String string, Converter converter, StatusBar statusBar) throws JavaLayerException, IllegalArgumentException {
        if (abstractFormat == null || !(abstractFormat instanceof MP3) || !abstractFormat.isValid()) {
            throw new IllegalArgumentException("Media format not specified or invalid.");
        }
        if (statusBar != null) {
            converter.convert(abstractFormat.getFile().getPath(), string, (Converter.ProgressListener)new ConvertProgressListener(statusBar));
        } else {
            converter.convert(abstractFormat.getFile().getPath(), string);
        }
    }

    public void showHtml(String string, String string2) {
        JDialog jDialog = new JDialog(this.getMainFrame(), string2, true);
        TwoPanesView twoPanesView = TwoPanesView.createFramed(true, jDialog, 16, null);
        jDialog.setContentPane(twoPanesView);
        twoPanesView.setUpperText(string);
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        twoPanesView.setSize(440, 330);
        jDialog.setVisible(true);
    }

    public static byte[] readStreamInBuffer(InputStream inputStream) throws IOException {
        return Controller.readStreamInBuffer(inputStream, 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStreamInBuffer(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[]{};
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byte[] byArray3 = new byte[byArray2.length + n2];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray3, byArray2.length, n2);
                byArray2 = byArray3;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray2;
    }

    public static class ConvertProgressListener
    implements Converter.ProgressListener {
        StatusBar statusBar;

        public ConvertProgressListener(StatusBar statusBar) {
            this.statusBar = statusBar;
        }

        public void converterUpdate(int n, int n2, int n3) {
            if (1 == n) {
                this.statusBar.setProgress(n2);
            } else if (2 == n) {
                this.statusBar.clearProgress();
                this.statusBar.flashInfo("Completed");
            }
        }

        public void parsedFrame(int n, Header header) {
            this.statusBar.displayInfo("P/f: " + n);
            this.statusBar.tickProgress();
        }

        public void readFrame(int n, Header header) {
            this.statusBar.displayInfo("R/f: " + n);
            this.statusBar.tickProgress();
        }

        public void decodedFrame(int n, Header header, Obuffer obuffer) {
            this.statusBar.displayInfo("D/f: " + n);
            this.statusBar.tickProgress();
        }

        public boolean converterException(Throwable throwable) {
            this.statusBar.flashInfo("Exception " + throwable, true);
            return false;
        }
    }

    class HTMLFilter
    extends FileFilter {
        final String[] extensions = new String[]{"html", "htm", "htmt"};

        HTMLFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n > 0 && n < string.length() - 1) {
                String string2 = string.substring(n + 1).toLowerCase();
                n = 0;
                if (n < this.extensions.length) {
                    return this.extensions[n].equals(string2);
                }
            }
            return false;
        }

        public String getDescription() {
            return "HTML files";
        }
    }
}

