/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.CIFF;
import photoorganizer.formats.Exif;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Flashpix;
import photoorganizer.formats.JFXX;
import photoorganizer.formats.JPEG;
import photoorganizer.formats.TiffExif;

public class BasicJpeg
extends BasicIo
implements AbstractFormat {
    static final String JFIF = "JFIF";
    static final String FPXR = "FPXR";
    static final String JPEG = "JPEG";
    public static final int NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int TRANSPOSE = 3;
    public static final int TRANSVERSE = 4;
    public static final int ROT_90 = 5;
    public static final int ROT_180 = 6;
    public static final int ROT_270 = 7;
    public static final int COMMENT = 8;
    public static final int DCTSIZE2 = 64;
    public static final int DCTSIZE = 8;
    public static final int HUFF_LOOKAHEAD = 8;
    public static final int BYTE_SIZE = 8;
    static final int[] jpegzigzagorder = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    static final int[] jpegnaturalorder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static String enc;
    private int readcounter;
    private int[][] app_store;
    private int components_in_scan;
    private int components_in_frame;
    private int frm_precision;
    private int[] comp_ids;
    private int[] dc_table;
    private int[] ac_table;
    private int _Ss;
    private int _Se;
    private int _Ah;
    private int _Al;
    private int frm_x;
    private int frm_y;
    private int[] V;
    private int[] H;
    private int[] QT;
    private int[] ID;
    private int maxHi;
    private int maxVi;
    private int mcusize;
    private int restart_interval;
    private int[][] dc_valoffset;
    private int[][] dc_maxcode;
    private int[][] dc_huffval;
    private int[] dc_ix;
    private int[][] ac_valoffset;
    private int[][] ac_maxcode;
    private int[][] ac_huffval;
    private int[][] dc_huffbits;
    private int[][] ac_huffbits;
    private int[] ac_ix;
    private int[][] q_table;
    private int[] q_ix;
    private int[] q_prec;
    private int[][][][][] dct_coefs;
    private int[][][] enc_ac_matrix;
    private int[][][] enc_dc_matrix;
    boolean valid;
    File file;
    byte[] markerid;
    AbstractImageInfo imageinfo;
    byte[][] appxs;
    String in_comment;
    String out_comment;
    static /* synthetic */ Class class$photoorganizer$formats$JFXX;
    static /* synthetic */ Class class$photoorganizer$formats$Exif;
    static /* synthetic */ Class class$photoorganizer$formats$AbstractImageInfo;

    public BasicJpeg(File file) {
        this.file = file;
        this.markerid = new byte[2];
        this.read();
    }

    public static void setEncoding(String string) {
        enc = string;
    }

    public static String getEncoding() {
        return enc;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getLocationName() {
        return this.file.getAbsolutePath();
    }

    public String getName() {
        if (this.file == null) {
            return "Unknown";
        }
        return this.file.getName();
    }

    public String toString() {
        return this.getName();
    }

    public String getParentPath() {
        return this.file.getParent();
    }

    public long getFileSize() {
        return this.length();
    }

    public long length() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public URL getUrl() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Date getDateTimeOriginal() {
        return new Date(this.file.lastModified());
    }

    public boolean renameTo(File file) {
        if (this.file.renameTo(file)) {
            this.file = file;
            try {
                this.imageinfo.setName(this.file.getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public InputStream createInputStream() {
        try {
            if (this.valid) {
                this.readcounter = 0;
                return new BufferedInputStream(new FileInputStream(this.file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.valid = false;
        }
        return null;
    }

    public InputStream getAsStream() {
        return this.createInputStream();
    }

    public byte[] getThumbnailData(Dimension dimension) {
        throw new RuntimeException("Method getThumbnailData is not implemented yet");
    }

    public Image getImage() {
        if (this.valid) {
            return Toolkit.getDefaultToolkit().getImage(this.getLocationName());
        }
        return null;
    }

    public Icon getThumbnail(Dimension dimension) {
        return this.getImageInfo().getThumbnailIcon(this, dimension);
    }

    public Icon getIcon() {
        try {
            if (this.valid) {
                if (Controller.getAdvancedImage() != null) {
                    return Controller.getAdvancedImage().createIcon(this.getLocationName());
                }
                return new ImageIcon(this.getLocationName());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public AbstractImageInfo getImageInfo() {
        return this.imageinfo;
    }

    public AbstractInfo getInfo() {
        return this.getImageInfo();
    }

    public String getType() {
        return JPEG;
    }

    public String getThumbnailType() {
        return this.getImageInfo().getThumbnailExtension();
    }

    public String getComment() {
        return this.out_comment;
    }

    public void setComment(String string) {
        this.in_comment = string;
    }

    public boolean transform(String string, int n) {
        return this.transform(string, n, false);
    }

    public boolean transform(String string, int n, boolean bl) {
        return this.transform(new File(string), n, bl, null);
    }

    public boolean transform(String string, int n, boolean bl, Class clazz) {
        return this.transform(new File(string), n, bl, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(File file, int n, boolean bl, Class clazz) {
        this.read(false, bl);
        try {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 4096);
                switch (n) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        this.transposeImageParameters();
                        break;
                    }
                }
                this.save(bufferedOutputStream, n, clazz);
            }
            catch (IOException iOException) {
                System.err.println(iOException + " in saving of " + file.getName());
                iOException.printStackTrace();
                boolean bl2 = false;
                Object var8_8 = null;
                this.freeMemory();
                this.appxs = null;
                return bl2;
            }
            Object var8_7 = null;
            this.freeMemory();
            this.appxs = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.freeMemory();
            this.appxs = null;
            throw throwable;
        }
        return true;
    }

    void save(OutputStream outputStream, int n, Class clazz) throws IOException {
        this.writeMarkerSOI(outputStream);
        this.writeNewMarker(outputStream, clazz);
        this.writeMarkerAppXs(outputStream);
        if (n == 8) {
            this.writeMarkerComment(outputStream, this.in_comment, enc);
        } else {
            this.writeMarkerComment(outputStream, "MediaChest" + (this.out_comment.length() == 0 ? "" : "\n") + this.out_comment, enc);
        }
        this.writeMarkerDQT(outputStream);
        this.writeMarkerDHT(outputStream);
        this.writeMarkerDRI(outputStream);
        this.writeMarkerSOF0(outputStream);
        this.writeMarkerSOS(outputStream);
        this.writeDCT(outputStream, n);
        this.writeMarkerEOI(outputStream);
        outputStream.flush();
        outputStream.close();
        outputStream = null;
    }

    private void freeMemory() {
        this.dct_coefs = null;
        this.dc_valoffset = null;
        this.dc_maxcode = null;
        this.dc_huffval = null;
        this.enc_dc_matrix = null;
        this.dc_huffbits = null;
        this.dc_ix = null;
        this.ac_valoffset = null;
        this.ac_maxcode = null;
        this.ac_huffval = null;
        this.enc_ac_matrix = null;
        this.ac_huffbits = null;
        this.ac_ix = null;
        this.q_table = null;
        this.q_ix = null;
        this.q_prec = null;
    }

    void allocateTables() {
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.q_table = new int[0][0];
        this.q_ix = new int[0];
        this.q_prec = new int[0];
    }

    void read() {
        this.read(true, false);
    }

    void read(boolean bl, boolean bl2) {
        this.out_comment = "";
        this.valid = this.file.isFile();
        if (!this.valid) {
            return;
        }
        try {
            InputStream inputStream = this.createInputStream();
            if (!this.valid) {
                return;
            }
            this.valid = false;
            block23: while (inputStream.read(this.markerid) == this.markerid.length) {
                this.readcounter += this.markerid.length;
                if (this.markerid[0] != -1) {
                    if (this.readcounter == this.markerid.length) {
                        this.intel = this.markerid[0] == 73 && this.markerid[1] == 73;
                        boolean bl3 = this.motorola = this.markerid[0] == 77 && this.markerid[1] == 77;
                        if (this.intel || this.motorola) {
                            this.data = new byte[6];
                            if (inputStream.read(this.data) == this.data.length && (this.intel && this.data[0] == 42 && this.data[1] == 0 || this.motorola && this.data[1] == 42 && this.data[0] == 0)) {
                                this.readcounter += this.data.length;
                                this.imageinfo = new TiffExif(inputStream, this.data, this.readcounter, this.file.getName(), this.intel);
                            }
                        } else if (this.markerid[0] == Flashpix.SIGNATURE[0] && this.markerid[1] == Flashpix.SIGNATURE[1]) {
                            this.data = new byte[6];
                            if (inputStream.read(this.data) == this.data.length && this.data[0] == Flashpix.SIGNATURE[2] && this.data[1] == Flashpix.SIGNATURE[3] && this.data[2] == Flashpix.SIGNATURE[4] && this.data[3] == Flashpix.SIGNATURE[5] && this.data[4] == Flashpix.SIGNATURE[6] && this.data[5] == Flashpix.SIGNATURE[7]) {
                                this.readcounter += this.data.length;
                            }
                        }
                    }
                    boolean bl4 = this.valid = this.imageinfo != null;
                    if (this.valid || Controller.getAdvancedImage() == null) break;
                    try {
                        this.valid = Controller.getAdvancedImage().isValid(this.getLocationName());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
                byte by = this.markerid[1];
                switch (by) {
                    case -40: {
                        if (bl) continue block23;
                        this.allocateTables();
                        continue block23;
                    }
                    case -32: 
                    case -31: 
                    case -30: 
                    case -29: 
                    case -28: 
                    case -27: 
                    case -26: 
                    case -25: 
                    case -24: 
                    case -23: 
                    case -22: 
                    case -21: 
                    case -20: 
                    case -19: 
                    case -18: 
                    case -17: {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        if (!bl) {
                            if (bl2) {
                                n6 = this.readMarker(inputStream);
                                this.addAppx(n6, by);
                                continue block23;
                            }
                            if (inputStream.read(this.markerid) != this.markerid.length) break block23;
                            this.readcounter += this.markerid.length;
                            this.data = this.markerid;
                            n6 = this.bs2i(0, 2) - 2;
                            BasicIo.skip(inputStream, n6);
                            this.readcounter += n6;
                            System.err.println("Marker APP" + ((by & 0xFF) - 224) + " is found, skipped " + n6 + 2 + " (" + this.getLocationName() + ")");
                            continue block23;
                        }
                        n6 = this.readMarker(inputStream);
                        if (bl2) {
                            this.addAppx(n6, by);
                        }
                        this.valid = true;
                        if (this.isSignature(0, JFIF)) {
                            int n7 = this.bs2i(5, 2);
                            int n8 = this.bs2i(7, 1);
                            n5 = this.bs2i(8, 2);
                            n4 = this.bs2i(10, 2);
                            n3 = this.bs2i(12, 1);
                            n2 = this.bs2i(13, 1);
                            n = 3 * n3 * n2;
                            if (n3 <= 0 || n2 <= 0) continue block23;
                            System.err.println("Thumbnail " + n3 + "x" + n2 + " in APP0");
                            continue block23;
                        }
                        if (this.isSignature(0, "JFXX")) {
                            this.imageinfo = new JFXX(inputStream, this.data, this.readcounter, this.file.getName(), this.out_comment);
                            continue block23;
                        }
                        if (this.isSignature(0, "Exif")) {
                            this.imageinfo = new Exif(inputStream, this.data, this.readcounter, this.file.getName(), this.out_comment);
                            continue block23;
                        }
                        if ((this.isSignature(0, "II") || this.isSignature(0, "MM")) && this.isSignature(6, "HEAP")) {
                            this.imageinfo = new CIFF(inputStream, this.data, this.readcounter, this.file.getName(), this.out_comment);
                            continue block23;
                        }
                        if (this.isSignature(0, FPXR) || this.imageinfo != null) continue block23;
                        this.imageinfo = new JPEG(inputStream, this.data, this.readcounter, this.file.getName(), this.out_comment);
                        continue block23;
                    }
                    case -37: {
                        int n2;
                        int n3;
                        int n4;
                        if (bl) {
                            this.valid = true;
                            break block23;
                        }
                        int n6 = this.readMarker(inputStream);
                        int n5 = 0;
                        while (n5 < n6) {
                            n3 = this.q_prec.length;
                            int[] nArray = new int[n3 + 1];
                            System.arraycopy(this.q_ix, 0, nArray, 0, n3);
                            this.q_ix = nArray;
                            this.q_ix[n3] = this.data[n5] & 0xF;
                            nArray = new int[n3 + 1];
                            System.arraycopy(this.q_prec, 0, nArray, 0, n3);
                            this.q_prec = nArray;
                            this.q_prec[n3] = (this.data[n5++] >> 4 & 0xF) == 0 ? 8 : 16;
                            int[][] nArray2 = new int[n3 + 1][64];
                            System.arraycopy(this.q_table, 0, nArray2, 0, n3);
                            this.q_table = nArray2;
                            n4 = n5 + 64;
                            if (n4 > n6) {
                                n4 = n6;
                            }
                            n2 = 0;
                            while (n5 < n4) {
                                this.q_table[n3][n2] = this.data[n5++] & 0xFF;
                                ++n2;
                            }
                        }
                        continue block23;
                    }
                    case -60: {
                        if (bl) {
                            this.valid = true;
                            break block23;
                        }
                        int n6 = this.readDHT(inputStream);
                        continue block23;
                    }
                    case -64: 
                    case -63: {
                        if (bl) {
                            this.valid = true;
                            break block23;
                        }
                        int n6 = this.readMarker(inputStream);
                        this.frm_precision = this.data[0] & 0xFF;
                        this.frm_x = this.bs2i(3, 2);
                        this.frm_y = this.bs2i(1, 2);
                        this.components_in_frame = this.data[5] & 0xFF;
                        System.err.println("Frame, precision " + this.frm_precision);
                        System.err.println("X= " + this.frm_x + ", Y= " + this.frm_y);
                        System.err.println("Components " + this.components_in_frame + " (" + this.getLocationName() + ")");
                        this.V = new int[this.components_in_frame];
                        this.H = new int[this.components_in_frame];
                        this.QT = new int[this.components_in_frame];
                        this.ID = new int[this.components_in_frame];
                        int n5 = 6;
                        this.maxVi = 0;
                        this.maxHi = 0;
                        int n3 = 0;
                        this.mcusize = 0;
                        int n2 = 0;
                        while (n2 < this.components_in_frame) {
                            this.ID[n2] = this.data[n5++] & 0xFF;
                            n3 = (n3 << 8) + (this.data[n5] & 0xFF);
                            this.H[n2] = this.data[n5] >> 4 & 0xF;
                            if (this.H[n2] > this.maxHi) {
                                this.maxHi = this.H[n2];
                            }
                            this.V[n2] = this.data[n5++] & 0xF;
                            if (this.V[n2] > this.maxVi) {
                                this.maxVi = this.V[n2];
                            }
                            this.mcusize += this.H[n2] * this.V[n2];
                            this.QT[n2] = this.data[n5++] & 0xFF;
                            ++n2;
                        }
                        continue block23;
                    }
                    case -62: {
                        int n6 = this.readMarker(inputStream);
                        System.err.println("Progressive, Huffman not supported (" + this.getLocationName() + ")");
                        continue block23;
                    }
                    case -55: {
                        int n6 = this.readMarker(inputStream);
                        System.err.println("Extended sequential, arithmetic not supported (" + this.getLocationName() + ")");
                        continue block23;
                    }
                    case -54: {
                        int n6 = this.readMarker(inputStream);
                        System.err.println("Progressive, arithmetic not supported (" + this.getLocationName() + ")");
                        continue block23;
                    }
                    case -61: 
                    case -59: 
                    case -58: 
                    case -57: 
                    case -56: 
                    case -53: 
                    case -51: 
                    case -50: 
                    case -49: {
                        int n6 = this.readMarker(inputStream);
                        System.err.println("One of the unsupported SOF markers:\nLossless, Huffman\nDifferential sequential, Huffman\nDifferential progressive, Huffman\nDifferential lossless, Huffman\nReserved for JPEG extensions\nLossless, arithmetic\nDifferential sequential, arithmetic\nDifferential progressive, arithmetic\nDifferential lossless, arithmetic (" + this.getLocationName() + ")");
                        continue block23;
                    }
                    case -38: {
                        int n6 = this.readMarker(inputStream);
                        this.components_in_scan = this.data[0] & 0xFF;
                        int n5 = 1;
                        this.comp_ids = new int[this.components_in_scan];
                        this.dc_table = new int[this.components_in_scan];
                        this.ac_table = new int[this.components_in_scan];
                        int n = 0;
                        while (n < this.components_in_scan) {
                            this.comp_ids[n] = this.data[n5++] & 0xFF;
                            this.dc_table[n] = this.data[n5] >> 4 & 0xF;
                            this.ac_table[n] = this.data[n5++] & 0xF;
                            ++n;
                        }
                        this._Ss = this.data[n5++] & 0xFF;
                        this._Se = this.data[n5++] & 0xFF;
                        this._Ah = this.data[n5] >> 4 & 0xF;
                        this._Al = this.data[n5] & 0xF;
                        this.readDCT(inputStream);
                        continue block23;
                    }
                    case -2: {
                        int n6 = this.readMarker(inputStream);
                        if (this.out_comment.length() > 0) {
                            this.out_comment = this.out_comment + '\n';
                        }
                        try {
                            this.out_comment = this.out_comment + new String(this.data, 0, n6, enc);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this.out_comment = this.out_comment + new String(this.data, 0, n6);
                        }
                        catch (NullPointerException nullPointerException) {
                            this.out_comment = this.out_comment + new String(this.data, 0, n6);
                        }
                        continue block23;
                    }
                    case -39: {
                        this.valid = true;
                        break block23;
                    }
                    case -35: {
                        if (bl) {
                            this.valid = true;
                            break block23;
                        }
                        int n6 = this.readMarker(inputStream);
                        if (n6 != 2) {
                            throw new IOException("Wrong length of DRI marker " + n6 + " (" + this.getLocationName() + ")");
                        }
                        this.restart_interval = this.bs2i(0, 2);
                        continue block23;
                    }
                    case -1: {
                        continue block23;
                    }
                    default: {
                        int n6 = this.readMarker(inputStream);
                        if ((0xFFFFFFF0 & by) == -16) break block23;
                        System.err.println("Unsupported marker " + Integer.toHexString(by) + " length " + n6 + " (" + this.getLocationName() + ")");
                        continue block23;
                    }
                }
            }
            if (this.valid) {
                if (bl) {
                    if (this.imageinfo == null) {
                        this.imageinfo = new JPEG(inputStream, this.data, this.readcounter, this.file.getName(), this.out_comment);
                    }
                } else {
                    System.err.println("0x" + Integer.toHexString(this.readcounter) + "(" + this.readcounter + ") byte(s) read in " + this.file.getName());
                }
            }
            inputStream.close();
        }
        catch (Exception exception) {
            this.valid = false;
            exception.printStackTrace();
        }
    }

    private void addAppx(int n, byte by) {
        if (this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] byArrayArray = new byte[this.appxs.length + 1][];
        System.arraycopy(this.appxs, 0, byArrayArray, 0, this.appxs.length);
        this.appxs = byArrayArray;
        this.appxs[this.appxs.length - 1] = new byte[n + 4];
        this.appxs[this.appxs.length - 1][0] = -1;
        this.appxs[this.appxs.length - 1][1] = by;
        System.arraycopy(this.markerid, 0, this.appxs[this.appxs.length - 1], 2, 2);
        System.arraycopy(this.data, 0, this.appxs[this.appxs.length - 1], 4, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMarkers(OutputStream outputStream) throws IOException {
        try {
            this.read(true, true);
            if (outputStream != null) {
                this.writeMarkerAppXs(outputStream);
                outputStream.close();
            }
            Object var3_2 = null;
            this.appxs = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.appxs = null;
            throw throwable;
        }
    }

    int readMarker(InputStream inputStream) throws IOException, FileFormatException {
        if (inputStream.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int n = this.bs2i(0, 2) - 2;
        this.data = new byte[n];
        BasicIo.read(inputStream, this.data);
        this.readcounter += n;
        return n;
    }

    void writeMarkerAppXs(OutputStream outputStream) throws IOException {
        if (this.appxs == null) {
            return;
        }
        int n = 0;
        while (n < this.appxs.length) {
            outputStream.write(this.appxs[n]);
            ++n;
        }
    }

    void writeMarkerSOI(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-40);
    }

    void writeNewMarker(OutputStream outputStream, Class clazz) throws IOException {
        if (clazz == null) {
            return;
        }
        if (clazz == (class$photoorganizer$formats$JFXX == null ? (class$photoorganizer$formats$JFXX = BasicJpeg.class$("photoorganizer.formats.JFXX")) : class$photoorganizer$formats$JFXX)) {
            outputStream.write(JFXX.getMarkerData());
        } else if (clazz == (class$photoorganizer$formats$Exif == null ? (class$photoorganizer$formats$Exif = BasicJpeg.class$("photoorganizer.formats.Exif")) : class$photoorganizer$formats$Exif)) {
            outputStream.write(Exif.getMarkerData());
        } else if (clazz == (class$photoorganizer$formats$AbstractImageInfo == null ? (class$photoorganizer$formats$AbstractImageInfo = BasicJpeg.class$("photoorganizer.formats.AbstractImageInfo")) : class$photoorganizer$formats$AbstractImageInfo)) {
            String string = this.file.getName();
            int n = string.lastIndexOf(46);
            string = n > 0 ? string.substring(0, n + 1) : string + '.';
            File file = new File(this.file.getParent(), string + "Exif");
            if (file.exists()) {
                try {
                    byte[] byArray = new byte[(int)file.length()];
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BasicIo.read(fileInputStream, byArray);
                    outputStream.write(byArray);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("Exception in reading exif marker " + iOException);
                }
            }
        }
    }

    void writeMarkerComment(OutputStream outputStream, String string, String string2) throws IOException {
        outputStream.write(-1);
        outputStream.write(-2);
        int n = 2;
        try {
            this.data = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.data = string.getBytes();
        }
        catch (NullPointerException nullPointerException) {
            this.data = string.getBytes();
        }
        outputStream.write((n += this.data.length) >> 8);
        outputStream.write(n & 0xFF);
        outputStream.write(this.data);
    }

    void writeMarkerDHT(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        outputStream.write(-1);
        outputStream.write(-60);
        int n3 = 2;
        int n4 = 0;
        while (n4 < this.ac_ix.length) {
            n3 += 17 + this.ac_huffval[n4].length;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.dc_ix.length) {
            n3 += 17 + this.dc_huffval[n5].length;
            ++n5;
        }
        outputStream.write(n3 >> 8);
        outputStream.write(n3 & 0xFF);
        int n6 = 0;
        while (n6 < this.dc_ix.length) {
            outputStream.write(this.dc_ix[n6]);
            n2 = 0;
            while (n2 < this.dc_huffbits[n6].length) {
                outputStream.write(this.dc_huffbits[n6][n2]);
                ++n2;
            }
            n = 0;
            while (n < this.dc_huffval[n6].length) {
                outputStream.write(this.dc_huffval[n6][n]);
                ++n;
            }
            ++n6;
        }
        n2 = 0;
        while (n2 < this.ac_ix.length) {
            outputStream.write(this.ac_ix[n2] + 16);
            n = 0;
            while (n < this.ac_huffbits[n2].length) {
                outputStream.write(this.ac_huffbits[n2][n]);
                ++n;
            }
            int n7 = 0;
            while (n7 < this.ac_huffval[n2].length) {
                outputStream.write(this.ac_huffval[n2][n7]);
                ++n7;
            }
            ++n2;
        }
    }

    void writeMarkerDQT(OutputStream outputStream) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write marker DQT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        outputStream.write(-1);
        outputStream.write(-37);
        int n = 2 + this.q_ix.length * 65;
        outputStream.write(n >> 8);
        outputStream.write(n & 0xFF);
        int n2 = 0;
        while (n2 < this.q_ix.length) {
            outputStream.write(this.q_ix[n2] + (this.q_prec[n2] == 8 ? 0 : 16));
            int n3 = 0;
            while (n3 < 64) {
                outputStream.write(this.q_table[n2][n3]);
                ++n3;
            }
            ++n2;
        }
    }

    void writeMarkerDRI(OutputStream outputStream) throws IOException {
        if (this.restart_interval != 0) {
            outputStream.write(-1);
            outputStream.write(-35);
            outputStream.write(0);
            outputStream.write(4);
            outputStream.write(this.restart_interval >> 8);
            outputStream.write(this.restart_interval & 0xFF);
        }
    }

    void writeMarkerSOF0(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-64);
        int n = 8 + this.components_in_frame * 3;
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
        outputStream.write(this.frm_precision);
        outputStream.write(this.frm_y >> 8);
        outputStream.write(this.frm_y & 0xFF);
        outputStream.write(this.frm_x >> 8);
        outputStream.write(this.frm_x & 0xFF);
        outputStream.write(this.components_in_frame);
        int n2 = 0;
        while (n2 < this.components_in_frame) {
            outputStream.write(this.ID[n2]);
            outputStream.write((this.H[n2] << 4) + this.V[n2]);
            outputStream.write(this.QT[n2]);
            ++n2;
        }
    }

    void writeMarkerSOS(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-38);
        int n = 3 + this.components_in_scan * 2 + 1 + 1 + 1;
        outputStream.write(n >> 8);
        outputStream.write(n & 0xFF);
        outputStream.write(this.components_in_scan);
        int n2 = 0;
        while (n2 < this.components_in_scan) {
            outputStream.write(this.comp_ids[n2]);
            outputStream.write((this.dc_table[n2] << 4) + this.ac_table[n2]);
            ++n2;
        }
        outputStream.write(this._Ss);
        outputStream.write(this._Se);
        outputStream.write((this._Ah << 4) + this._Al);
    }

    void writeMarkerEOI(OutputStream outputStream) throws IOException {
        outputStream.write(-1);
        outputStream.write(-39);
    }

    /*
     * Unable to fully structure code
     */
    int readDHT(InputStream var1_1) throws IOException {
        var2_2 = this.readMarker(var1_1);
        var3_3 = 0;
        do {
            var4_4 = (this.data[var3_3] & 255) > 15;
            var5_5 = var4_4 != false ? (this.data[var3_3] & 255) - 16 : this.data[var3_3] & 255;
            var10_10 = 0;
            if (!var4_4) {
                var7_7 = new int[12][2];
                var10_10 = this.dc_valoffset.length;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.dc_valoffset, 0, var6_6, 0, var10_10);
                this.dc_valoffset = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.dc_maxcode, 0, var6_6, 0, var10_10);
                this.dc_maxcode = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.dc_huffval, 0, var6_6, 0, var10_10);
                this.dc_huffval = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.dc_huffbits, 0, var6_6, 0, var10_10);
                this.dc_huffbits = var6_6;
                var8_8 = new int[var10_10 + 1][][];
                System.arraycopy(this.enc_dc_matrix, 0, var8_8, 0, var10_10);
                this.enc_dc_matrix = var8_8;
                var9_9 = new int[var10_10 + 1];
                System.arraycopy(this.dc_ix, 0, var9_9, 0, var10_10);
                this.dc_ix = var9_9;
                this.dc_ix[var10_10] = var5_5;
            } else {
                var7_7 = new int[255][2];
                var10_10 = this.ac_valoffset.length;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.ac_valoffset, 0, var6_6, 0, var10_10);
                this.ac_valoffset = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.ac_maxcode, 0, var6_6, 0, var10_10);
                this.ac_maxcode = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.ac_huffval, 0, var6_6, 0, var10_10);
                this.ac_huffval = var6_6;
                var6_6 = new int[var10_10 + 1][];
                System.arraycopy(this.ac_huffbits, 0, var6_6, 0, var10_10);
                this.ac_huffbits = var6_6;
                var8_8 = new int[var10_10 + 1][][];
                System.arraycopy(this.enc_ac_matrix, 0, var8_8, 0, var10_10);
                this.enc_ac_matrix = var8_8;
                var9_9 = new int[var10_10 + 1];
                System.arraycopy(this.ac_ix, 0, var9_9, 0, var10_10);
                this.ac_ix = var9_9;
                this.ac_ix[var10_10] = var5_5;
            }
            var12_12 = new int[257];
            var13_13 = new int[257];
            var14_14 = new int[16];
            var15_15 = 0;
            var16_16 = 1;
            while (var16_16 <= 16) {
                var14_14[var16_16 - 1] = var11_11 = this.data[var3_3 + var16_16] & 255;
                while (var11_11-- > 0) {
                    var12_12[var15_15++] = var16_16;
                }
                ++var16_16;
            }
            var12_12[var15_15] = 0;
            var17_17 = var15_15;
            var18_18 = 0;
            var19_19 = var12_12[0];
            var15_15 = 0;
            ** GOTO lbl76
            {
                var13_13[var15_15++] = var18_18++;
                do {
                    if (var12_12[var15_15] == var19_19) continue block3;
                    if (var18_18 >= 1 << var19_19) {
                        throw new IOException("Bad huffman code table (" + this.getLocationName() + ")");
                    }
                    var18_18 <<= 1;
                    ++var19_19;
lbl76:
                    // 2 sources

                } while (var12_12[var15_15] != 0);
            }
            var20_20 = new int[17];
            var21_21 = new int[18];
            var15_15 = 0;
            var22_22 = 1;
            while (var22_22 <= 16) {
                if (this.data[var3_3 + var22_22] != 0) {
                    var20_20[var22_22] = var15_15 - var13_13[var15_15];
                    var21_21[var22_22] = var13_13[(var15_15 += this.data[var3_3 + var22_22] & 255) - 1];
                } else {
                    var21_21[var22_22] = -1;
                }
                ++var22_22;
            }
            var21_21[17] = -1;
            var23_23 = new int[var17_17];
            var24_24 = 0;
            while (var24_24 < var17_17) {
                var23_23[var24_24] = this.data[var3_3 + var24_24 + 17] & 255;
                var7_7[var23_23[var24_24]][0] = var13_13[var24_24];
                var7_7[var23_23[var24_24]][1] = var12_12[var24_24];
                ++var24_24;
            }
            if (!var4_4) {
                this.dc_valoffset[var10_10] = var20_20;
                this.dc_maxcode[var10_10] = var21_21;
                this.dc_huffval[var10_10] = var23_23;
                this.enc_dc_matrix[var10_10] = var7_7;
                this.dc_huffbits[var10_10] = var14_14;
                continue;
            }
            this.ac_valoffset[var10_10] = var20_20;
            this.ac_maxcode[var10_10] = var21_21;
            this.ac_huffval[var10_10] = var23_23;
            this.enc_ac_matrix[var10_10] = var7_7;
            this.ac_huffbits[var10_10] = var14_14;
        } while ((var3_3 += var17_17 + 17) < var2_2);
        return var2_2;
    }

    void readDCT(InputStream inputStream) throws IOException {
        int[] nArray = new int[this.components_in_scan];
        int[][] nArray2 = new int[2][64];
        int n = this.restart_interval;
        if (this._Ss != 0 || this._Se != 63 || this._Ah != 0 || this._Al != 0) {
            System.err.println("Not sequential image, Ss=" + this._Ss + " Se=" + this._Se + " Ah=" + this._Ah + " Al=" + this._Al);
        }
        int n2 = (this.frm_x + 8 * this.maxHi - 1) / (8 * this.maxHi);
        int n3 = (this.frm_y + 8 * this.maxVi - 1) / (8 * this.maxVi);
        System.err.println("Size in MCU " + n2 + "x" + n3);
        HuffDecoder huffDecoder = new HuffDecoder(inputStream);
        this.dct_coefs = new int[n3][n2][this.mcusize][2][];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                int n7 = 0;
                if (this.restart_interval != 0 && n == 0) {
                    n = this.restart_interval;
                    n6 = 0;
                    while (n6 < nArray.length) {
                        nArray[n6] = 0;
                        ++n6;
                    }
                    huffDecoder.restart();
                }
                n6 = 0;
                while (n6 < this.components_in_scan) {
                    int n8 = 0;
                    while (n8 < this.V[n6] * this.H[n6]) {
                        huffDecoder.setTables(false, this.dc_table[n6]);
                        nArray[n6] = huffDecoder.extend(huffDecoder.decode(1)) + nArray[n6];
                        int n9 = 0;
                        nArray2[0][n9] = nArray[n6];
                        nArray2[1][n9++] = 0;
                        huffDecoder.setTables(true, this.ac_table[n6]);
                        int n10 = 1;
                        while (n10 < 64) {
                            int n11 = huffDecoder.decode(1);
                            int n12 = n11 >> 4;
                            if ((n11 &= 0xF) != 0) {
                                n11 = huffDecoder.extend(n11);
                                if ((n10 += n12) > 63) {
                                    System.err.println("Invalid AC index " + n10);
                                }
                                nArray2[0][n9] = n11;
                                nArray2[1][n9++] = n10;
                            } else {
                                if (n12 != 15) break;
                                n10 += n12;
                            }
                            ++n10;
                        }
                        this.dct_coefs[n4][n5][n7] = new int[2][n9];
                        System.arraycopy(nArray2[0], 0, this.dct_coefs[n4][n5][n7][0], 0, n9);
                        System.arraycopy(nArray2[1], 0, this.dct_coefs[n4][n5][n7][1], 0, n9);
                        ++n7;
                        ++n8;
                    }
                    ++n6;
                }
                --n;
                ++n5;
            }
            ++n4;
        }
    }

    void transposeImageParameters() {
        int n = this.frm_x;
        this.frm_x = this.frm_y;
        this.frm_y = n;
        int n2 = 0;
        while (n2 < this.components_in_scan) {
            n = this.V[n2];
            this.V[n2] = this.H[n2];
            this.H[n2] = n;
            ++n2;
        }
    }

    void transposeQTable() {
        int n = 0;
        while (n < this.q_table.length) {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = this.q_table[n][n2 * 8 + n3];
                    this.q_table[n][n2 * 8 + n3] = this.q_table[n][n3 * 8 + n2];
                    this.q_table[n][n3 * 8 + n2] = n4;
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    void writeDCT(OutputStream outputStream, int n) throws IOException {
        if (!this.valid) {
            throw new IOException("Can't write DCT, because an error happened at reading (" + this.getLocationName() + ")");
        }
        int[] nArray = new int[this.components_in_scan];
        HuffEncoder huffEncoder = new HuffEncoder(outputStream);
        int n2 = this.restart_interval;
        switch (n) {
            case 3: {
                int n3 = 0;
                while (n3 < this.dct_coefs[0].length) {
                    int n4 = 0;
                    while (n4 < this.dct_coefs.length) {
                        int n5;
                        int n6 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n5 = 0;
                                while (n5 < nArray.length) {
                                    nArray[n5] = 0;
                                    ++n5;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n5 = 0;
                        while (n5 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n5], this.dc_table[n5]);
                            int n7 = 0;
                            while (n7 < this.V[n5]) {
                                int n8 = 0;
                                while (n8 < this.H[n5]) {
                                    nArray[n5] = huffEncoder.encode(this.transposeDCT(this.dct_coefs[n4][n3][n6 + n8 * this.V[n5] + n7]), nArray[n5]);
                                    ++n8;
                                }
                                ++n7;
                            }
                            n6 += this.V[n5] * this.H[n5];
                            ++n5;
                        }
                        --n2;
                        ++n4;
                    }
                    ++n3;
                }
                break;
            }
            case 5: {
                int n9 = 0;
                while (n9 < this.dct_coefs[0].length) {
                    int n10 = this.dct_coefs.length - 1;
                    while (n10 >= 0) {
                        int n11;
                        int n12 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n11 = 0;
                                while (n11 < nArray.length) {
                                    nArray[n11] = 0;
                                    ++n11;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n11 = 0;
                        while (n11 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n11], this.dc_table[n11]);
                            int n13 = 0;
                            while (n13 < this.V[n11]) {
                                int n14 = this.H[n11] - 1;
                                while (n14 >= 0) {
                                    nArray[n11] = huffEncoder.encode(this.rotate90DCT(this.dct_coefs[n10][n9][n12 + n14 * this.V[n11] + n13]), nArray[n11]);
                                    --n14;
                                }
                                ++n13;
                            }
                            n12 += this.V[n11] * this.H[n11];
                            ++n11;
                        }
                        --n2;
                        --n10;
                    }
                    ++n9;
                }
                break;
            }
            case 7: {
                int n15 = this.dct_coefs[0].length - 1;
                while (n15 >= 0) {
                    int n16 = 0;
                    while (n16 < this.dct_coefs.length) {
                        int n17;
                        int n18 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n17 = 0;
                                while (n17 < nArray.length) {
                                    nArray[n17] = 0;
                                    ++n17;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n17 = 0;
                        while (n17 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n17], this.dc_table[n17]);
                            int n19 = this.V[n17] - 1;
                            while (n19 >= 0) {
                                int n20 = 0;
                                while (n20 < this.H[n17]) {
                                    nArray[n17] = huffEncoder.encode(this.rotate270DCT(this.dct_coefs[n16][n15][n18 + n20 * this.V[n17] + n19]), nArray[n17]);
                                    ++n20;
                                }
                                --n19;
                            }
                            n18 += this.V[n17] * this.H[n17];
                            ++n17;
                        }
                        --n2;
                        ++n16;
                    }
                    --n15;
                }
                break;
            }
            case 4: {
                int n21 = this.dct_coefs[0].length - 1;
                while (n21 >= 0) {
                    int n22 = this.dct_coefs.length - 1;
                    while (n22 >= 0) {
                        int n23;
                        int n24 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n23 = 0;
                                while (n23 < nArray.length) {
                                    nArray[n23] = 0;
                                    ++n23;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n23 = 0;
                        while (n23 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n23], this.dc_table[n23]);
                            int n25 = this.V[n23] - 1;
                            while (n25 >= 0) {
                                int n26 = this.H[n23] - 1;
                                while (n26 >= 0) {
                                    nArray[n23] = huffEncoder.encode(this.transverseDCT(this.dct_coefs[n22][n21][n24 + n26 * this.V[n23] + n25]), nArray[n23]);
                                    --n26;
                                }
                                --n25;
                            }
                            n24 += this.V[n23] * this.H[n23];
                            ++n23;
                        }
                        --n2;
                        --n22;
                    }
                    --n21;
                }
                break;
            }
            case 1: {
                int n27 = 0;
                while (n27 < this.dct_coefs.length) {
                    int n28 = this.dct_coefs[n27].length - 1;
                    while (n28 >= 0) {
                        int n29;
                        int n30 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n29 = 0;
                                while (n29 < nArray.length) {
                                    nArray[n29] = 0;
                                    ++n29;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n29 = 0;
                        while (n29 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n29], this.dc_table[n29]);
                            int n31 = 0;
                            while (n31 < this.V[n29]) {
                                int n32 = this.H[n29] - 1;
                                while (n32 >= 0) {
                                    nArray[n29] = huffEncoder.encode(this.flipHDct(this.dct_coefs[n27][n28][n30 + n31 * this.H[n29] + n32]), nArray[n29]);
                                    --n32;
                                }
                                ++n31;
                            }
                            n30 += this.V[n29] * this.H[n29];
                            ++n29;
                        }
                        --n2;
                        --n28;
                    }
                    ++n27;
                }
                break;
            }
            case 2: {
                int n33 = this.dct_coefs.length - 1;
                while (n33 >= 0) {
                    int n34 = 0;
                    while (n34 < this.dct_coefs[n33].length) {
                        int n35;
                        int n36 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n35 = 0;
                                while (n35 < nArray.length) {
                                    nArray[n35] = 0;
                                    ++n35;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n35 = 0;
                        while (n35 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n35], this.dc_table[n35]);
                            int n37 = this.V[n35] - 1;
                            while (n37 >= 0) {
                                int n38 = 0;
                                while (n38 < this.H[n35]) {
                                    nArray[n35] = huffEncoder.encode(this.flipVDct(this.dct_coefs[n33][n34][n36 + n37 * this.H[n35] + n38]), nArray[n35]);
                                    ++n38;
                                }
                                --n37;
                            }
                            n36 += this.V[n35] * this.H[n35];
                            ++n35;
                        }
                        --n2;
                        ++n34;
                    }
                    --n33;
                }
                break;
            }
            case 6: {
                int n39 = this.dct_coefs.length - 1;
                while (n39 >= 0) {
                    int n40 = this.dct_coefs[n39].length - 1;
                    while (n40 >= 0) {
                        int n41;
                        int n42 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n41 = 0;
                                while (n41 < nArray.length) {
                                    nArray[n41] = 0;
                                    ++n41;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n41 = 0;
                        while (n41 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n41], this.dc_table[n41]);
                            int n43 = this.V[n41] - 1;
                            while (n43 >= 0) {
                                int n44 = this.H[n41] - 1;
                                while (n44 >= 0) {
                                    nArray[n41] = huffEncoder.encode(this.rotate180Dct(this.dct_coefs[n39][n40][n42 + n43 * this.H[n41] + n44]), nArray[n41]);
                                    --n44;
                                }
                                --n43;
                            }
                            n42 += this.V[n41] * this.H[n41];
                            ++n41;
                        }
                        --n2;
                        --n40;
                    }
                    --n39;
                }
                break;
            }
            default: {
                int n45 = 0;
                while (n45 < this.dct_coefs.length) {
                    int n46 = 0;
                    while (n46 < this.dct_coefs[n45].length) {
                        int n47;
                        int n48 = 0;
                        if (this.restart_interval != 0 && n2 == 0) {
                            n2 = this.restart_interval;
                            if (this._Ss == 0) {
                                n47 = 0;
                                while (n47 < nArray.length) {
                                    nArray[n47] = 0;
                                    ++n47;
                                }
                            }
                            huffEncoder.restart();
                        }
                        n47 = 0;
                        while (n47 < this.components_in_scan) {
                            huffEncoder.setTables(this.ac_table[n47], this.dc_table[n47]);
                            int n49 = 0;
                            while (n49 < this.V[n47] * this.H[n47]) {
                                nArray[n47] = huffEncoder.encode(this.dct_coefs[n45][n46][n48], nArray[n47]);
                                ++n48;
                                ++n49;
                            }
                            ++n47;
                        }
                        --n2;
                        ++n46;
                    }
                    ++n45;
                }
                break block0;
            }
        }
        huffEncoder.flush();
    }

    int[][] transposeDCT(int[][] nArray) {
        int n;
        int[] nArray2 = new int[64];
        int n2 = 0;
        while (n2 < nArray[0].length) {
            n = jpegnaturalorder[nArray[1][n2]];
            n = ((n & 7) << 3) + (n >> 3);
            nArray2[BasicJpeg.jpegzigzagorder[n]] = nArray[0][n2];
            ++n2;
        }
        n = 1;
        n2 = 1;
        while (n2 < nArray2.length && n < nArray[0].length) {
            if (nArray2[n2] != 0) {
                nArray[1][n] = n2;
                nArray[0][n] = nArray2[nArray[1][n]];
                ++n;
            }
            ++n2;
        }
        return nArray;
    }

    int[][] rotate90DCT(int[][] nArray) {
        int n;
        int[] nArray2 = new int[64];
        int n2 = 0;
        while (n2 < nArray[0].length) {
            n = jpegnaturalorder[nArray[1][n2]];
            n = ((n & 7) << 3) + (n >> 3);
            nArray2[BasicJpeg.jpegzigzagorder[n]] = (n & 1) == 1 ? -nArray[0][n2] : nArray[0][n2];
            ++n2;
        }
        n = 1;
        n2 = 1;
        while (n2 < nArray2.length && n < nArray[0].length) {
            if (nArray2[n2] != 0) {
                nArray[1][n] = n2;
                nArray[0][n] = nArray2[nArray[1][n]];
                ++n;
            }
            ++n2;
        }
        return nArray;
    }

    int[][] rotate270DCT(int[][] nArray) {
        int n;
        int[] nArray2 = new int[64];
        int n2 = 0;
        while (n2 < nArray[0].length) {
            n = jpegnaturalorder[nArray[1][n2]];
            n = ((n & 7) << 3) + (n >> 3);
            nArray2[BasicJpeg.jpegzigzagorder[n]] = (n & 8) == 8 ? -nArray[0][n2] : nArray[0][n2];
            ++n2;
        }
        n = 1;
        n2 = 1;
        while (n2 < nArray2.length && n < nArray[0].length) {
            if (nArray2[n2] != 0) {
                nArray[1][n] = n2;
                nArray[0][n] = nArray2[nArray[1][n]];
                ++n;
            }
            ++n2;
        }
        return nArray;
    }

    int[][] transverseDCT(int[][] nArray) {
        int n;
        int[] nArray2 = new int[64];
        int n2 = 0;
        while (n2 < nArray[0].length) {
            n = jpegnaturalorder[nArray[1][n2]];
            boolean bl = (n & 1) != 0;
            n = ((n & 7) << 3) + (n >> 3);
            nArray2[BasicJpeg.jpegzigzagorder[n]] = (bl ^= (n & 1) != 0) ? -nArray[0][n2] : nArray[0][n2];
            ++n2;
        }
        n = 1;
        n2 = 1;
        while (n2 < nArray2.length && n < nArray[0].length) {
            if (nArray2[n2] != 0) {
                nArray[1][n] = n2;
                nArray[0][n] = nArray2[nArray[1][n]];
                ++n;
            }
            ++n2;
        }
        return nArray;
    }

    int[][] flipHDct(int[][] nArray) {
        int n = 0;
        while (n < nArray[0].length) {
            if ((jpegnaturalorder[nArray[1][n]] & 1) != 0) {
                nArray[0][n] = -nArray[0][n];
            }
            ++n;
        }
        return nArray;
    }

    int[][] flipVDct(int[][] nArray) {
        int n = 0;
        while (n < nArray[0].length) {
            if ((jpegnaturalorder[nArray[1][n]] & 8) == 8) {
                nArray[0][n] = -nArray[0][n];
            }
            ++n;
        }
        return nArray;
    }

    int[][] rotate180Dct(int[][] nArray) {
        int n = 0;
        while (n < nArray[0].length) {
            if ((jpegnaturalorder[nArray[1][n]] & 9) == 1 || (jpegnaturalorder[nArray[1][n]] & 9) == 8) {
                nArray[0][n] = -nArray[0][n];
            }
            ++n;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        try {
            System.setErr(new PrintStream(new FileOutputStream("MediaChest.log"), true));
        }
        catch (IOException iOException) {
            System.err.println("MediaChest: Can't redirect error stream.");
        }
        new BasicJpeg(new File(stringArray[0])).transform(stringArray[1], Integer.parseInt(stringArray[2]));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class HuffEncoder {
        private int bufferputbits;
        private int bufferputbuffer;
        private OutputStream outputstream;
        private int[][] dc_ecodetable;
        private int[][] ac_ecodetable;
        int next_restart_num;

        public HuffEncoder(OutputStream outputStream) {
            this.outputstream = outputStream;
        }

        void setTables(int n, int n2) {
            int n3 = 0;
            while (n3 < BasicJpeg.this.ac_ix.length) {
                if (BasicJpeg.this.ac_ix[n3] == n) {
                    this.ac_ecodetable = BasicJpeg.this.enc_ac_matrix[n3];
                    break;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < BasicJpeg.this.dc_ix.length) {
                if (BasicJpeg.this.dc_ix[n4] == n2) {
                    this.dc_ecodetable = BasicJpeg.this.enc_dc_matrix[n4];
                    break;
                }
                ++n4;
            }
        }

        int encode(int[][] nArray, int n) throws IOException {
            int n2 = nArray[0][0] - n;
            int n3 = n2;
            if (n3 < 0) {
                n3 = -n3;
                --n2;
            }
            int n4 = 0;
            while (n3 != 0) {
                ++n4;
                n3 >>= 1;
            }
            this.writeCode(this.dc_ecodetable[n4][0], this.dc_ecodetable[n4][1]);
            if (n4 != 0) {
                this.writeCode(n2, n4);
            }
            int n5 = 1;
            while (n5 < nArray[0].length) {
                int n6 = nArray[1][n5] - nArray[1][n5 - 1] - 1;
                n3 = nArray[0][n5];
                while (n6 > 15) {
                    this.writeCode(this.ac_ecodetable[240][0], this.ac_ecodetable[240][1]);
                    n6 -= 16;
                }
                n2 = n3;
                if (n3 < 0) {
                    n3 = -n3;
                    --n2;
                }
                n4 = 1;
                while ((n3 >>= 1) != 0) {
                    ++n4;
                }
                int n7 = (n6 << 4) + n4;
                this.writeCode(this.ac_ecodetable[n7][0], this.ac_ecodetable[n7][1]);
                this.writeCode(n2, n4);
                ++n5;
            }
            if (63 - nArray[1][nArray[0].length - 1] > 0) {
                this.writeCode(this.ac_ecodetable[0][0], this.ac_ecodetable[0][1]);
            }
            return nArray[0][0];
        }

        void restart() throws IOException {
            this.flush();
            this.outputstream.write(-1);
            this.outputstream.write(208 + this.next_restart_num);
            this.next_restart_num = this.next_restart_num + 1 & 7;
            this.bufferputbuffer = 0;
            this.bufferputbits = 0;
        }

        void writeCode(int n, int n2) throws IOException {
            int n3 = n;
            int n4 = this.bufferputbits;
            n3 &= (1 << n2) - 1;
            n3 <<= 24 - (n4 += n2);
            n3 |= this.bufferputbuffer;
            while (n4 >= 8) {
                int n5 = n3 >> 16 & 0xFF;
                this.outputstream.write(n5);
                if (n5 == 255) {
                    this.outputstream.write(0);
                }
                n3 <<= 8;
                n4 -= 8;
            }
            this.bufferputbuffer = n3;
            this.bufferputbits = n4;
        }

        void flush() throws IOException {
            int n;
            int n2 = this.bufferputbuffer;
            int n3 = this.bufferputbits;
            while (n3 >= 8) {
                n = n2 >> 16 & 0xFF;
                this.outputstream.write(n);
                if (n == 255) {
                    this.outputstream.write(0);
                }
                n2 <<= 8;
                n3 -= 8;
            }
            if (n3 > 0) {
                n = n2 >> 16 | 255 >> n3;
                this.outputstream.write(n);
            }
            this.bufferputbuffer = n2;
            this.bufferputbits = n3;
        }
    }

    class HuffDecoder {
        private InputStream is;
        int bit_buff;
        int bit_buff_len;
        int marker;
        long marker_offset;
        int next_restart_num;
        int[] cur_maxcode;
        int[] cur_huffval;
        int[] cur_valoffset;

        HuffDecoder(InputStream inputStream) {
            this.is = inputStream;
        }

        void setTables(boolean bl, int n) {
            if (bl) {
                int n2 = 0;
                while (n2 < BasicJpeg.this.ac_ix.length) {
                    if (BasicJpeg.this.ac_ix[n2] == n) {
                        this.cur_maxcode = BasicJpeg.this.ac_maxcode[n2];
                        this.cur_huffval = BasicJpeg.this.ac_huffval[n2];
                        this.cur_valoffset = BasicJpeg.this.ac_valoffset[n2];
                        break;
                    }
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < BasicJpeg.this.dc_ix.length) {
                    if (BasicJpeg.this.dc_ix[n3] == n) {
                        this.cur_maxcode = BasicJpeg.this.dc_maxcode[n3];
                        this.cur_huffval = BasicJpeg.this.dc_huffval[n3];
                        this.cur_valoffset = BasicJpeg.this.dc_valoffset[n3];
                        break;
                    }
                    ++n3;
                }
            }
        }

        void checkBitBuffer(int n) throws IOException {
            if (this.bit_buff_len < n) {
                if (n > 16) {
                    throw new IOException("An attempt to read more than 16 bit (inbuff=" + this.bit_buff_len + ", len=" + n + ") (" + BasicJpeg.this.getLocationName() + ")");
                }
                do {
                    this.bit_buff <<= 8;
                    this.bit_buff |= this.read();
                    this.bit_buff_len += 8;
                } while (this.bit_buff_len < n);
            }
        }

        int read() throws IOException {
            int n = this.is.read();
            BasicJpeg.this.readcounter++;
            if (n == -1) {
                throw new IOException("End of file reached at " + BasicJpeg.this.readcounter + " (" + BasicJpeg.this.getLocationName() + ")");
            }
            if (n == 255) {
                do {
                    n = this.is.read();
                    BasicJpeg.this.readcounter++;
                } while (n == 255);
                if (n == 0) {
                    n = 255;
                } else {
                    this.marker = n;
                    this.marker_offset = BasicJpeg.this.readcounter;
                    if (this.marker == 208 + this.next_restart_num) {
                        this.next_restart_num = this.next_restart_num + 1 & 7;
                    } else {
                        new IOException("Restart markers are messed up at 0x" + Integer.toHexString(BasicJpeg.this.readcounter) + " (" + BasicJpeg.this.getLocationName() + ")");
                    }
                    n = this.is.read();
                    BasicJpeg.this.readcounter++;
                }
            }
            return n;
        }

        int getBits(int n) throws IOException {
            this.checkBitBuffer(n);
            this.bit_buff_len -= n;
            return this.bit_buff >> this.bit_buff_len & 65535 >> 16 - n;
        }

        int extend(int n) throws IOException {
            if (n == 0) {
                return 0;
            }
            int n2 = this.getBits(n);
            return n2 < 1 << n - 1 ? n2 + ((-1 << n) + 1) : n2;
        }

        int decode(int n) throws IOException {
            int n2;
            int n3 = n;
            for (n2 = this.getBits(n3); n2 > this.cur_maxcode[n3]; n2 |= this.getBits(1)) {
                n2 <<= 1;
                if (++n3 <= 16) continue;
                throw new IOException("Corrupted JPEG data: bad Huffman code, at 0x" + Integer.toHexString(BasicJpeg.this.readcounter) + " (" + BasicJpeg.this.getLocationName() + ")");
            }
            return this.cur_huffval[n2 + this.cur_valoffset[n3]];
        }

        void restart() {
            this.bit_buff_len = 0;
            this.bit_buff = 0;
        }
    }
}

