/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.media;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.MP3;

public class ContentMatcher {
    Map artistsMap;
    Map genresMap;
    Map yearsMap;
    Map othersMap;
    boolean excludeMode;

    public boolean match(AbstractFormat abstractFormat) {
        if (abstractFormat.isValid() && abstractFormat.getType() == "MP3") {
            boolean bl;
            AbstractInfo abstractInfo = abstractFormat.getInfo();
            boolean bl2 = bl = !this.excludeMode;
            if (this.genresMap != null) {
                try {
                    bl = this.excludeMode ^ this.genresMap.get(MP3.GENRES[abstractInfo.getIntAttribute("Genre")]) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                return false;
            }
            if (this.artistsMap != null) {
                try {
                    bl = this.excludeMode ^ this.artistsMap.get(this.normalize(abstractInfo.getAttribute("Artist").toString().toCharArray())) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                return false;
            }
            if (this.yearsMap != null) {
                try {
                    bl = this.excludeMode ^ this.yearsMap.get(new Integer(abstractInfo.getIntAttribute("Year"))) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!bl) {
                return false;
            }
            if (this.othersMap != null) {
                Iterator iterator = this.othersMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    try {
                        bl = this.excludeMode ^ map.get(this.normalize(abstractInfo.getAttribute(string).toString().toCharArray())) != null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) break;
                }
            }
            return bl;
        }
        return false;
    }

    public void setArtists(Object[] objectArray) {
        this.artistsMap = this.buildMap(objectArray, true);
    }

    public void setGenres(Object[] objectArray) {
        this.genresMap = this.buildMap(objectArray, false);
    }

    public void setYears(Object[] objectArray) {
        this.yearsMap = this.buildMap(objectArray, false);
    }

    public void setExtraConditions(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        this.othersMap = new HashMap(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            int n2 = string.indexOf(123);
            if (n2 > 0) {
                String string2 = string.substring(0, n2);
                System.err.println("Val =" + string2);
                int n3 = string.indexOf(125);
                String string3 = n3 < 0 ? string.substring(n2 + 1) : string.substring(n2 + 1, n3);
                HashMap<String, String> hashMap = (HashMap<String, String>)this.othersMap.get(string3);
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                    this.othersMap.put(string3, hashMap);
                }
                String string4 = this.normalize(string2.toCharArray());
                hashMap.put(string4, string4);
            }
            ++n;
        }
    }

    public void setExcludeMode(boolean bl) {
        this.excludeMode = bl;
    }

    protected Map buildMap(Object[] objectArray, boolean bl) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (bl) {
                char[] cArray = objectArray[n].toString().toCharArray();
                String string = this.normalize(cArray);
                hashMap.put(string, cArray);
            } else {
                hashMap.put(objectArray[n], objectArray[n]);
            }
            ++n;
        }
        return hashMap;
    }

    protected String normalize(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (Character.isLetterOrDigit(cArray[n2])) {
                cArray[n++] = Character.toUpperCase(cArray[n2]);
            }
            ++n2;
        }
        if (n > 0) {
            return new String(cArray, 0, n);
        }
        throw new IllegalArgumentException("Argument " + new String(cArray) + " cannot be normalized.");
    }
}

